/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.enriquecimento.service;

import br.com.system.app.features.datastone.service.DataStoneProcessaService;
import br.com.system.app.features.datastone.service.DataStoneService;
import br.com.system.app.features.datastone.service.DataStoneSolicitaService;
import br.com.system.app.features.enriquecimento.model.Enriquecimento;
import br.com.system.app.features.enriquecimento.model.EnriquecimentoItens;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoService;
import br.com.system.app.features.shared.model.StatusProcessoEnum;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class EnriquecimentoReprocessoService {
    @Autowired
    private EnriquecimentoService enriquecimentoService;
    @Autowired
    private DataStoneProcessaService dataStoneProcessaService;
    @Autowired
    private DataStoneSolicitaService dataStoneSolicitaService;
    @Autowired
    private DataStoneService dataStoneService;

    @Async(value="asyncDefault")
    public void reprocessar(Enriquecimento e) {
        try {
            List itens = this.enriquecimentoService.getItens(e);
            HashSet<String> cnpjs = new HashSet<String>();
            for (EnriquecimentoItens iten : itens) {
                cnpjs.add(iten.getCpfCnpj());
            }
            e.setObservacao("");
            e.setStatusAnalise(StatusProcessoEnum.PROCESSANDO);
            this.enriquecimentoService.save(e);
            if (e.getDataStoneId() == null) {
                Integer tamanho = ((String)cnpjs.iterator().next()).length();
                Integer dataStoneId = this.dataStoneSolicitaService.solicitar(e.getNomeArquivo(), cnpjs, tamanho.equals(14), e.getConsultaSocios().booleanValue());
                e.setDataStoneId(dataStoneId);
                this.enriquecimentoService.save(e);
                return;
            }
            this.dataStoneProcessaService.processar(e.getDataStoneId());
            String url = this.dataStoneService.processarLote(e.getEstruturaUsuario(), cnpjs, e.getNomeArquivo(), e, e.getConsultaWhats());
            e.setUrlArquivo(url);
            e.setStatusAnalise(StatusProcessoEnum.FINALIZADO);
            e.setObservacao("");
        }
        catch (Exception ex) {
            e.setStatusAnalise(StatusProcessoEnum.FINALIZADO_COM_ERRO);
            e.setObservacao(ex.getMessage());
        }
        this.enriquecimentoService.save(e);
    }
}

