/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.equipe.service;

import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.equipe.repository.EquipeRepository;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.shared.exception.BusinessException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EquipeService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EquipeRepository equipeRepository;

    public Equipe getById(Long id) {
        return (Equipe)this.equipeRepository.findById((Object)id).get();
    }

    public List<Equipe> getEquipes(Estrutura estrutura) {
        return this.equipeRepository.findByEstrutura(estrutura);
    }

    public List<Equipe> getEquipesFilterName(Estrutura estrutura, String nomeUsuario) {
        String nomeToLike = "%" + nomeUsuario + "%";
        return this.equipeRepository.findByEstruturaAndNomeUsuario(estrutura.getId(), nomeToLike);
    }

    public Equipe salvar(Equipe equipe, Estrutura estrutura) {
        Equipe equipeSalvo;
        if (equipe.getId() != null && equipe.getId() > 0L) {
            equipeSalvo = this.equipeRepository.findByIdAndEstrutura(equipe.getId(), estrutura);
            if (equipeSalvo == null) {
                throw new BusinessException("Equipe n\u00e3o encontrado");
            }
        } else {
            equipeSalvo = new Equipe();
            equipeSalvo.setEstrutura(estrutura);
            equipeSalvo.setDataHoraCriacao(LocalDateTime.now());
        }
        BeanUtils.copyProperties((Object)equipe, (Object)equipeSalvo, (String[])new String[]{"id", "estrutura", "dataHoraCriacao", "listaEstruturaUsuario"});
        return (Equipe)this.equipeRepository.save((Object)equipeSalvo);
    }

    public void salvarEstruturaUsuario(Long equipeId, Estrutura estrutura, Set<Long> listaEstruturaUsuario) {
        Equipe equipe = this.equipeRepository.findById((Object)equipeId).orElse(null);
        if (equipe == null) {
            throw new BusinessException("Equipe n\u00e3o encontrado");
        }
        if (!equipe.getEstrutura().getId().equals(estrutura.getId())) {
            throw new BusinessException("Equipe n\u00e3o pertence a esta estrutura.");
        }
        this.equipeRepository.deleteEquipeUsuarios(equipeId);
        for (Long euId : listaEstruturaUsuario) {
            this.equipeRepository.insertEquipeUsuarios(equipeId, euId);
        }
    }

    public void deletarEquipe(Long equipeId, Estrutura estrutura) {
        Equipe equipe = this.equipeRepository.findById((Object)equipeId).orElse(null);
        this.deletarEquipe(equipe, estrutura);
    }

    public void deletarEquipe(Equipe equipe, Estrutura estrutura) {
        if (equipe == null) {
            throw new BusinessException("Equipe n\u00e3o encontrado");
        }
        if (!equipe.getEstrutura().getId().equals(estrutura.getId())) {
            throw new BusinessException("Equipe n\u00e3o pertence a esta estrutura.");
        }
        this.equipeRepository.deleteEquipeUsuarios(equipe.getId());
        this.equipeRepository.delete((Object)equipe);
    }

    public Equipe findEquipe(Long equipeId) {
        return this.equipeRepository.findById((Object)equipeId).orElse(null);
    }

    public List<Equipe> getByIds(String ids) {
        ArrayList<Equipe> ret = new ArrayList<Equipe>();
        for (String s : ids.split(",")) {
            Optional optE = this.equipeRepository.findById((Object)Long.valueOf(s));
            if (!optE.isPresent()) continue;
            ret.add((Equipe)optE.get());
        }
        return ret;
    }

    public Set<Long> getEstruturaUsuario(Equipe equipe, Long[] hierarquia) {
        Long[] euEquipe;
        HashSet<Long> retorno = new HashSet<Long>();
        block0: for (Long ide : euEquipe = this.equipeRepository.findEquipeUsuarios(equipe.getId())) {
            for (Long idh : hierarquia) {
                if (!ide.equals(idh)) continue;
                retorno.add(idh);
                continue block0;
            }
        }
        return retorno;
    }

    public void deleteByEsturura(Estrutura e) {
        this.equipeRepository.deleteByEstrutura(e);
    }
}

