/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.views;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.service.EstruturaService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.estrutura.views.EstruturaFormView;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.Horizontal;
import br.com.system.app.features.layout.size.Size;
import br.com.system.app.features.layout.size.Top;
import br.com.system.app.features.layout.util.BoxSizing;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="estrutura", layout=MainLayout.class)
@PageTitle(value="Estrutura")
@RolesAllowed(value={"MASTER"})
public class EstruturaView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final EstruturaService es;
    private final EstruturaFormView estruturaFormView;
    private GridCrud<Estrutura> crud;

    @Autowired
    public EstruturaView(EstruturaService es, EstruturaUsuarioService eus, EstruturaFormView estruturaFormView) {
        this.es = es;
        this.estruturaFormView = estruturaFormView;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        FlexBoxLayout content = new FlexBoxLayout(new Component[]{this.createCrud()});
        content.setBoxSizing(BoxSizing.BORDER_BOX);
        content.setHeightFull();
        content.setPadding(new Size[]{Horizontal.RESPONSIVE_X, Top.RESPONSIVE_X});
        return content;
    }

    private Component createCrud() {
        TextField filterName = new TextField();
        filterName.setPlaceholder("Filtrar por nome");
        filterName.setClearButtonVisible(true);
        TextField filterCnpj = new TextField();
        filterCnpj.setPlaceholder("Filtrar por CPF-CNPJ");
        filterCnpj.setClearButtonVisible(true);
        filterName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> filterCnpj.setValue(""));
        filterCnpj.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> filterName.setValue(""));
        this.crud = new GridCrud(Estrutura.class);
        Button btnChangeName = UIUtils.createSmallButton((String)"Alterar Dominio", (VaadinIcon)VaadinIcon.EXCHANGE);
        btnChangeName.addClickListener((ComponentEventListener & Serializable)e -> this.changeName());
        Button btnRefresh = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.SEARCH, (String)"Pesquisar");
        btnRefresh.addClickListener((ComponentEventListener & Serializable)e -> this.crud.refreshGrid());
        Button btnAdicionar = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar Estrutura");
        btnAdicionar.addClickListener((ComponentEventListener & Serializable)e -> this.openForm(new Estrutura()));
        Button btnUpdate = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Alterar Estrutura");
        btnUpdate.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione uma estrutura para alterar");
                return;
            }
            this.openForm((Estrutura)this.crud.getGrid().getSelectedItems().iterator().next());
        });
        this.crud.getCrudLayout().addToolbarComponent((Component)new HorizontalContainer(new Component[]{btnChangeName, filterName, filterCnpj, btnRefresh, btnAdicionar, btnUpdate}));
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
            Button btn;
            if (p.isAtivo()) {
                Icon icon = new Icon(VaadinIcon.SMILEY_O);
                icon.setColor(Color.GREEN.getValue());
                btn = new Button((Component)icon);
                btn.getElement().setProperty("title", "ATIVO, clique para Desativar");
            } else {
                Icon icon = new Icon(VaadinIcon.FROWN_O);
                icon.setColor(Color.RED.getValue());
                btn = new Button((Component)icon);
                btn.getElement().setProperty("title", "INATIVO, clique para Ativar");
            }
            btn.addClickListener((ComponentEventListener & Serializable)e -> {
                ConfirmationDialog cd = new ConfirmationDialog("Mudar status", "Esta estrutura est\u00e1 <B>" + (p.isAtivo() ? "ATIVA" : "INATIVA") + "</B><BR>Deseja <B>" + (p.isAtivo() ? "INATIVAR?" : "ATIVAR?</B>"));
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    this.es.changeStatus(p);
                    this.crud.refreshGrid();
                    cd.close();
                });
            });
            return btn;
        })).setFlexGrow(0).setWidth("60px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.isAtivo() ? "Ativo" : "Inativo")).setHeader("Status").setFlexGrow(0).setWidth("90px");
        this.crud.getGrid().addColumn("id").setFlexGrow(0).setWidth("80px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNome()))).setHeader("Nome").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().addColumn("cpfCnpj").setWidth("180px").setFlexGrow(0);
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getEstruturaTipo().getNome())).setHeader("Estrutura Tipo").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getRazaoSocial()))).setHeader("Razao Social").setFlexGrow(0).setWidth("250px");
        this.crud.getCrudFormFactory().setVisibleProperties(new String[0]);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }

    private void openForm(Estrutura e) {
        this.estruturaFormView.create(e);
        this.estruturaFormView.addOpenedChangeListener((ComponentEventListener & Serializable)o -> {
            if (!o.isOpened()) {
                this.crud.refreshGrid();
            }
        });
    }

    private void changeName() {
        if (this.crud.getGrid().getSelectedItems().size() != 1) {
            this.showNotification("Selecione um item para alterar o dominio");
            return;
        }
        Dialog dialog = new Dialog();
        TextField newName = new TextField("Novo Dominio");
        Button close = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        close.addClickListener((ComponentEventListener & Serializable)e -> dialog.close());
        Button change = UIUtils.createSmallButton((String)"Confirmar", (VaadinIcon)VaadinIcon.CHECK);
        change.addClickListener((ComponentEventListener & Serializable)e -> {
            if (newName.isEmpty()) {
                this.showNotification("Informe o dominio");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Alterar Dominio", "Tem certeza que deseja alterar o dominio?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                try {
                    Estrutura estrutura = this.es.changeName((Estrutura)this.crud.getGrid().getSelectedItems().iterator().next(), newName.getValue());
                    this.crud.getGrid().getDataProvider().refreshItem((Object)estrutura);
                    this.showNotification("Alterado com sucesso");
                    dialog.close();
                }
                catch (Exception ex) {
                    this.showNotification("Problemas: " + ex.getMessage());
                }
                cd.close();
            });
        });
        dialog.add(new Component[]{new VerticalContainer(new Component[]{newName, new FooterContainer(new Component[]{close, change})})});
        dialog.open();
    }
}

