/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.login;

import br.com.system.app.components.ReCaptcha;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.login.LoginView;
import br.com.system.app.features.login.OpcoesConfirmacao;
import br.com.system.app.features.login.model.DoisFatoresDesativacao;
import br.com.system.app.features.login.repository.DoisFatoresDesativacaoRepository;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.model.UsuarioConfirmacaoTipoEnum;
import br.com.system.app.features.usuario.model.UsuarioConfirmacaoTipoEnvioEnum;
import br.com.system.app.features.usuario.service.UsuarioConfirmacaoService;
import br.com.system.app.features.usuario.service.UsuarioSenhaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.usuario.views.UsuarioConfirmacaoItemView;
import br.com.system.app.features.usuario.views.UsuarioNovaSenhaView;
import br.com.system.commons.strings.FieldMask;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.dialog.DialogVariant;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@Route(value="recuperar-acesso")
@PageTitle(value="Recuperar Acesso")
@AnonymousAllowed
public class RecuperarAcessoView
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private final UsuarioService usuarioService;
    private final EstruturaService estruturaService;
    private final UsuarioConfirmacaoService usuarioConfirmacaoService;
    private final DoisFatoresDesativacaoRepository doisFatoresDesativacaoRepository;
    private final ConfigurationsService configurationsService;
    private final UsuarioSenhaService usuarioSenhaService;
    private TextField login;
    private ReCaptcha reCaptcha;
    private ComboBox<OpcoesConfirmacao> cb;
    private VerticalContainer vFirst;
    private VerticalContainer vSecond;
    private Button btnEnviarCodigo;
    private RadioButtonGroup<UsuarioConfirmacaoTipoEnvioEnum> rbEnvio;
    private VerticalLayout mainContainer;
    private UsuarioConfirmacaoItemView confirmacaoItemView;

    public RecuperarAcessoView(UsuarioService usuarioService, EstruturaService estruturaService, UsuarioConfirmacaoService usuarioConfirmacaoService, DoisFatoresDesativacaoRepository doisFatoresDesativacaoRepository, ConfigurationsService configurationsService, UsuarioSenhaService usuarioSenhaService) {
        this.usuarioService = usuarioService;
        this.usuarioSenhaService = usuarioSenhaService;
        this.configurationsService = configurationsService;
        this.doisFatoresDesativacaoRepository = doisFatoresDesativacaoRepository;
        this.usuarioConfirmacaoService = usuarioConfirmacaoService;
        this.estruturaService = estruturaService;
        this.getElement().getThemeList().add((Object)"dark");
        this.getStyle().set("background-image", "url('images/fundo-neo.jpg')");
        this.getStyle().set("background-size", "cover");
        this.setAlignItems(FlexComponent.Alignment.CENTER);
        this.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        this.setWidthFull();
        this.setHeightFull();
        this.create();
    }

    private void create() {
        this.mainContainer = new VerticalLayout();
        this.mainContainer.setId("mainContainer");
        this.mainContainer.setPadding(true);
        this.mainContainer.setSpacing(true);
        this.mainContainer.setAlignItems(FlexComponent.Alignment.CENTER);
        this.mainContainer.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        this.add(new Component[]{this.mainContainer});
        this.setAlignItems(FlexComponent.Alignment.CENTER);
        this.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        this.vFirst = new VerticalContainer(new Component[0]).setSpacingOn();
        this.vFirst.setId("vFirst");
        UIUtils.setShadow((Shadow)Shadow.S, (Component[])new Component[]{this.vFirst});
        this.vFirst.setWidth("310px");
        this.vFirst.setVisible(true);
        this.vSecond = new VerticalContainer(new Component[0]).setSpacingOn();
        this.vSecond.setId("vSecond");
        UIUtils.setShadow((Shadow)Shadow.S, (Component[])new Component[]{this.vSecond});
        this.vSecond.setWidth("310px");
        this.vSecond.setVisible(false);
        this.login = new TextField("Informe seu login");
        this.login.setWidthFull();
        this.reCaptcha = new ReCaptcha("6LdZ7qMZAAAAAJc8grxOpHuqcelaXBZ1e9fZ_KvQ", "6LdZ7qMZAAAAAIzCNi1z9iPrst7R2nNBToB8pXxT");
        this.btnEnviarCodigo = UIUtils.createSmallButton((String)"Enviar C\u00f3digo");
        this.rbEnvio = new RadioButtonGroup();
        this.rbEnvio.setItems((Object[])new UsuarioConfirmacaoTipoEnvioEnum[]{UsuarioConfirmacaoTipoEnvioEnum.EMAIL, UsuarioConfirmacaoTipoEnvioEnum.SMS});
        this.rbEnvio.setValue((Object)UsuarioConfirmacaoTipoEnvioEnum.EMAIL);
        this.rbEnvio.setVisible(false);
        this.cb = new ComboBox();
        this.cb.setLabel("Onde deseja receber o C\u00f3digo de verifica\u00e7\u00e3o?");
        this.cb.setWidthFull();
        this.cb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (((OpcoesConfirmacao)e.getValue()).getTipo().equals((Object)UsuarioConfirmacaoTipoEnum.TELEFONE) || ((OpcoesConfirmacao)e.getValue()).getTipo().equals((Object)UsuarioConfirmacaoTipoEnum.TELEFONE_ALTERNATIVO)) {
                this.rbEnvio.setVisible(true);
            } else {
                this.rbEnvio.setVisible(false);
            }
        });
        Button btnVoltar = UIUtils.createSmallButton((String)"Voltar");
        btnVoltar.addClickListener((ComponentEventListener & Serializable)er -> ((Button)er.getSource()).getUI().ifPresent(ui -> ui.navigate(LoginView.class)));
        Button btnReiniciarSenha = UIUtils.createSmallButton((String)"Resetar Senha");
        btnReiniciarSenha.addClickListener((ComponentEventListener & Serializable)e -> this.confirmar(true));
        Button btnDesativar2fa = UIUtils.createSmallButton((String)"Desativar 2FA");
        btnDesativar2fa.addClickListener((ComponentEventListener & Serializable)e -> this.confirmar(false));
        FooterContainer footer = new FooterContainer(new Component[]{btnVoltar, btnReiniciarSenha, btnDesativar2fa});
        footer.setWidthFull();
        this.vFirst.add(new Component[]{this.login, this.reCaptcha, footer});
        this.vSecond.add(new Component[]{this.cb, this.rbEnvio, this.btnEnviarCodigo});
        VerticalLayout card = this.getContainer();
        card.add(new Component[]{new H2("Recuperar meu acesso"), this.vFirst, this.vSecond});
        this.mainContainer.add(new Component[]{card});
    }

    private void confirmar(boolean resetSenha) {
        if (this.login.isEmpty()) {
            UIUtils.showNotification((String)"Informe um login no formato login@dominio");
            return;
        }
        if (!this.reCaptcha.isValid()) {
            UIUtils.showNotification((String)"Recaptcha Inv\u00e1lido.");
            return;
        }
        try {
            Usuario u = this.usuarioService.getByLogin(this.login.getValue());
            if (u == null) {
                UIUtils.showNotification((String)"Usu\u00e1rio n\u00e3o encontrado");
                this.getUI().ifPresent(ui -> ui.navigate(LoginView.class));
                return;
            }
            String[] arr = u.getLogin().split("@");
            if (arr.length != 2) {
                UIUtils.showNotification((String)"Login inv\u00e1lido");
                this.getUI().ifPresent(ui -> ui.navigate(LoginView.class));
                return;
            }
            Estrutura estrutura = this.estruturaService.getByNome(arr[1].trim());
            if (estrutura == null) {
                UIUtils.showNotification((String)"Login inv\u00e1lido");
                this.getUI().ifPresent(ui -> ui.navigate(LoginView.class));
                return;
            }
            if (!estrutura.isAtivo()) {
                UIUtils.showNotification((String)"Estrutura Bloqueada entre em contato com o suporte");
                this.getUI().ifPresent(ui -> ui.navigate(LoginView.class));
                return;
            }
            Optional optEu = this.usuarioService.getByUsuarioAndEstrutura(u, estrutura);
            if (!optEu.isPresent() || !((EstruturaUsuario)optEu.get()).isAtivo()) {
                UIUtils.showNotification((String)"Usu\u00e1rio n\u00e3o encontrado");
                this.getUI().ifPresent(ui -> ui.navigate(LoginView.class));
                return;
            }
            if (!resetSenha && u.getSecretCode() == null) {
                u.setSecretCode(this.usuarioService.setSecretCode((EstruturaUsuario)optEu.get()));
            }
            DoisFatoresDesativacao dois = this.doisFatoresDesativacaoRepository.findFirstByUsuarioAndDataDesativacao(u, LocalDate.now());
            Integer limite = this.configurationsService.get(ConfigurationEnum.TENTATIVAS_DESATIVACAO_2FA).getIntValue();
            if (!resetSenha && dois != null && dois.getQuantasx() >= limite) {
                UIUtils.showNotification((String)("N\u00e3o \u00e9 permitido Mais de " + limite + " desativa\u00e7\u00f5es no dia"));
                this.getUI().ifPresent(ui -> ui.navigate(LoginView.class));
                return;
            }
            this.confirmacaoItemView = new UsuarioConfirmacaoItemView(this.usuarioConfirmacaoService, this.usuarioService);
            this.cb.setItemLabelGenerator(OpcoesConfirmacao::getNameAndTipo);
            this.vSecond.setVisible(true);
            this.vFirst.setVisible(false);
            this.cb.setItems((Collection)this.getItens(u));
            this.btnEnviarCodigo.addClickListener((ComponentEventListener & Serializable)b -> {
                if (this.cb.getValue() == null) {
                    UIUtils.showNotification((String)"Selecione uma op\u00e7\u00e3o");
                    return;
                }
                this.mainContainer.setVisible(false);
                Dialog d = new Dialog();
                d.addThemeVariants((ThemeVariant[])new DialogVariant[]{DialogVariant.LUMO_NO_PADDING});
                d.setCloseOnEsc(false);
                d.setCloseOnOutsideClick(false);
                d.add(new Component[]{this.confirmacaoItemView.createCard((EstruturaUsuario)optEu.get(), ((OpcoesConfirmacao)this.cb.getValue()).getTipo(), false, (UsuarioConfirmacaoTipoEnvioEnum)this.rbEnvio.getValue(), "dark")});
                this.confirmacaoItemView.autenticar((EstruturaUsuario)optEu.get(), ((OpcoesConfirmacao)this.cb.getValue()).getTipo(), (UsuarioConfirmacaoTipoEnvioEnum)this.rbEnvio.getValue());
                this.confirmacaoItemView.getBtnConfirmar().addClickListener((ComponentEventListener & Serializable)conf -> {
                    if (this.confirmacaoItemView.isValido((EstruturaUsuario)optEu.get(), ((OpcoesConfirmacao)this.cb.getValue()).getTipo())) {
                        if (resetSenha) {
                            new UsuarioNovaSenhaView(u, this.usuarioSenhaService, true, "dark");
                        } else {
                            this.desativar2Fa(u);
                            ((Button)conf.getSource()).getUI().ifPresent(ui -> ui.navigate("login/2fadesativado"));
                            UIUtils.showNotification((String)"Autentica\u00e7\u00e3o de 2 fatores desativada por 10 MINUTOS");
                        }
                        d.close();
                    } else {
                        UIUtils.showNotification((String)"C\u00f3digo inv\u00e1lido");
                    }
                });
                d.open();
            });
        }
        catch (Exception ex) {
            UIUtils.showNotification((String)("Erro " + ex.getMessage()));
        }
    }

    private List<OpcoesConfirmacao> getItens(Usuario u) {
        ArrayList<OpcoesConfirmacao> retorno = new ArrayList<OpcoesConfirmacao>();
        if (u.getEmail() != null && !u.getEmail().isBlank()) {
            retorno.add(new OpcoesConfirmacao(UsuarioConfirmacaoTipoEnum.EMAIL, FieldMask.emailMask((String)u.getEmail())));
        }
        if (u.getEmailAlternativo() != null && !u.getEmailAlternativo().isBlank()) {
            retorno.add(new OpcoesConfirmacao(UsuarioConfirmacaoTipoEnum.EMAIL_ALTERNATIVO, FieldMask.emailMask((String)u.getEmailAlternativo())));
        }
        if (u.getCelular() != null && !u.getCelular().isBlank()) {
            retorno.add(new OpcoesConfirmacao(UsuarioConfirmacaoTipoEnum.TELEFONE, FieldMask.telMask((String)u.getCelular())));
        }
        if (u.getCelularAlternativo() != null && !u.getCelularAlternativo().isBlank()) {
            retorno.add(new OpcoesConfirmacao(UsuarioConfirmacaoTipoEnum.TELEFONE_ALTERNATIVO, FieldMask.telMask((String)u.getCelularAlternativo())));
        }
        return retorno;
    }

    private VerticalLayout getContainer() {
        VerticalLayout lay = new VerticalLayout();
        lay.setId("lay");
        lay.getStyle().set("background-color", "var(--lumo-shade-90pct)");
        lay.setMaxWidth("380px");
        lay.setAlignItems(FlexComponent.Alignment.CENTER);
        lay.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        return lay;
    }

    private void desativar2Fa(Usuario u) {
        DoisFatoresDesativacao dois = this.doisFatoresDesativacaoRepository.findFirstByUsuarioAndDataDesativacao(u, LocalDate.now());
        if (dois == null) {
            dois = new DoisFatoresDesativacao();
            dois.setDataDesativacao(LocalDate.now());
            dois.setUsuario(u);
        }
        dois.setAtivo(true);
        dois.setQuantasx(Integer.valueOf(dois.getQuantasx() == null ? 1 : dois.getQuantasx() + 1));
        dois.setUltimaHora(LocalTime.now());
        String obs = "Desativado as " + LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
        dois.setObservacao(dois.getObservacao() != null ? dois.getObservacao() + "\n" + obs : obs);
        this.doisFatoresDesativacaoRepository.save((Object)dois);
    }
}

