/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.naoperturbe;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.naoperturbe.service.NaoPerturbeService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="nao-perturbe-atualizacao", layout=MainLayout.class)
@PageTitle(value="Atualiza\u00e7\u00e3o base n\u00e3o perturbe")
@RolesAllowed(value={"MASTER"})
public class NaoPerturbeAtualizacaoView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final NaoPerturbeService naoPerturbeService;

    @Autowired
    public NaoPerturbeAtualizacaoView(NaoPerturbeService naoPerturbeService) {
        this.naoPerturbeService = naoPerturbeService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent((Component)this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private VerticalContainer createContent() {
        VerticalContainer h = new VerticalContainer(new Component[0]);
        TextArea link = new TextArea("NOME DOS ARQUIVOS NO GOOGLE STORAGE");
        link.setWidth("500px");
        link.setHeight("500px");
        Button b = UIUtils.createSmallButton((String)"Importar Arquivos");
        b.addClickListener((ComponentEventListener & Serializable)e -> {
            try {
                HashSet<String> s = new HashSet<String>();
                for (String a : link.getValue().split("\n")) {
                    if ((a = a.trim()).isEmpty()) continue;
                    s.add(a);
                }
                ConfirmationDialog cd = new ConfirmationDialog("Importa\u00e7\u00e3o Nao Perturbe", "Confirma a importa\u00e7\u00e3o de " + s.size() + " arquivos?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    this.naoPerturbeService.processar(this.getEu(), s);
                    cd.close();
                    this.showNotification("Importa\u00e7\u00e3o iniciada. Ao final voc\u00ea ser\u00e1 notificado");
                });
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)ex.getMessage());
            }
        });
        h.add(new Component[]{link, b});
        return h;
    }
}

