/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.notificacoes.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.notificacoes.model.NotificacoesLog;
import br.com.system.app.features.notificacoes.model.NotificacoesTipoEnum;
import br.com.system.app.features.notificacoes.repository.NotificacoesLogRepository;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificacoesLogService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private NotificacoesLogRepository notificacoesLogRepository;

    public void gravarErro(EstruturaUsuario eu, String erro) {
        NotificacoesLog l = new NotificacoesLog();
        l.setDataHora(LocalDateTime.now());
        l.setEstruturaUsuario(eu);
        l.setErro(erro);
        l.setTipo(NotificacoesTipoEnum.EMAIL);
        this.notificacoesLogRepository.save((Object)l);
    }

    public NotificacoesLog gravarEmail(EstruturaUsuario eu, String email, String mensagem) {
        NotificacoesLog l = new NotificacoesLog();
        l.setDataHora(LocalDateTime.now());
        l.setEmail(email);
        l.setEstruturaUsuario(eu);
        l.setMensagem(mensagem);
        l.setTipo(NotificacoesTipoEnum.EMAIL);
        return (NotificacoesLog)this.notificacoesLogRepository.save((Object)l);
    }

    public NotificacoesLog gravarWhats(EstruturaUsuario eu, String numeroDestino, String mensagem) {
        NotificacoesLog l = new NotificacoesLog();
        l.setDataHora(LocalDateTime.now());
        l.setNumero(numeroDestino);
        l.setEstruturaUsuario(eu);
        l.setMensagem(mensagem);
        l.setTipo(NotificacoesTipoEnum.WHATSAPP);
        return (NotificacoesLog)this.notificacoesLogRepository.save((Object)l);
    }

    public void deleteByEstrutura(Estrutura e) {
        this.notificacoesLogRepository.deleteByEstruturaUsuarioEstrutura(e);
    }
}

