/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.repository;

import br.com.system.app.features.pedido.dto.PedidoNotificacaoDTO;
import br.com.system.app.features.pedido.repository.PedidoNotificacaoRepositoryQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Set;
import org.springframework.transaction.annotation.Transactional;

public class PedidoNotificacaoRepositoryImpl
implements PedidoNotificacaoRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public List<PedidoNotificacaoDTO> findByEstruturaUsuarioId(Long euId, boolean admin) {
        Object sql = "select (select uuid_short()) as id,pn.id notificacao_id,p.id pedido_id, p.numero as numero_atividade,c.cpf_cnpj cpf_cnpj_cliente,c.nome nome_cliente,pn.data data_notificacao,pn.hora hora_notificacao,p.complementos informacoes,pn.observacao,u.nome nome_usuario,pn.tipo,pn.quem from pedido_notificacao pn join pedido p on (pn.pedido_id=p.id)";
        sql = admin ? (String)sql + " join estrutura_usuario eu on (p.estrutura_usuario_adm_id=eu.id)" : (String)sql + " join estrutura_usuario eu on (p.estrutura_usuario_id=eu.id)";
        sql = (String)sql + " join usuario u on (eu.usuario_id=u.id) join cliente c on (p.cliente_id=c.id)";
        sql = admin ? (String)sql + " WHERE p.estrutura_usuario_adm_id=:estruturaUsuarioId" : (String)sql + " WHERE p.estrutura_usuario_id=:estruturaUsuarioId";
        Query query = this.manager.createNativeQuery((String)sql, PedidoNotificacaoDTO.class);
        query.setParameter("estruturaUsuarioId", (Object)euId);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<PedidoNotificacaoDTO> findForExportation(Set<Long> hierarquia, LocalDate inicio, LocalDate fim) {
        String sql = "select (select uuid_short()) as id,pn.id notificacao_id,p.id pedido_id, p.numero as numero_atividade,c.cpf_cnpj cpf_cnpj_cliente,c.nome nome_cliente,pn.data data_notificacao,pn.hora hora_notificacao,p.complementos informacoes,pn.observacao,u.nome nome_usuario,pn.tipo,pn.quem from pedido_notificacao pn join pedido p on (pn.pedido_id=p.id) join estrutura_usuario eu on (p.estrutura_usuario_id=eu.id) join usuario u on (eu.usuario_id=u.id) join cliente c on (p.cliente_id=c.id) WHERE p.estrutura_usuario_id in :hierarquia AND pn.data >= :inicio and pn.data<=:fim";
        Query query = this.manager.createNativeQuery(sql, PedidoNotificacaoDTO.class);
        query.setParameter("hierarquia", hierarquia);
        query.setParameter("inicio", (Object)inicio);
        query.setParameter("fim", (Object)fim);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<PedidoNotificacaoDTO> findNotificar(LocalDate data, LocalTime hora) {
        String sql = "select (select uuid_short()) as id,pn.id notificacao_id,p.id pedido_id, p.numero as numero_atividade,c.cpf_cnpj cpf_cnpj_cliente,c.nome nome_cliente,pn.data data_notificacao,pn.hora hora_notificacao,p.complementos informacoes,pn.observacao,u.nome nome_usuario,pn.tipo,pn.quem from pedido_notificacao pn join pedido p on (pn.pedido_id=p.id) join estrutura_usuario eu on (p.estrutura_usuario_id=eu.id) join usuario u on (eu.usuario_id=u.id) join estrutura e on (eu.estrutura_id=e.id) join cliente c on (p.cliente_id=c.id) WHERE e.ativo=1 and eu.ativo=1 AND pn.data =:data AND pn.hora <=:hora AND pn.notificada=0";
        Query query = this.manager.createNativeQuery(sql, PedidoNotificacaoDTO.class);
        query.setParameter("data", (Object)data);
        query.setParameter("hora", (Object)hora);
        return query.getResultList();
    }
}

