/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.repository;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pedido.dto.AtividadeTagsActionEnum;
import br.com.system.app.features.pedido.dto.PedidoEtapaDTO;
import br.com.system.app.features.pedido.dto.PedidoResumeDTO;
import br.com.system.app.features.pedido.repository.PedidoRepositoryQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.transaction.annotation.Transactional;

public class PedidoRepositoryImpl
implements PedidoRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional
    public void updateListaPedidoTags(Estrutura estrutura, AtividadeTagsActionEnum action, String tags, Set<Long> ids) {
        StringBuilder sql = new StringBuilder();
        sql.append("update pedido,estrutura_usuario set ");
        if (action.equals((Object)AtividadeTagsActionEnum.INSERIR)) {
            sql.append("pedido.tags=TAG_CHANGE(pedido.tags,'").append(tags).append("','INSERIR')");
            sql.append(" where not find_in_set(:tag,pedido.tags)");
        } else if (action.equals((Object)AtividadeTagsActionEnum.EXCLUIR)) {
            sql.append("pedido.tags=TAG_CHANGE(tags,'").append(tags).append("','EXCLUIR')");
            sql.append(" where find_in_set(:tag,pedido.tags) ");
        } else if (action.equals((Object)AtividadeTagsActionEnum.LIMPAR)) {
            sql.append("pedido.tags=''");
            sql.append(" where 1=1");
        } else if (action.equals((Object)AtividadeTagsActionEnum.SOBREPOR)) {
            sql.append("pedido.tags=:tag");
            sql.append(" where 1=1");
        }
        sql.append(" and pedido.estrutura_usuario_id=estrutura_usuario.id");
        sql.append(" and estrutura_usuario.estrutura_id=:estruturaId");
        sql.append(" and pedido.id in :ids");
        Query query = this.manager.createNativeQuery(sql.toString());
        if (!action.equals((Object)AtividadeTagsActionEnum.LIMPAR)) {
            query.setParameter("tag", (Object)tags);
        }
        query.setParameter("estruturaId", (Object)estrutura.getId());
        query.setParameter("ids", ids);
        query.executeUpdate();
    }

    @Transactional(readOnly=true)
    public List<PedidoResumeDTO> findForResume(EstruturaUsuario eu, String cpfCnpj) {
        StringBuilder sql = new StringBuilder();
        sql.append("select p.id, p.numero,pe.nome as status,p.data_cadastro,p.data_hora_atualizacao,p.estrutura_usuario_id, p.pedido_tipo as tipo_atividade,p.tags,p.compromisso_mensal,p.total,p.data_retorno_futuro,u.login from pedido p,pedido_etapa pe,cliente c,estrutura_usuario eu,usuario u where p.pedido_etapa_id=pe.id  and p.cliente_id=c.id and p.estrutura_usuario_id=eu.id and eu.usuario_id=u.id and eu.estrutura_id=:estruturaId and c.cpf_cnpj=:cpfCnpj and (p.numero_pedido_origem is null or p.numero_pedido_origem='') order by p.data_hora_atualizacao desc");
        Query query = this.manager.createNativeQuery(sql.toString(), PedidoResumeDTO.class);
        query.setParameter("estruturaId", (Object)eu.getEstrutura().getId());
        query.setParameter("cpfCnpj", (Object)cpfCnpj);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<PedidoEtapaDTO> findByEtapaAndAtualizacao(Estrutura estrutura, LocalDateTime dataInicial, LocalDateTime dataFinal, Set<Long> etapaIds) {
        String sql = "select p.id, p.numero, pe.nome status, p.data_hora_atualizacao data_atualizacao  from pedido p,pedido_etapa pe,estrutura_usuario eu where p.pedido_etapa_id=pe.id AND p.estrutura_usuario_id=eu.id and eu.estrutura_id=:estruturaId AND p.pedido_etapa_id in :pedidoEtapaIds AND p.data_hora_atualizacao >= :dataInicial AND p.data_hora_atualizacao <= :dataFinal";
        Query query = this.manager.createNativeQuery(sql, PedidoEtapaDTO.class);
        query.setParameter("estruturaId", (Object)estrutura.getId());
        query.setParameter("pedidoEtapaIds", etapaIds);
        query.setParameter("dataInicial", (Object)dataInicial);
        query.setParameter("dataFinal", (Object)dataFinal);
        return query.getResultList();
    }
}

