/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.RandomUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FacebookIntegration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaComplementoService estruturaService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;
    @Autowired
    private UsuarioService usuarioService;

    public void doIntegration(ServletRequest request, ServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("json");
        }
        catch (IOException e) {
            return;
        }
        try {
            String token = request.getParameter("token");
            EstruturaComplemento estruturaCompl = this.estruturaService.getByTokenIntegration(token);
            if (estruturaCompl == null) {
                out.print("FORBIDEN");
                return;
            }
            String body = InputStreamUtil.toString((InputStream)request.getInputStream());
            if (body.isEmpty()) {
                throw new Exception("Body is empty");
            }
            JSONObject jsonBody = new JSONObject(body);
            StringBuilder dados = new StringBuilder();
            JSONArray campos = jsonBody.names();
            String cnpj = "";
            String telefone1 = "";
            String tagUsuario = "";
            String nomeCampanha = "";
            String usuario = "";
            for (int i = 0; i < campos.length(); ++i) {
                String campo = campos.getString(i);
                if (campo.startsWith("raw_")) continue;
                dados.append(campo).append(": ").append(jsonBody.get(campo).toString()).append("\n");
                if (campo.toUpperCase().contains("CNPJ")) {
                    cnpj = StringUtil.numbersOnly((String)jsonBody.getString(campo));
                }
                if (campo.contains("telefone") && telefone1.isBlank()) {
                    telefone1 = jsonBody.getString(campo);
                }
                if (campo.contains("campaign_name")) {
                    nomeCampanha = jsonBody.getString(campo);
                }
                if (campo.toUpperCase().equals("USUARIO")) {
                    usuario = jsonBody.getString(campo);
                }
                if (!campo.toUpperCase().equals("TAGUSUARIO")) continue;
                tagUsuario = jsonBody.getString(campo);
            }
            if (!ValidationUtil.isValidCnpjAndCpf((String)cnpj)) {
                cnpj = estruturaCompl.getEstrutura().getCpfCnpj();
            }
            Pedido pedido = new Pedido();
            EstruturaUsuario master = this.estruturaUsuarioService.getMasterEstrutura(estruturaCompl.getEstrutura());
            if (!usuario.isEmpty()) {
                Usuario user = this.usuarioService.getByLogin(usuario);
                if (user == null) {
                    return;
                }
                EstruturaUsuario eu = (EstruturaUsuario)this.estruturaUsuarioService.getByUsuarioAndEstrutura(user, estruturaCompl.getEstrutura()).get();
                pedido.setEstruturaUsuario(eu);
            } else if (!tagUsuario.isEmpty()) {
                List eus = this.estruturaUsuarioService.getByUserTag(estruturaCompl.getEstrutura(), tagUsuario);
                if (eus.size() <= 0) {
                    pedido.setEstruturaUsuario(master);
                } else {
                    Integer ind = RandomUtil.getRandom((Integer)0, (Integer)(eus.size() - 1));
                    pedido.setEstruturaUsuario((EstruturaUsuario)eus.get(ind));
                }
            } else {
                pedido.setEstruturaUsuario(master);
            }
            pedido.setCliente(this.clienteService.getAndCreateCliente(master, cnpj, new ClienteContato[0]));
            pedido.setComplementos(dados.toString());
            pedido.setTags("#leadFacebook,#" + nomeCampanha);
            pedido.setPedidoTipo(PedidoTipoEnum.COMERCIAL);
            this.pedidoService.salvar(pedido);
            JSONObject jsonRetorno = new JSONObject();
            jsonRetorno.put("success", true);
            out.print(jsonRetorno.toString());
            jsonBody = null;
            jsonRetorno = null;
            dados = null;
        }
        catch (Exception e) {
            JSONObject jsonRetorno = new JSONObject();
            jsonRetorno.put("success", false);
            jsonRetorno.put("erro", (Object)e.getMessage());
            out.print(jsonRetorno.toString());
        }
        out.close();
    }
}

