/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.dto.PedidoMovimentacaoDTO;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoMovimentacao;
import br.com.system.app.features.pedido.repository.PedidoMovimentacaoRepository;
import br.com.system.app.features.pedido.repository.PedidoRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PedidoMovimentacaoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private PedidoMovimentacaoRepository pedidoMovimentacaoRepository;

    @Async(value="asyncDefault")
    public void insertMovimentacao(Set<Long> pedidoId, EstruturaUsuario eu, String movimentacao, boolean notificar) {
        Thread.currentThread().setName("asyncDefault-insert-movimentacao");
        this.insertMovimentacao(pedidoId, eu, movimentacao, notificar, true);
    }

    @Async(value="asyncDefault")
    public void insertMovimentacao(Set<Long> pedidoId, EstruturaUsuario eu, String movimentacao, boolean notificar, boolean forcar) {
        Thread.currentThread().setName("asyncDefault-insert-movimentacao2");
        for (Long p : pedidoId) {
            this.insertMovimentacao(p, eu, movimentacao, notificar, forcar);
        }
    }

    @Transactional
    public PedidoMovimentacao insertMovimentacao(Long pedidoId, EstruturaUsuario eu, String movimentacao) {
        return this.insertMovimentacao(pedidoId, eu, movimentacao, true, true);
    }

    @Transactional
    public PedidoMovimentacao insertMovimentacao(Long pedidoId, EstruturaUsuario eu, String movimentacao, boolean notificar, boolean forcar) {
        Pedido pedido = (Pedido)this.pedidoRepository.findById((Object)pedidoId).get();
        return this.insertMovimentacao(pedido, eu, movimentacao, notificar, forcar);
    }

    @Transactional
    public PedidoMovimentacao insertMovimentacao(Pedido pedido, EstruturaUsuario eu, String movimentacao, boolean notificar, boolean forcar) {
        if (movimentacao.isBlank()) {
            throw new BusinessException("Sem descritivo da movimentacao");
        }
        if (!forcar && !pedido.getPedidoEtapa().isEditavel()) {
            return null;
        }
        PedidoMovimentacao pm = new PedidoMovimentacao(pedido, eu, LocalDateTime.now(), movimentacao);
        if (notificar) {
            this.notificacoesService.notify(pedido.getEstruturaUsuario(), "Atividade #" + pedido.getId() + " Movimentada", "<BR>Cliente: " + pedido.getCliente().getNome() + "<BR>" + movimentacao);
        }
        return (PedidoMovimentacao)this.pedidoMovimentacaoRepository.save((Object)pm);
    }

    public List<PedidoMovimentacao> getByPedido(Pedido pedido) {
        return this.pedidoMovimentacaoRepository.findByPedidoOrderByIdDesc(pedido);
    }

    public List<PedidoMovimentacao> getByPedidoOrigem(String pedidoOrigem) {
        return this.pedidoMovimentacaoRepository.findByPedidoNumeroOrderByIdDesc(pedidoOrigem);
    }

    public List<PedidoMovimentacao> getByPedidoAndOrigem(Pedido pedido, String numeroPedidoOrigem) {
        return this.pedidoMovimentacaoRepository.findByPedidoIdOrPedidoNumeroOrderByIdDesc(pedido.getId(), numeroPedidoOrigem);
    }

    public PedidoMovimentacao save(PedidoMovimentacao pm) {
        return (PedidoMovimentacao)this.pedidoMovimentacaoRepository.save((Object)pm);
    }

    public PedidoMovimentacao getLast(Pedido pedido) {
        return this.pedidoMovimentacaoRepository.findFirstByPedidoOrderByIdDesc(pedido);
    }

    public List<PedidoMovimentacaoDTO> getByListPedido(Set<Long> listaId) {
        return this.pedidoMovimentacaoRepository.findByListPedido(listaId);
    }
}

