/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.service.AtividadeHtmlProposta;
import br.com.system.app.features.pedido.service.PedidoService;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.PrintWriter;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AtividadePropostaView
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private AtividadeHtmlProposta atividadeHtml;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void show(ServletRequest request, ServletResponse response) {
        PrintWriter out = null;
        try {
            out = response.getWriter();
            response.setContentType("text/html");
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String id = httpRequest.getParameter("id");
            Boolean rl = httpRequest.getParameter("rl") != null && httpRequest.getParameter("rl").equals("true");
            if (id == null || id.isBlank()) {
                out.print("Desculpe, Proposta n\u00e3o localizada");
                out.close();
                return;
            }
            Pedido pedido = this.pedidoService.getByHashProposta(id);
            if (pedido == null) {
                out.print("Desculpe, Proposta n\u00e3o localizada");
                out.close();
                return;
            }
            String texto = rl != false ? this.atividadeHtml.getResumoLinhas(pedido) : this.atividadeHtml.gerarHtml(pedido);
            out.println(texto);
            return;
        }
        catch (Exception e) {
            out.println("Erro ao buscar proposta, tente novamente mais tarde");
            return;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }
}

