/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.dto;

import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.service.LeadTypeEnum;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Entity
public class ProducaoPedidoDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private Long id;
    private String numeroPedido;
    private String cpfCnpj;
    private String nomeCliente;
    private LocalDateTime dataHoraAtualizacao;
    private LocalDateTime dataHoraUltimaMov;
    private LocalDate dataCadastro;
    private String nomeStatus;
    private String nomeUsuario;
    private String nomeUsuarioAdm;
    private String numeroPedidoVinculado;
    private String numeroPedidoOrigem;
    private String numeroSimulacao;
    private String numeroCotacao;
    private String tags;
    private String loginOperadora;
    private String complementos;
    private LocalDate dataRetornoFuturo;
    private Long pedidoEtapaId;
    private String notasFiscais;
    private Long whatsappAtendimentoId;
    private String whatsappNumero;
    private String whatsappNome;
    private boolean whatsappFechado;
    private String whatsUltimaMensagem;
    private String whatsappEscolhaTipo;
    private Boolean whatsLida;
    private String whatsLogin;
    private String pedidoCategoria;
    private String pedidoSubCategoria;
    private Boolean atualizaDataReferencia;
    @Enumerated(value=EnumType.STRING)
    private PedidoTipoEnum pedidoTipo;
    @Enumerated(value=EnumType.STRING)
    private LeadTypeEnum leadSistema;
    private String nomeEtapaOrigem;
    private Long pedidoOrigemId;
    private String nomeOrigem;
    private String loginUsuario;
    private String equipeUsuario;
    private String tagUsuario;
    private Integer etapaSlaDias;
    private String tempo;
    private Integer slaHoras;
    private Boolean editavel;

    public ProducaoPedidoDTO(Long id) {
        this.id = id;
    }

    public ProducaoPedidoDTO() {
    }

    public ProducaoPedidoDTO convert(Pedido pedido) {
        this.setId(pedido.getId());
        this.setDataCadastro(pedido.getDataCadastro());
        this.setDataHoraAtualizacao(pedido.getDataHoraAtualizacao());
        this.setNomeCliente(pedido.getCliente().getNome());
        this.setNomeUsuario(pedido.getEstruturaUsuario().getUsuario().getNome());
        this.setNomeStatus(pedido.getPedidoEtapa().getNome());
        this.setNumeroPedido(pedido.getNumero());
        this.setNumeroPedidoOrigem(pedido.getNumeroPedidoOrigem());
        this.setNumeroPedidoVinculado(pedido.getNumeroPedidoVinculado());
        this.setDataRetornoFuturo(pedido.getDataRetornoFuturo());
        this.setNotasFiscais(this.getNotasFiscais());
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumeroPedido() {
        return this.numeroPedido;
    }

    public void setNumeroPedido(String numeroPedido) {
        this.numeroPedido = numeroPedido;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public String getNomeCliente() {
        return this.nomeCliente;
    }

    public void setNomeCliente(String nomeCliente) {
        this.nomeCliente = nomeCliente;
    }

    public LocalDateTime getDataHoraAtualizacao() {
        return this.dataHoraAtualizacao;
    }

    public void setDataHoraAtualizacao(LocalDateTime dataHoraAtualizacao) {
        this.dataHoraAtualizacao = dataHoraAtualizacao;
    }

    public LocalDate getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(LocalDate dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public String getNomeStatus() {
        return this.nomeStatus;
    }

    public void setNomeStatus(String nomeStatus) {
        this.nomeStatus = nomeStatus;
    }

    public String getNomeUsuario() {
        return this.nomeUsuario;
    }

    public void setNomeUsuario(String nomeUsuario) {
        this.nomeUsuario = nomeUsuario;
    }

    public String getNomeUsuarioAdm() {
        return this.nomeUsuarioAdm;
    }

    public void setNomeUsuarioAdm(String nomeUsuarioAdm) {
        this.nomeUsuarioAdm = nomeUsuarioAdm;
    }

    public String getNumeroPedidoVinculado() {
        return this.numeroPedidoVinculado;
    }

    public void setNumeroPedidoVinculado(String numeroPedidoVinculado) {
        this.numeroPedidoVinculado = numeroPedidoVinculado;
    }

    public String getNumeroPedidoOrigem() {
        return this.numeroPedidoOrigem;
    }

    public void setNumeroPedidoOrigem(String numeroPedidoOrigem) {
        this.numeroPedidoOrigem = numeroPedidoOrigem;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getLoginOperadora() {
        return this.loginOperadora;
    }

    public void setLoginOperadora(String loginOperadora) {
        this.loginOperadora = loginOperadora;
    }

    public String getComplementos() {
        return this.complementos;
    }

    public void setComplementos(String complementos) {
        this.complementos = complementos;
    }

    public LeadTypeEnum getLeadSistema() {
        return this.leadSistema;
    }

    public void setLeadSistema(LeadTypeEnum leadSistema) {
        this.leadSistema = leadSistema;
    }

    public LocalDate getDataRetornoFuturo() {
        return this.dataRetornoFuturo;
    }

    public void setDataRetornoFuturo(LocalDate dataRetornoFuturo) {
        this.dataRetornoFuturo = dataRetornoFuturo;
    }

    public Long getPedidoEtapaId() {
        return this.pedidoEtapaId;
    }

    public void setPedidoEtapaId(Long pedidoEtapaId) {
        this.pedidoEtapaId = pedidoEtapaId;
    }

    public PedidoTipoEnum getPedidoTipo() {
        return this.pedidoTipo;
    }

    public void setPedidoTipo(PedidoTipoEnum pedidoTipo) {
        this.pedidoTipo = pedidoTipo;
    }

    public String getNotasFiscais() {
        return this.notasFiscais;
    }

    public void setNotasFiscais(String notasFiscais) {
        this.notasFiscais = notasFiscais;
    }

    public String getNomeEtapaOrigem() {
        return this.nomeEtapaOrigem;
    }

    public void setNomeEtapaOrigem(String nomeEtapaOrigem) {
        this.nomeEtapaOrigem = nomeEtapaOrigem;
    }

    public Long getPedidoOrigemId() {
        return this.pedidoOrigemId;
    }

    public void setPedidoOrigemId(Long pedidoOrigemId) {
        this.pedidoOrigemId = pedidoOrigemId;
    }

    public String getNomeOrigem() {
        return this.nomeOrigem;
    }

    public void setNomeOrigem(String nomeOrigem) {
        this.nomeOrigem = nomeOrigem;
    }

    public String getLoginUsuario() {
        return this.loginUsuario;
    }

    public void setLoginUsuario(String loginUsuario) {
        this.loginUsuario = loginUsuario;
    }

    public String getEquipeUsuario() {
        return this.equipeUsuario;
    }

    public void setEquipeUsuario(String equipeUsuario) {
        this.equipeUsuario = equipeUsuario;
    }

    public String getTagUsuario() {
        return this.tagUsuario;
    }

    public void setTagUsuario(String tagUsuario) {
        this.tagUsuario = tagUsuario;
    }

    public Integer getEtapaSlaDias() {
        return this.etapaSlaDias;
    }

    public void setEtapaSlaDias(Integer etapaSlaDias) {
        this.etapaSlaDias = etapaSlaDias;
    }

    public LocalDateTime getDataHoraUltimaMov() {
        return this.dataHoraUltimaMov;
    }

    public void setDataHoraUltimaMov(LocalDateTime dataHoraUltimaMov) {
        this.dataHoraUltimaMov = dataHoraUltimaMov;
    }

    public String getTempo() {
        return this.tempo;
    }

    public void setTempo(String tempo) {
        this.tempo = tempo;
    }

    public Integer getSlaHoras() {
        return this.slaHoras;
    }

    public void setSlaHoras(Integer slaHoras) {
        this.slaHoras = slaHoras;
    }

    public String getWhatsappNumero() {
        return this.whatsappNumero;
    }

    public void setWhatsappNumero(String whatsappNumero) {
        this.whatsappNumero = whatsappNumero;
    }

    public String getWhatsappNome() {
        return this.whatsappNome;
    }

    public void setWhatsappNome(String whatsappNome) {
        this.whatsappNome = whatsappNome;
    }

    public boolean isWhatsappFechado() {
        return this.whatsappFechado;
    }

    public void setWhatsappFechado(boolean whatsappFechado) {
        this.whatsappFechado = whatsappFechado;
    }

    public Long getWhatsappAtendimentoId() {
        return this.whatsappAtendimentoId;
    }

    public void setWhatsappAtendimentoId(Long whatsappAtendimentoId) {
        this.whatsappAtendimentoId = whatsappAtendimentoId;
    }

    public Boolean getEditavel() {
        return this.editavel;
    }

    public void setEditavel(Boolean editavel) {
        this.editavel = editavel;
    }

    public String getNumeroSimulacao() {
        return this.numeroSimulacao;
    }

    public void setNumeroSimulacao(String numeroSimulacao) {
        this.numeroSimulacao = numeroSimulacao;
    }

    public String getNumeroCotacao() {
        return this.numeroCotacao;
    }

    public void setNumeroCotacao(String numeroCotacao) {
        this.numeroCotacao = numeroCotacao;
    }

    public String getPedidoCategoria() {
        return this.pedidoCategoria;
    }

    public void setPedidoCategoria(String pedidoCategoria) {
        this.pedidoCategoria = pedidoCategoria;
    }

    public String getPedidoSubCategoria() {
        return this.pedidoSubCategoria;
    }

    public void setPedidoSubCategoria(String pedidoSubCategoria) {
        this.pedidoSubCategoria = pedidoSubCategoria;
    }

    public Boolean getAtualizaDataReferencia() {
        return this.atualizaDataReferencia;
    }

    public void setAtualizaDataReferencia(Boolean atualizaDataReferencia) {
        this.atualizaDataReferencia = atualizaDataReferencia;
    }

    public String getWhatsUltimaMensagem() {
        return this.whatsUltimaMensagem;
    }

    public void setWhatsUltimaMensagem(String whatsUltimaMensagem) {
        this.whatsUltimaMensagem = whatsUltimaMensagem;
    }

    public Boolean getWhatsLida() {
        return this.whatsLida;
    }

    public void setWhatsLida(Boolean whatsLida) {
        this.whatsLida = whatsLida;
    }

    public String getWhatsappEscolhaTipo() {
        return this.whatsappEscolhaTipo;
    }

    public void setWhatsappEscolhaTipo(String whatsappEscolhaTipo) {
        this.whatsappEscolhaTipo = whatsappEscolhaTipo;
    }

    public String getWhatsLogin() {
        return this.whatsLogin;
    }

    public void setWhatsLogin(String whatsLogin) {
        this.whatsLogin = whatsLogin;
    }
}

