/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaTipoService;
import br.com.system.app.features.pedido.dto.PedidoMovimentacaoDTO;
import br.com.system.app.features.pedido.dto.PedidoStatusDTO;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.service.PedidoMovimentacaoService;
import br.com.system.app.features.pedido.service.PedidoStatusService;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoDTO;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PainelAtividadeExportacaoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaTipoService ets;
    @Autowired
    private PedidoStatusService pedidoStatusService;
    @Autowired
    private PedidoMovimentacaoService pedidoMovimentacaoService;

    public String exportMovimentacao(EstruturaUsuario eu, Set<Long> atividades) {
        List movimentacao = this.pedidoMovimentacaoService.getByListPedido(atividades);
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = StorageUtil.getObjectModelo((String)"ExportacaoMovimentacao-v1.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            CellStyle styleCellDouble = xls.createCellStyle();
            styleCellDouble.setDataFormat((short)2);
            int linha = 1;
            for (PedidoMovimentacaoDTO p : movimentacao) {
                Row row = aba.createRow(linha);
                row.createCell(0).setCellValue(p.getNumero());
                row.createCell(1).setCellValue(p.getCnpj());
                row.createCell(2).setCellValue(p.getNomeCliente());
                row.createCell(3).setCellValue(p.getLogin());
                row.createCell(4).setCellValue(p.getDataHoraMovimentacao() == null ? "" : p.getDataHoraMovimentacao().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(5).setCellValue(p.getDescricao() == null ? "" : StringUtil.removeAllHtmlTags((String)p.getDescricao()));
                ++linha;
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                movimentacao = null;
                xls = null;
                is = null;
                movimentacao = null;
            }
            catch (Exception exception) {}
        }
    }

    public String export(EstruturaUsuario eu, PedidoTipoEnum tipo, List<ProducaoPedidoDTO> pedidos, Estrutura estrutura, EstruturaComplemento compl) {
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = tipo.equals((Object)PedidoTipoEnum.WHATSAPP) ? StorageUtil.getObjectModelo((String)"ExportacaoWhatsapp-v3.xlsx") : (this.ets.isTelefonia(estrutura) ? StorageUtil.getObjectModelo((String)"ExportacaoAtividades-v7.xlsx") : StorageUtil.getObjectModelo((String)"ExportacaoAtividadesOutros-v3.xlsx"));
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            CellStyle styleCellDouble = xls.createCellStyle();
            styleCellDouble.setDataFormat((short)2);
            int linha = 1;
            for (ProducaoPedidoDTO p : pedidos) {
                Row row = aba.createRow(linha);
                int col = 0;
                row.createCell(col).setCellValue(p.getNumeroPedido());
                if (tipo.equals((Object)PedidoTipoEnum.WHATSAPP)) {
                    row.createCell(++col).setCellValue(p.getWhatsappNumero() == null ? "" : p.getWhatsappNumero());
                    row.createCell(++col).setCellValue(p.getWhatsappNome() == null ? "" : p.getWhatsappNome());
                } else if (this.ets.isTelefonia(estrutura)) {
                    String psc = "";
                    if (p.getNumeroPedidoVinculado() != null && !p.getNumeroPedidoVinculado().isEmpty()) {
                        psc = p.getNumeroPedidoVinculado();
                    } else if (p.getNumeroCotacao() != null && !p.getNumeroCotacao().isEmpty()) {
                        psc = p.getNumeroCotacao();
                    } else if (p.getNumeroSimulacao() != null && !p.getNumeroSimulacao().isEmpty()) {
                        psc = p.getNumeroSimulacao();
                    }
                    row.createCell(++col).setCellValue(psc);
                    row.createCell(++col).setCellValue(p.getLoginOperadora() == null ? "" : p.getLoginOperadora());
                }
                row.createCell(++col).setCellValue(p.getPedidoTipo().name());
                if (tipo.equals((Object)PedidoTipoEnum.WHATSAPP)) {
                    row.createCell(++col).setCellValue(p.getWhatsappEscolhaTipo());
                }
                row.createCell(++col).setCellValue(p.getCpfCnpj());
                row.createCell(++col).setCellValue(p.getNomeCliente());
                row.createCell(++col).setCellValue(p.getNomeStatus());
                row.createCell(++col).setCellValue(p.getPedidoCategoria() == null ? "" : p.getPedidoCategoria());
                row.createCell(++col).setCellValue(p.getPedidoSubCategoria() == null ? "" : p.getPedidoSubCategoria());
                if (p.getTempo() != null && p.getTempo().contains(":")) {
                    if (Integer.valueOf(p.getTempo().split(":")[0]) > p.getSlaHoras() && p.getSlaHoras() > 0) {
                        row.createCell(++col).setCellValue("FORA PRAZO");
                    } else {
                        row.createCell(++col).setCellValue("DENTRO PRAZO");
                    }
                } else {
                    row.createCell(++col).setCellValue("");
                }
                row.createCell(++col).setCellValue(p.getSlaHoras() == null ? 0.0 : (double)p.getSlaHoras().intValue());
                row.createCell(++col).setCellValue(p.getTempo() == null ? "" : p.getTempo());
                row.createCell(++col).setCellValue(p.getDataHoraUltimaMov() == null ? "" : p.getDataHoraUltimaMov().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(++col).setCellValue(p.getTags() == null ? "" : p.getTags());
                row.createCell(++col).setCellValue(p.getNomeUsuario());
                row.createCell(++col).setCellValue(p.getTagUsuario() == null ? "" : p.getTagUsuario());
                row.createCell(++col).setCellValue(p.getEquipeUsuario() == null ? "" : p.getEquipeUsuario());
                row.createCell(++col).setCellValue(p.getNomeUsuarioAdm());
                if (this.ets.isTelefonia(estrutura) && !tipo.equals((Object)PedidoTipoEnum.WHATSAPP)) {
                    row.createCell(++col).setCellValue(p.getNumeroPedidoOrigem() == null ? "" : p.getNumeroPedidoOrigem());
                }
                row.createCell(++col).setCellValue(p.getDataCadastro().format(FormatDate.DATE_BR.toDTF()));
                row.createCell(++col).setCellValue(p.getDataHoraAtualizacao().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(++col).setCellValue(p.getDataRetornoFuturo() == null ? "" : p.getDataRetornoFuturo().format(FormatDate.DATE_BR.toDTF()));
                if (p.getComplementos() != null) {
                    p.setComplementos(p.getComplementos().replace("<BR>", " "));
                    p.setComplementos(p.getComplementos().replace("\n", " "));
                }
                row.createCell(++col).setCellValue((String)(p.getComplementos() == null ? "" : (p.getComplementos().length() > 1000 ? p.getComplementos().substring(0, 1000) + "..." : p.getComplementos())));
                ++linha;
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                pedidos = null;
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
    }

    public String exportStatus(EstruturaUsuario eu, Set<Long> listaId, Estrutura estrutura) {
        List pedidos = this.pedidoStatusService.getByListaPedido(estrutura, listaId);
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = StorageUtil.getObjectModelo((String)"ExportacaoAtividadeStatus-v2.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            CellStyle styleCellDouble = xls.createCellStyle();
            styleCellDouble.setDataFormat((short)2);
            int linha = 1;
            for (PedidoStatusDTO p : pedidos) {
                Row row = aba.createRow(linha);
                int col = 0;
                row.createCell(col).setCellValue(p.getNumeroAtividade());
                row.createCell(++col).setCellValue(p.getNomeEtapa());
                if (p.getTempo() != null && p.getTempo().contains(":")) {
                    if (Integer.valueOf(p.getTempo().split(":")[0]) > p.getSlaHoras() && p.getSlaHoras() > 0) {
                        row.createCell(++col).setCellValue("FORA PRAZO");
                    } else {
                        row.createCell(++col).setCellValue("DENTRO PRAZO");
                    }
                } else {
                    row.createCell(++col).setCellValue("DENTRO PRAZO");
                }
                row.createCell(++col).setCellValue(p.getSlaHoras() == null ? 0.0 : (double)p.getSlaHoras().intValue());
                row.createCell(++col).setCellValue(p.getTempo());
                row.createCell(++col).setCellValue(p.getDataHoraEntrou() == null ? "" : p.getDataHoraEntrou().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(++col).setCellValue(p.getUsuarioEntrou() == null ? "" : p.getUsuarioEntrou());
                row.createCell(++col).setCellValue(p.getDataHoraSaiu() == null ? "" : p.getDataHoraSaiu().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(++col).setCellValue(p.getUsuarioSaiu() == null ? "" : p.getUsuarioSaiu());
                row.createCell(++col).setCellValue(p.getMovimentacao() == null ? "" : StringUtil.removeAllHtmlTags((String)p.getMovimentacao().replace("<BR>", " ")));
                row.createCell(++col).setCellValue(p.getTagsAtividade() == null ? "" : p.getTagsAtividade());
                ++linha;
                row = null;
            }
            String hashFile = HashUtil.getUUI() + ".xlsx";
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                xls.write((OutputStream)baos);
                StorageUtil.uploadObjectByteArray((String)hashFile, (String)ContentType.MULTIPART_FORM_DATA.toString(), (byte[])baos.toByteArray());
            }
            aba = null;
            String string = hashFile;
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                pedidos = null;
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
    }
}

