/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.receitafederal.view;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.TextColor;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.model.MailingAtividade;
import br.com.system.app.features.mailing.model.MailingContato;
import br.com.system.app.features.mailing.model.MailingSocio;
import br.com.system.app.features.mailing.model.MailingTipoContatoEnum;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.textfield.TextField;
import java.math.BigDecimal;
import java.time.LocalDate;

public class ReceitaResultView
extends VerticalContainer {
    private static final long serialVersionUID = 1L;
    private final Mailing mailing;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public ReceitaResultView(Mailing mailing) {
        super(new Component[0]);
        this.mailing = mailing;
    }

    public ReceitaResultView create() {
        this.removeAll();
        this.setWidthFull();
        this.add(new Component[]{this.getCardBasico(), this.getCardEndereco(), this.getCardContatos(), this.getCardSocios(), this.getCardCnae()});
        return this;
    }

    private HorizontalContainer getCardContatos() {
        HorizontalContainer card = new HorizontalContainer(new Component[]{UIUtils.createHeader((String)"Contatos")});
        card.setShadow(Shadow.S);
        card.setWidthFull();
        for (MailingContato mc : this.mailing.getContatos()) {
            if (mc.getTipo().equals((Object)MailingTipoContatoEnum.EMAIL)) {
                card.add(new Component[]{this.creteTextInput(mc.getTipo().name(), mc.getValor())});
                continue;
            }
            if (!mc.getTipo().equals((Object)MailingTipoContatoEnum.TELEFONE)) continue;
            TextField tel = new TextField("Telefone", mc.getValor());
            card.add(new Component[]{tel});
        }
        return card;
    }

    private HorizontalContainer getCardBasico() {
        HorizontalContainer card = new HorizontalContainer(new Component[]{UIUtils.createHeader((String)"Dados B\u00e1sicos")});
        card.setWidthFull();
        card.setShadow(Shadow.S);
        TextField cnpj = this.creteTextInput("Cnpj", this.mailing.getCpfCnpj(), "150px");
        TextField nome = this.creteTextInput("Raz\u00e3o Social", this.mailing.getNome(), "300px");
        TextField fantasia = this.creteTextInput("Fantasia", this.mailing.getNomeFantasia());
        TextField capital = this.creteTextInput("Capital Social", UIUtils.formatCurrency((BigDecimal)this.mailing.getCapitalSocial()));
        TextField dataAbertura = this.creteTextInput("Data Abertura", this.getDate(this.mailing.getDataAbertura()), "110px");
        TextField situacao = this.creteTextInput("Situa\u00e7\u00e3o", this.mailing.getSituacao());
        TextField dataSituacao = this.creteTextInput("Data Situa\u00e7\u00e3o", this.getDate(this.mailing.getDataSituacao()), "110px");
        TextField natureza = this.creteTextInput("Natureza Juridica", this.mailing.getNaturezaJuridica());
        TextField matrizFilial = this.creteTextInput("Matriz ou Filial", this.mailing.getMatrizFilial(), "80px");
        TextField porte = this.creteTextInput("Porte", this.mailing.getPorte(), "80px");
        TextField simples = this.creteTextInput("Simples", this.mailing.getOpcaoSimples(), "120px");
        TextField dataSimples = this.creteTextInput("Data Simples", this.getDate(this.mailing.getDataOpcaoSimples()), "110px");
        TextField mei = this.creteTextInput("Mei", this.mailing.getOpcaoMei() == null ? "Sem Informa\u00e7\u00e3o" : (this.mailing.getOpcaoMei().equals("S") ? "SIM" : "N\u00c3O"), "80px");
        card.add(new Component[]{cnpj, nome, fantasia, capital, dataAbertura, situacao, dataSituacao, natureza, matrizFilial, porte, simples, dataSimples, mei});
        return card;
    }

    private HorizontalContainer getCardSocios() {
        HorizontalContainer card = new HorizontalContainer(new Component[]{UIUtils.createHeader((String)"S\u00f3cios")});
        card.setWidthFull();
        card.setShadow(Shadow.S);
        for (MailingSocio ms : this.mailing.getSocios()) {
            TextField nome = this.creteTextInput("Nome", ms.getNome(), "400px");
            TextField data = this.creteTextInput("Entrada", this.getDate(ms.getDataEntrada()), "110px");
            card.add(new Component[]{nome, data});
        }
        return card;
    }

    private HorizontalContainer getCardCnae() {
        HorizontalContainer card = new HorizontalContainer(new Component[]{UIUtils.createHeader((String)"Segmentos")});
        card.setWidthFull();
        card.setShadow(Shadow.S);
        for (MailingAtividade ma : this.mailing.getAtividades()) {
            TextField nome = this.creteTextInput("Codigo", ma.getCnae().getCodigo(), "100px");
            TextField desc = this.creteTextInput("Descri\u00e7\u00e3o", ma.getCnae().getDescricao(), "350px");
            if (ma.getPrincipal().booleanValue()) {
                Span principal = new Span("*Principal");
                UIUtils.setTextColor((TextColor)TextColor.HEADER, (Component[])new Component[]{nome, desc, principal});
            }
            card.add(new Component[]{nome, desc});
        }
        return card;
    }

    private HorizontalContainer getCardEndereco() {
        HorizontalContainer card = new HorizontalContainer(new Component[]{UIUtils.createHeader((String)"Endere\u00e7o")});
        card.setWidthFull();
        card.setShadow(Shadow.S);
        TextField cep = this.creteTextInput("Cep", this.mailing.getCep(), "120px");
        TextField rua = this.creteTextInput("Logradouro", this.mailing.getLogradouro(), "300px");
        TextField nro = this.creteTextInput("Numero", this.mailing.getNumero());
        TextField compl = this.creteTextInput("Compl", this.mailing.getComplemento());
        TextField bairro = this.creteTextInput("Bairro", this.mailing.getBairro());
        TextField cidade = this.creteTextInput("Cidade", this.mailing.getCidade());
        TextField estado = this.creteTextInput("Estado", this.mailing.getEstado(), "80px");
        card.add(new Component[]{cep, rua, nro, compl, bairro, cidade, estado});
        return card;
    }

    private TextField creteTextInput(String label, String value) {
        return this.creteTextInput(label, value, "");
    }

    private TextField creteTextInput(String label, String value, String width) {
        TextField tf = new TextField(label);
        tf.setValue(value == null ? "" : value);
        tf.setReadOnly(true);
        if (!width.isEmpty()) {
            tf.setWidth(width);
        }
        return tf;
    }

    private String getDate(LocalDate date) {
        if (date == null) {
            return "";
        }
        return date.format(FormatDate.DATE_BR.toDTF());
    }
}

