/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.sms.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.sms.model.Sms;
import br.com.system.app.features.sms.repository.SmsRepository;
import br.com.system.app.features.sms.service.ShortCodeService;
import br.com.system.commons.StringUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private SmsRepository repository;
    @Autowired
    private ShortCodeService shortCodeService;

    public void sendSms(EstruturaUsuario eu, String numero, String mensagem) {
        LocalDateTime end;
        if (numero == null) {
            return;
        }
        if ((numero = StringUtil.numbersOnly((String)numero)).length() < 10 || numero.length() > 11) {
            return;
        }
        LocalDateTime start = LocalDate.now().atStartOfDay();
        long envioMensal = this.repository.countByDataHoraEnvioBetween(start, end = LocalDateTime.now());
        if (envioMensal <= 0L) {
            this.shortCodeService.checarSaldo();
        }
        Sms sms = new Sms();
        sms.setDataHoraEnvio(LocalDateTime.now());
        sms.setEstruturaUsuario(eu);
        sms.setMensagem(mensagem);
        try {
            sms.setDestinatario(numero);
            this.shortCodeService.sendSms(eu, sms);
        }
        catch (Exception e) {
            sms.setSucess(false);
            sms.setRetorno(e.getMessage());
        }
        this.repository.save((Object)sms);
    }

    public void deleteByEstrutura(Estrutura e) {
        this.repository.deleteByEstruturaUsuarioEstrutura(e);
    }
}

