/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.unSubscribe.service;

import br.com.system.app.features.estrutura.model.EstruturaTipo;
import br.com.system.app.features.estrutura.repository.EstruturaTipoRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.unSubscribe.model.Unsubscribe;
import br.com.system.app.features.unSubscribe.repository.UnsubscribeRepository;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnsubscribeService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaTipoRepository estruturaTipoRepository;
    @Autowired
    private UnsubscribeRepository unsubscribeRepository;

    public boolean unsubscribe(String email, Long tipoEstruturaID) {
        Unsubscribe unsubscribe;
        EstruturaTipo estruturaTipo = this.estruturaTipoRepository.findById((Object)tipoEstruturaID).orElse(null);
        if (estruturaTipo != null && (unsubscribe = this.unsubscribeRepository.findByEmailAndEstruturaTipo(email, estruturaTipo)) == null) {
            unsubscribe = new Unsubscribe();
            unsubscribe.setEmail(email);
            unsubscribe.setEstruturaTipo(estruturaTipo);
            this.unsubscribeRepository.save((Object)unsubscribe);
            return true;
        }
        return false;
    }

    public boolean inUnsubscribeList(String email, Long tipoEstruturaID) {
        EstruturaTipo estruturaTipo = this.estruturaTipoRepository.findById((Object)tipoEstruturaID).orElse(null);
        if (estruturaTipo == null) {
            throw new BusinessException("Tipo de estrutura n\u00e3o encontrado");
        }
        Unsubscribe unsubscribe = this.unsubscribeRepository.findByEmailAndEstruturaTipo(email, estruturaTipo);
        return unsubscribe != null;
    }
}

