/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.usuario.model.UsuarioTag;
import br.com.system.app.features.usuario.repository.UsuarioTagRepository;
import br.com.system.commons.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsuarioTagService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private UsuarioTagRepository usuarioTagRepository;

    @Transactional
    @Modifying
    public void deleteTags(Set<UsuarioTag> tags, EstruturaUsuario eu) {
        for (UsuarioTag tag : tags) {
            this.usuarioTagRepository.delete((Object)tag);
        }
    }

    public String saveTags(String tags, EstruturaUsuario eu) {
        String normalizedTags = StringUtil.normalizeTags((String)tags);
        for (String tag : normalizedTags.split(",")) {
            if ((tag = tag.trim()).isEmpty() || this.usuarioTagRepository.findByEstruturaAndTag(eu.getEstrutura(), tag) != null) continue;
            UsuarioTag ut = new UsuarioTag();
            ut.setEstrutura(eu.getEstrutura());
            ut.setTag(tag);
            ut.setUsuario(eu.getUsuario());
            this.usuarioTagRepository.save((Object)ut);
        }
        return normalizedTags;
    }

    public UsuarioTag save(UsuarioTag UsuarioTag2) {
        if (UsuarioTag2.getEstrutura() == null) {
            throw new BusinessException("Estrutura  \u00e9 obrigatorio");
        }
        if (UsuarioTag2.getUsuario() == null) {
            throw new BusinessException("Usuario criacao  \u00e9 obrigatorio");
        }
        if (UsuarioTag2.getTag() == null || UsuarioTag2.getTag().isBlank()) {
            throw new BusinessException("Tag \u00e9 obrigatoria");
        }
        return (UsuarioTag)this.usuarioTagRepository.save((Object)UsuarioTag2);
    }

    public List<UsuarioTag> getTags(Estrutura estrutura) {
        return this.usuarioTagRepository.findByEstrutura(estrutura);
    }

    public List<UsuarioTag> getTags(Estrutura estrutura, List<String> tags) {
        return this.usuarioTagRepository.findByEstruturaAndTagIn(estrutura, tags);
    }

    public UsuarioTag getByTag(Estrutura estrutura, String tag) {
        return this.usuarioTagRepository.findByEstruturaAndTag(estrutura, tag);
    }

    public String getStringtags(Set<UsuarioTag> tags) {
        ArrayList<String> l = new ArrayList<String>();
        for (UsuarioTag tag : tags) {
            l.add(tag.getTag());
        }
        return StringUtils.join(l, (String)",");
    }
}

