/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.waha.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.waha.dto.WahaJsons;
import br.com.system.app.features.waha.service.WahaConnection;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.integreation.conexaoExterna.ExternalConnection;
import java.io.InputStream;
import java.util.function.Consumer;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class WahaService {
    private final String SCAN_QR_CODE = "SCAN_QR_CODE";
    private final String WORKING = "WORKING";

    public boolean isSessionConnected(String session) throws Exception {
        return this.getStatusSession(session).equals("WORKING");
    }

    @Async(value="asyncDefault")
    public void dispatchQrcode(WhatsAppConta conta, Consumer<Boolean> listener) {
        try {
            String status = this.getStatusSession(conta.getMooseId());
            if (status.equals("SCAN_QR_CODE") && listener != null) {
                listener.accept(true);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(WahaService.class).error(e.getMessage());
        }
    }

    public String getStatusSession(String session) throws Exception {
        try {
            ExternalConnection conexao = WahaConnection.getConnection();
            JSONObject retorno = conexao.executeGet("https://whats.neosales.com.br/api/sessions/" + session).toJsonObject();
            if (retorno.has("status")) {
                return retorno.getString("status");
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public void saveSession(WhatsAppConta conta, EstruturaUsuario eu, String webhook) throws Exception {
        String session = conta.getMooseId();
        ExternalConnection conexao = WahaConnection.getConnection();
        if (this.getStatusSession(session).isEmpty()) {
            if (!conta.isAtivo()) {
                return;
            }
            JSONObject json = WahaJsons.getCreateSession((String)session, (String)webhook, (EstruturaUsuario)eu);
            conexao.setJsonParameters(json).executePost("https://whats.neosales.com.br/api/sessions").getReturnedHtml();
        } else {
            if (!conta.isAtivo()) {
                conexao.executeDelete("https://whats.neosales.com.br/api/sessions/" + session);
                return;
            }
            JSONObject json = WahaJsons.getUpdateSession((String)session, (String)webhook, (EstruturaUsuario)eu);
            conexao.setJsonParameters(json).executePut("https://whats.neosales.com.br/api/sessions/" + session).getReturnedHtml();
        }
    }

    public void changeStatusSession(String session, String status) throws Exception {
        ExternalConnection conexao = WahaConnection.getConnection();
        conexao.executePost("https://whats.neosales.com.br/api/sessions/" + session + "/" + status);
    }

    public InputStream getQrCode(String session) throws Exception {
        if (!this.getStatusSession(session).equals("SCAN_QR_CODE")) {
            throw new Exception("Sess\u00e3o nao esta pronta para ler o QR_CODE, por favor aguarde alguns instantes e tente novamente");
        }
        ExternalConnection conexao = WahaConnection.getConnection();
        conexao.setTimeOut(Integer.valueOf(60000));
        return conexao.executeGet("https://whats.neosales.com.br/api/" + session + "/auth/qr?format=image").getEntity().getContent();
    }
}

