/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.shared.handle.HandlerExcel;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.features.whatsapp.model.WhatsappBloqueio;
import br.com.system.app.features.whatsapp.service.WhatsAppBloqueioService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.SleepUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import elemental.json.Json;
import elemental.json.JsonValue;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="whatsapp-bloqueio", layout=MainLayout.class)
@PageTitle(value="Whatsapp BLoqueio de N\u00fameros")
@RolesAllowed(value={"WHATSAPP_BLOQUEIO_VIEW"})
public class WhatsAppBloqueioView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final WhatsAppBloqueioService service;
    private final HandlerExcel handlerExcel = new HandlerExcel();
    private GridCrud<WhatsappBloqueio> crud;
    private String nomeArquivo = "";
    private TempFileMultiBuffer mBuffer;
    private ListField listNumeros;
    private Button btnPesquisar;

    @Autowired
    public WhatsAppBloqueioView(WhatsAppBloqueioService service) {
        this.service = service;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent((Component)this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private VerticalLayout createContent() {
        this.listNumeros = new ListField(ListFieldTypeEnum.TELEFONE, "Filtrar N\u00fameros");
        this.btnPesquisar = UIUtils.createSmallButton((String)"Pesquisar");
        this.btnPesquisar.setDisableOnClick(true);
        this.btnPesquisar.addClickListener((ComponentEventListener & Serializable)e -> {
            this.crud.refreshGrid();
            this.btnPesquisar.setEnabled(true);
        });
        VerticalLayout l = new VerticalLayout();
        l.add(new Component[]{this.createUpload()});
        l.add(new Component[]{new HorizontalContainer(new Component[]{this.listNumeros, this.btnPesquisar})});
        l.add(new Component[]{this.getCrud()});
        return l;
    }

    private GridCrud<WhatsappBloqueio> getCrud() {
        this.crud = new GridCrud(WhatsappBloqueio.class);
        this.crud.getAddButton().setText("Adicionar");
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNumero()))).setHeader("Numero").setFlexGrow(0).setWidth("120px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getEstruturaUsuario().getUsuario().getNome()))).setHeader("Nome").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getEstruturaUsuario().getUsuario().getLogin()))).setHeader("Login").setFlexGrow(0).setWidth("250px");
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{"numero"});
        this.crud.getAddButton().setVisible(this.hasPermission("WHATSAPP_BLOQUEIO_SAVE"));
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.hasPermission("WHATSAPP_BLOQUEIO_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }

    private VerticalContainer createUpload() {
        this.mBuffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)this.mBuffer);
        upload.setMaxFiles(1);
        upload.setVisible(this.hasPermission("WHATSAPP_BLOQUEIO_SAVE"));
        upload.setAcceptedFileTypes(new String[]{".xlsx"});
        upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado, clique em processar");
        });
        upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas .xlxs"));
        Button processar = UIUtils.createSmallButton((String)"Processar", (VaadinIcon)VaadinIcon.COGS, (String)"Iniciar processamento");
        processar.setDisableOnClick(true);
        processar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.nomeArquivo.isEmpty()) {
                UIUtils.showNotification((String)"Selecione o arquivo.");
            } else {
                try {
                    Set numeros = this.handlerExcel.getDadosFromCell(this.mBuffer.getInputStream(), Integer.valueOf(0));
                    this.service.bloquear(this.getEu(), numeros);
                    this.showNotification("Numeros bloqueados com sucesso");
                }
                catch (Exception ex) {
                    this.showNotification(ex.getMessage());
                }
                upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
                SleepUtil.inSeconds((Integer)3);
                this.crud.refreshGrid();
                this.nomeArquivo = "";
                this.mBuffer.clear();
            }
            processar.setEnabled(true);
        });
        VerticalContainer card = new VerticalContainer(new Component[0]);
        card.setShadow(Shadow.S);
        card.add(new Component[]{UIUtils.createHeader((String)"Upload arquivos")});
        card.add(new Component[]{upload, new FooterContainer(new Component[]{processar})});
        return card;
    }
}

