/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cliente.view.form.ClienteFormView;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.Border;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.TextColor;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.Bottom;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.layout.size.Left;
import br.com.system.app.features.layout.size.Right;
import br.com.system.app.features.layout.size.Size;
import br.com.system.app.features.layout.size.Top;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.layout.util.TextAlign;
import br.com.system.app.features.whatsapp.AuxDash;
import br.com.system.app.features.whatsapp.WhatsAppConversasDialog;
import br.com.system.app.features.whatsapp.WhatsAppTransfDialog;
import br.com.system.app.features.whatsapp.dto.WhatsAppAtendimentoDTO;
import br.com.system.app.features.whatsapp.dto.WhatsAppFiltroEnum;
import br.com.system.app.features.whatsapp.dto.WhatsMoorseBillingDTO;
import br.com.system.app.features.whatsapp.dto.WhatsMoorseBillingItemDTO;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendenteService;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoExportacao;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppExportacaoService;
import br.com.system.app.features.whatsapp.service.WhatsAppMoorseApi;
import br.com.system.app.features.whatsapp.service.bot.WhatsAppBotGoldcell2;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.CurrencyUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="dashboard-atendimento", layout=MainLayout.class)
@PageTitle(value="DashBoard atendimento")
@RolesAllowed(value={"ATENDIMENTO_DASHBOARD_VIEW"})
public class WhatsAppDashBoardView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final WhatsAppAtendenteService waas;
    private final WhatsAppAtendimentoService atendimentoService;
    private final EstruturaUsuarioService eus;
    private final WhatsAppConversasDialog conversasDialog;
    private final WhatsAppTransfDialog transfDialog;
    private final WhatsAppMoorseApi api;
    private final ClienteService clienteService;
    private final ClienteFormView clienteFormView;
    private final WhatsAppContaService whatsappContaService;
    private final WhatsAppExportacaoService whatsAppExportacaoService;
    private final WhatsAppBotGoldcell2 whatsAppBotGoldcell2;
    private final DatePicker dataInicial = new DatePicker();
    private final DatePicker dataFinal = new DatePicker();
    private final ComboBox<WhatsAppAtendente> cbAtendente = new ComboBox("Atendente");
    private final ComboBox<WhatsAppEtapaEnum> cbEtapa = new ComboBox("Etapa");
    private final HorizontalContainer containerCards = new HorizontalContainer(new Component[0]);
    private final Span lblTotal = new Span();
    private final WhatsAppAtendimentoExportacao waExport = new WhatsAppAtendimentoExportacao();
    private final ListField txtFilterCnpj = new ListField(ListFieldTypeEnum.CPF_CNPJ, "CNPJ(s)");
    private final ListField txtFilterNumeros = new ListField(ListFieldTypeEnum.GENERIC_NUMBER, "N\u00famero(s)");
    private List<WhatsAppAtendimentoDTO> lista;
    private List<WhatsAppAtendimentoDTO> listaCadastroCompletos;
    private List<WhatsAppAtendimentoDTO> listaMais10Minutos;
    private List<WhatsAppAtendimentoDTO> listaCadastroIncompletos;
    private Grid<WhatsAppAtendimentoDTO> grid;
    private WhatsAppFiltroEnum filtroSelect;
    private DownloadDialog dd;

    @Autowired
    public WhatsAppDashBoardView(WhatsAppAtendenteService waas, WhatsAppAtendimentoService atendimentoService, WhatsAppConversasDialog conversasDialog, WhatsAppTransfDialog transfDialog, EstruturaUsuarioService eus, WhatsAppMoorseApi api, ClienteService clienteService, ClienteFormView clienteFormView, WhatsAppContaService whatsappContaService, WhatsAppExportacaoService whatsAppExportacaoService, WhatsAppBotGoldcell2 whatsAppBotGoldcell2) {
        this.waas = waas;
        this.whatsAppBotGoldcell2 = whatsAppBotGoldcell2;
        this.whatsAppExportacaoService = whatsAppExportacaoService;
        this.whatsappContaService = whatsappContaService;
        this.clienteFormView = clienteFormView;
        this.clienteService = clienteService;
        this.api = api;
        this.eus = eus;
        this.transfDialog = transfDialog;
        this.conversasDialog = conversasDialog;
        this.atendimentoService = atendimentoService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent((Component)this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private FlexBoxLayout createContent() {
        this.init();
        this.carregaGrid();
        this.povoa();
        this.carregaCards();
        this.setHeightFull();
        this.setId("whatsappdashboardview");
        FlexBoxLayout main = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]);
        main.setId("main");
        main.add(new Component[]{this.getHeader()});
        main.add(new Component[]{this.containerCards});
        main.setHeightFull();
        Button btn = UIUtils.createSmallButton((String)"Esconder Painel", (String)"");
        btn.setWidthFull();
        btn.addClickListener((ComponentEventListener & Serializable)e -> {
            if (btn.getText().equals("Esconder Painel")) {
                btn.setText("Mostrar Painel");
                this.containerCards.setVisible(false);
            } else {
                btn.setText("Esconder Painel");
                this.containerCards.setVisible(true);
            }
        });
        Button teste = UIUtils.createSmallButton((String)"teste jhs");
        teste.setVisible(this.isMaster());
        teste.addClickListener((ComponentEventListener & Serializable)e -> {
            WhatsAppAtendimento a = this.atendimentoService.getById(((WhatsAppAtendimentoDTO)this.grid.getSelectedItems().iterator().next()).getId());
            this.whatsAppBotGoldcell2.getAtendente(a.getWhatsapp(), this.eus.getMasterEstrutura(this.getEstrutura()), Integer.valueOf(4));
        });
        main.add(new Component[]{teste});
        main.add(new Component[]{btn});
        main.add(new Component[]{this.grid});
        return main;
    }

    private void povoa() {
        if (this.dataInicial.getValue() == null) {
            this.dataInicial.setValue(LocalDate.now());
        }
        if (this.dataFinal.getValue() == null) {
            this.dataFinal.setValue(LocalDate.now());
        }
        this.lista = this.atendimentoService.getAtendimento(this.getEstrutura(), this.cbAtendente.getValue() == null ? null : ((WhatsAppAtendente)this.cbAtendente.getValue()).getEstruturaUsuario(), (LocalDate)this.dataInicial.getValue(), (LocalDate)this.dataFinal.getValue(), (WhatsAppEtapaEnum)this.cbEtapa.getValue(), this.txtFilterCnpj.getValue(), this.txtFilterNumeros.getValue());
        this.grid.setItems((Collection)this.lista);
        this.listaMais10Minutos = this.atendimentoService.getMais10Minutos(this.getEstrutura());
        this.listaCadastroCompletos = this.atendimentoService.getCadastros(this.getEstrutura(), (LocalDate)this.dataInicial.getValue(), (LocalDate)this.dataFinal.getValue(), WhatsAppFiltroEnum.CADASTROS_COMPLETOS, this.txtFilterCnpj.getValue(), this.txtFilterNumeros.getValue());
        this.listaCadastroIncompletos = this.atendimentoService.getCadastros(this.getEstrutura(), (LocalDate)this.dataInicial.getValue(), (LocalDate)this.dataFinal.getValue(), WhatsAppFiltroEnum.CADASTROS_INCOMPLETOS, this.txtFilterCnpj.getValue(), this.txtFilterNumeros.getValue());
        this.lblTotal.setText(Integer.toString(this.lista.size()));
        this.filtroSelect = WhatsAppFiltroEnum.TODOS;
    }

    private void init() {
        this.dd = new DownloadDialog();
        this.dataInicial.setLabel("Data Inicial");
        this.dataInicial.setValue(LocalDate.now());
        this.dataInicial.setLocale(UIUtils.getLocale());
        this.dataFinal.setLabel("Data Final");
        this.dataFinal.setValue(LocalDate.now());
        this.dataFinal.setLocale(UIUtils.getLocale());
        List listaAtendente = this.waas.getByEstrutura(this.getEstrutura());
        listaAtendente.add(new WhatsAppAtendente(this.eus.getMasterEstrutura(this.getEstrutura())));
        this.cbAtendente.setItems((Collection)listaAtendente);
        this.cbAtendente.setItemLabelGenerator(WhatsAppAtendente::getNomeAndLoginAndEquipe);
        this.cbEtapa.setItems((Collection)this.getEtapas(this.getEstrutura()));
        this.cbEtapa.setItemLabelGenerator(Enum::name);
    }

    private HorizontalContainer getHeader() {
        Button btnBilling = UIUtils.createSmallButton((String)"Billing", (VaadinIcon)VaadinIcon.MONEY, (String)"Cobran\u00e7a");
        btnBilling.setEnabled(this.hasPermission("ATENDIMENTO_BILLING_VIEW"));
        btnBilling.addClickListener((ComponentEventListener & Serializable)e -> this.showBilling());
        Button btnExportarCadatro = UIUtils.createSmallButton((String)"Exportar Cadastro", (VaadinIcon)VaadinIcon.USER, (String)"Exportar cadastros do whatsapp");
        btnExportarCadatro.setEnabled(this.hasPermission("WHATSAPP_EXPORTAR_CADASTRO"));
        btnExportarCadatro.addClickListener((ComponentEventListener & Serializable)e -> {
            String url = this.whatsAppExportacaoService.exportarCadastros(this.getEstrutura(), (LocalDate)this.dataInicial.getValue(), (LocalDate)this.dataFinal.getValue(), (WhatsAppAtendente)this.cbAtendente.getValue(), (WhatsAppEtapaEnum)this.cbEtapa.getValue(), this.txtFilterCnpj.getValue(), this.txtFilterNumeros.getValue());
            this.dd.open(url, "Exportacao-cadastro-whatsapp.xlsx", true);
        });
        Button btnPesquisar = UIUtils.createSmallButton((String)"Pesquisar", (VaadinIcon)VaadinIcon.SEARCH, (String)"Pesquisar");
        btnPesquisar.addClickListener((ComponentEventListener & Serializable)e -> {
            this.povoa();
            this.carregaCards();
        });
        HorizontalContainer h = new HorizontalContainer(new Component[0]).setSpacingOn();
        h.add(new Component[]{this.dataInicial, this.dataFinal, this.cbAtendente, this.cbEtapa, this.txtFilterCnpj, this.txtFilterNumeros, btnPesquisar, btnBilling, btnExportarCadatro});
        return h;
    }

    private void carregaCards() {
        this.containerCards.removeAll();
        AuxDash cad = new AuxDash(null, "CAD COMPLETOS", Integer.valueOf(this.listaCadastroCompletos.size()), WhatsAppFiltroEnum.CADASTROS_COMPLETOS);
        this.containerCards.add(new Component[]{this.getCard(cad)});
        AuxDash cadInc = new AuxDash(null, "CAD INCOMPLETOS", Integer.valueOf(this.listaCadastroIncompletos.size()), WhatsAppFiltroEnum.CADASTROS_INCOMPLETOS);
        this.containerCards.add(new Component[]{this.getCard(cadInc)});
        AuxDash cad10min = new AuxDash(null, "AG + 10 MIN", Integer.valueOf(this.listaMais10Minutos.size()), WhatsAppFiltroEnum.MAIS_10MINUTOS);
        this.containerCards.add(new Component[]{this.getCard(cad10min)});
        AuxDash total = new AuxDash(null, "TOTAL ATENDIMENTOS", Integer.valueOf(this.lista.size()), WhatsAppFiltroEnum.TODOS);
        this.containerCards.add(new Component[]{this.getCard(total)});
        HashMap<Long, AuxDash> at = new HashMap<Long, AuxDash>();
        HashMap<String, AuxDash> ae = new HashMap<String, AuxDash>();
        for (WhatsAppAtendimentoDTO whatsAppAtendimentoDTO : this.lista) {
            AuxDash ad;
            String l = whatsAppAtendimentoDTO.getLogin();
            if (at.containsKey(whatsAppAtendimentoDTO.getAtendenteId())) {
                ad = (AuxDash)at.get(whatsAppAtendimentoDTO.getAtendenteId());
                ad.setQuantidade(Integer.valueOf(ad.getQuantidade() + 1));
                at.put(whatsAppAtendimentoDTO.getAtendenteId(), ad);
            } else {
                at.put(whatsAppAtendimentoDTO.getAtendenteId(), new AuxDash(whatsAppAtendimentoDTO.getAtendenteId(), l, Integer.valueOf(1), WhatsAppFiltroEnum.ATENDENTE));
            }
            if (ae.containsKey(whatsAppAtendimentoDTO.getEtapa())) {
                ad = (AuxDash)ae.get(whatsAppAtendimentoDTO.getEtapa());
                ad.setQuantidade(Integer.valueOf(ad.getQuantidade() + 1));
                ae.put(whatsAppAtendimentoDTO.getEtapa(), ad);
                continue;
            }
            ae.put(whatsAppAtendimentoDTO.getEtapa(), new AuxDash(null, whatsAppAtendimentoDTO.getEtapa(), Integer.valueOf(1), WhatsAppFiltroEnum.ETAPA));
        }
        for (Map.Entry entry : ae.entrySet()) {
            this.containerCards.add(new Component[]{this.getCard((AuxDash)entry.getValue())});
        }
        for (Map.Entry entry : at.entrySet()) {
            this.containerCards.add(new Component[]{this.getCard((AuxDash)entry.getValue())});
        }
    }

    private void carregaGrid() {
        Button btnExport = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TABLE, (String)"Exportar");
        btnExport.addClickListener((ComponentEventListener & Serializable)e -> {
            String url = this.filtroSelect.equals((Object)WhatsAppFiltroEnum.CADASTROS_COMPLETOS) ? this.waExport.exportMovimentacao(this.listaCadastroCompletos) : (this.filtroSelect.equals((Object)WhatsAppFiltroEnum.CADASTROS_INCOMPLETOS) ? this.waExport.exportMovimentacao(this.listaCadastroCompletos) : this.waExport.exportMovimentacao(this.lista));
            this.dd.open(url, "Exportacao-atendimento-whatsapp.xlsx", true);
        });
        this.grid = new Grid(WhatsAppAtendimentoDTO.class);
        this.grid.setColumns(new String[0]);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> this.getOptions(eg))).setKey("options").setWidth("190px").setHeader((Component)new HorizontalContainer(new Component[]{this.lblTotal, btnExport}).setTransparent()).setResizable(false);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getCnpj()))).setHeader("Cnpj").setFlexGrow(0).setWidth("150px");
        if (this.isAlianca()) {
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getEscolhaTipo()))).setHeader("Escolha Op\u00e7\u00e3o").setFlexGrow(0).setWidth("150px");
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNumero()))).setHeader("Numero").setFlexGrow(0).setWidth("150px");
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getNome() == null ? "" : p.getNome())))).setHeader("Nome").setFlexGrow(0).setWidth("250px");
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getEmail() == null ? "" : p.getEmail())))).setHeader("E-mail").setFlexGrow(0).setWidth("250px");
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getUltimaMensagem()))).setHeader("Ultima Mensagem").setFlexGrow(0).setWidth("250px");
        } else {
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getNomeCliente() == null ? "" : p.getNomeCliente())))).setHeader("Nome Empresa").setFlexGrow(0).setWidth("250px");
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getUltimaMensagem()))).setHeader("Ultima Mensagem").setFlexGrow(0).setWidth("250px");
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNumero()))).setHeader("Numero").setFlexGrow(0).setWidth("150px");
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getNome() == null ? "" : p.getNome())))).setHeader("Nome").setFlexGrow(0).setWidth("250px");
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getEmail() == null ? "" : p.getEmail())))).setHeader("E-mail").setFlexGrow(0).setWidth("250px");
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getFuncao() == null ? "" : p.getFuncao())))).setHeader("Fun\u00e7\u00e3o").setFlexGrow(0).setWidth("150px");
        }
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPedidoId().toString())).setHeader("Atividade").setFlexGrow(0).setWidth("150px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getEtapa() == null ? "" : p.getEtapa())))).setHeader("Etapa").setFlexGrow(0).setWidth("150px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.isFechadoInatividade() ? "Sim" : "N\u00e3o")).setHeader("Inatividade").setFlexGrow(0).setWidth("120px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getNomeUsuario().equals("MASTER") ? "Bot" : p.getNomeUsuario())))).setHeader("Nome Atendente").setFlexGrow(0).setWidth("250px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getLogin().startsWith("master@") ? "Bot" : p.getLogin())))).setHeader("Login Atendente").setFlexGrow(0).setWidth("250px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
            String tempo = "";
            if (p.getDataTransf() != null && p.getDataFim() != null) {
                tempo = String.valueOf(Duration.between(p.getDataTransf(), p.getDataFim()).toMinutes());
            }
            return UIUtils.createBreakWrapSpan((String)tempo);
        })).setHeader("Minutos").setFlexGrow(0).setWidth("150px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getDataInicio().format(FormatDate.DATETIME_BR.toDTF())))).setHeader("Inicio").setFlexGrow(0).setWidth("150px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getDataTransf() == null ? "" : p.getDataTransf().format(FormatDate.DATETIME_BR.toDTF()))))).setHeader("Transf").setFlexGrow(0).setWidth("150px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getDataFim() == null ? "" : p.getDataFim().format(FormatDate.DATETIME_BR.toDTF()))))).setHeader("Fim").setFlexGrow(0).setWidth("150px");
    }

    private FlexBoxLayout getCard(AuxDash ad) {
        String header = ad.getNome();
        String valor = ad.getQuantidade().toString();
        FlexBoxLayout boxMain = new FlexBoxLayout();
        boxMain.addClickListener((ComponentEventListener & Serializable)e -> {
            this.filtroSelect = ad.getTipo();
            if (ad.getTipo().equals((Object)WhatsAppFiltroEnum.CADASTROS_COMPLETOS)) {
                this.grid.setItems((Collection)this.listaCadastroCompletos);
                this.lblTotal.setText(Integer.toString(this.listaCadastroCompletos.size()));
            } else if (ad.getTipo().equals((Object)WhatsAppFiltroEnum.CADASTROS_INCOMPLETOS)) {
                this.grid.setItems((Collection)this.listaCadastroIncompletos);
                this.lblTotal.setText(Integer.toString(this.listaCadastroIncompletos.size()));
            } else if (ad.getTipo().equals((Object)WhatsAppFiltroEnum.MAIS_10MINUTOS)) {
                this.grid.setItems((Collection)this.listaMais10Minutos);
                this.lblTotal.setText(Integer.toString(this.listaMais10Minutos.size()));
            } else {
                EstruturaUsuario at = ad.getId() == null ? null : this.eus.getById(ad.getId());
                WhatsAppEtapaEnum etapa = ad.getTipo().equals((Object)WhatsAppFiltroEnum.ETAPA) ? WhatsAppEtapaEnum.valueOf((String)ad.getNome()) : null;
                this.lista = this.atendimentoService.getAtendimento(this.getEstrutura(), at, (LocalDate)this.dataInicial.getValue(), (LocalDate)this.dataFinal.getValue(), etapa == null ? (WhatsAppEtapaEnum)this.cbEtapa.getValue() : etapa, this.txtFilterCnpj.getValue(), this.txtFilterNumeros.getValue());
                this.grid.setItems((Collection)this.lista);
                this.lblTotal.setText(Integer.toString(this.lista.size()));
            }
        });
        boxMain.setFlexDirection(FlexLayout.FlexDirection.COLUMN);
        boxMain.setWidth("180px");
        UIUtils.setShadow((Shadow)Shadow.S, (Component[])new Component[]{boxMain});
        boxMain.setPadding(new Size[]{Bottom.M, Top.M, Left.M, Right.M});
        boxMain.setBorder(Border.Style.SOLID, "1px", Color.AQUAMARINE);
        FlexBoxLayout boxHeader = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new Component[0]);
        boxHeader.setWidthFull();
        Span spanHeader = new Span(header.replace("master@", "bot@"));
        UIUtils.setTextColor((TextColor)TextColor.TERTIARY, (Component[])new Component[]{spanHeader});
        UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{spanHeader});
        HorizontalContainer h = new HorizontalContainer(new Component[0]);
        h.setTransparent();
        h.setNoWrap();
        Icon icon = ad.getTipo().equals((Object)WhatsAppFiltroEnum.ETAPA) ? new Icon(VaadinIcon.TIMER) : (ad.getTipo().equals((Object)WhatsAppFiltroEnum.ATENDENTE) ? new Icon(VaadinIcon.USER) : (ad.getTipo().equals((Object)WhatsAppFiltroEnum.CADASTROS_COMPLETOS) || ad.getTipo().equals((Object)WhatsAppFiltroEnum.CADASTROS_INCOMPLETOS) ? new Icon(VaadinIcon.FOLDER_O) : new Icon(VaadinIcon.COMMENTS_O)));
        icon.setSize("10px");
        h.add(new Component[]{icon, spanHeader});
        boxHeader.add(new Component[]{h});
        boxMain.add(new Component[]{boxHeader});
        FlexBoxLayout boxNumeros = new FlexBoxLayout();
        boxNumeros.setWidthFull();
        Span spanQuantidade = new Span(valor);
        spanQuantidade.getStyle().set("border-style", "dotted");
        spanQuantidade.getStyle().set("border-width", "1px");
        spanQuantidade.getStyle().set("border-color", "#DDD7D7");
        UIUtils.setTextAlign((TextAlign)TextAlign.CENTER, (Component[])new Component[]{spanHeader});
        UIUtils.setTextAlign((TextAlign)TextAlign.CENTER, (Component[])new Component[]{spanQuantidade});
        boxNumeros.setFlexGrow(1.0, new HasElement[]{spanQuantidade});
        boxNumeros.add(new Component[]{spanQuantidade});
        boxMain.add(new Component[]{boxNumeros});
        return boxMain;
    }

    private HorizontalContainer getOptions(WhatsAppAtendimentoDTO dto) {
        Button btnConversa = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CHAT, (String)"Conversas");
        btnConversa.addClickListener((ComponentEventListener & Serializable)e -> {
            WhatsAppAtendimento wa = this.atendimentoService.getById(dto.getId());
            this.conversasDialog.show(wa);
        });
        Button bTrash = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.BOMB, (String)"Excluir TODOS os atendimentos e Cadastro de WHATS");
        bTrash.setVisible(this.isMaster());
        bTrash.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("ATENCAO!!!!!!!", "Voc\u00ea vai excluir TODOS OS ATENDIMENTOS E O CADASTRO DO WHATS. N\u00e3o tem volta. Tenha certeza disso.");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                try {
                    this.atendimentoService.deleteByWhatsApp(dto.getWid());
                }
                catch (Exception e1) {
                    UIUtils.showError((String)("Erro ao excluir atendimentos " + e1.getMessage()));
                }
                cd.close();
                this.povoa();
            });
        });
        Button btnTrans = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.REPLY, (String)"Transferir para atendente");
        btnTrans.addClickListener((ComponentEventListener & Serializable)e -> {
            WhatsAppAtendimento wa = this.atendimentoService.getById(dto.getId());
            if (!wa.getEtapa().equals((Object)WhatsAppEtapaEnum.FECHADO)) {
                this.openTransfer(wa);
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Fechado", "Este atendimento est\u00e1 fechado, deseja abri-lo novamente e transferir?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)can -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                this.openTransfer(wa);
                cd.close();
            });
        });
        Button btnCloseAtendimento = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CLOSE, (String)"Fechar Atendimento");
        btnCloseAtendimento.addClickListener((ComponentEventListener & Serializable)e -> {
            WhatsAppAtendimento wa = this.atendimentoService.getById(dto.getId());
            if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.FECHADO)) {
                this.showNotification("Este atendimento j\u00e1 est\u00e1 fechado");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Fechar Atendimento", "Confirma fechamento deste atendimento?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)ec -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)ec -> {
                this.atendimentoService.fechar(wa, this.getEu(), true);
                this.povoa();
                cd.close();
            });
            this.povoa();
        });
        Button btnCliente = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.USERS, (String)"Abrir cadastro de Clientes");
        btnCliente.addClickListener((ComponentEventListener & Serializable)e -> {
            String cnpj;
            WhatsAppAtendimento wa = this.atendimentoService.getById(dto.getId());
            String string = wa.getCnpj() == null ? (wa.getWhatsapp().getCpfCnpj() != null && wa.getWhatsapp().getCpfCnpj().length() <= 14 ? wa.getCnpj() : null) : (cnpj = wa.getCnpj());
            if (cnpj == null) {
                this.showNotification("Ainda n\u00e3o h\u00e1 CNPJ informado");
                return;
            }
            Cliente cliente = this.clienteService.buscarPeloCnpj(cnpj, this.getEstrutura());
            if (cliente == null) {
                UIUtils.showNotification((String)"Cnpj inv\u00e1lido ou n\u00e3o informado");
                return;
            }
            this.clienteFormView.create(cliente);
        });
        HorizontalContainer cont = new HorizontalContainer(new Component[]{btnConversa, btnTrans, btnCliente, btnCloseAtendimento, bTrash});
        cont.setJustifyContentMode(FlexComponent.JustifyContentMode.START);
        cont.setTransparent();
        return cont;
    }

    private void openTransfer(WhatsAppAtendimento wa) {
        this.transfDialog.create(wa);
        this.transfDialog.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
            if (!close.isOpened()) {
                this.povoa();
            }
        });
    }

    private void showBilling() {
        try {
            Dialog d = new Dialog();
            d.add(new Component[]{UIUtils.createHeader((String)"Billing")});
            WhatsMoorseBillingDTO dto = this.api.getBilling(((WhatsAppConta)this.whatsappContaService.getContaByEstruturaAtendimento(this.getEstrutura()).get(0)).getMooseId());
            TextField valorTotal = new TextField("Valor Total");
            valorTotal.setReadOnly(true);
            valorTotal.setValue(CurrencyUtil.toCurrencyWithR$((Double)dto.getValorTotal()));
            TextField valorMinimo = new TextField("Minimo Mensal");
            valorMinimo.setValue(CurrencyUtil.toCurrencyWithR$((Double)dto.getMinimoMensal()));
            valorMinimo.setReadOnly(true);
            d.add(new Component[]{new HorizontalContainer(new Component[]{valorTotal, valorMinimo})});
            d.add(new Component[]{UIUtils.createHeader((String)"Itens")});
            for (WhatsMoorseBillingItemDTO i : dto.getItens()) {
                HorizontalContainer h = new HorizontalContainer(new Component[0]);
                TextField tipo = new TextField("Tipo");
                tipo.setReadOnly(true);
                tipo.setValue(i.getTipo());
                TextField qtde = new TextField("Quantidade");
                qtde.setReadOnly(true);
                qtde.setValue(i.getQuantidade().toString());
                TextField vlUnit = new TextField("Valor Unit\u00e1rio");
                vlUnit.setReadOnly(true);
                vlUnit.setValue(CurrencyUtil.toCurrencyWithR$((Double)i.getValorUnitario()));
                TextField vlTt = new TextField("Valor Total");
                vlTt.setReadOnly(true);
                vlTt.setValue(CurrencyUtil.toCurrencyWithR$((Double)i.getValorTotal()));
                h.add(new Component[]{tipo, qtde, vlUnit, vlTt});
                d.add(new Component[]{h});
            }
            Button btnClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"Fechar");
            btnClose.addClickListener((ComponentEventListener & Serializable)e -> d.close());
            d.add(new Component[]{new FooterContainer(new Component[]{btnClose})});
            d.open();
        }
        catch (Exception e2) {
            this.showNotification("Erro " + e2.getMessage());
        }
    }

    private List<WhatsAppEtapaEnum> getEtapas(Estrutura e) {
        ArrayList<WhatsAppEtapaEnum> ret = new ArrayList<WhatsAppEtapaEnum>();
        if (e.getNome().equals("aliancasul")) {
            ret.add(WhatsAppEtapaEnum.INICIAL);
            ret.add(WhatsAppEtapaEnum.NOME);
            ret.add(WhatsAppEtapaEnum.CPF_CNPJ);
            ret.add(WhatsAppEtapaEnum.ESCOLHA_TIPO);
            ret.add(WhatsAppEtapaEnum.EMAIL);
            ret.add(WhatsAppEtapaEnum.GERAL);
            ret.add(WhatsAppEtapaEnum.VAGA);
            ret.add(WhatsAppEtapaEnum.COMO_SOUBE);
            ret.add(WhatsAppEtapaEnum.SEGUNDO_TELEFONE);
            ret.add(WhatsAppEtapaEnum.ESTOU_EM_PROCESSO);
            ret.add(WhatsAppEtapaEnum.DEPTO_PESSOAL);
            ret.add(WhatsAppEtapaEnum.OUTROS_ASSUNTOS);
        } else if (e.getNome().equals("neocrm")) {
            ret.add(WhatsAppEtapaEnum.INICIAL);
            ret.add(WhatsAppEtapaEnum.LOGIN_ACESSO);
            ret.add(WhatsAppEtapaEnum.NOME);
            ret.add(WhatsAppEtapaEnum.EMAIL);
            ret.add(WhatsAppEtapaEnum.ABRIR_CHAMADO);
            ret.add(WhatsAppEtapaEnum.ATENDENTE);
            ret.add(WhatsAppEtapaEnum.FECHADO);
        } else if (e.getNome().equals("prime")) {
            ret.add(WhatsAppEtapaEnum.INICIAL);
            ret.add(WhatsAppEtapaEnum.CPF_CNPJ);
            ret.add(WhatsAppEtapaEnum.ESCOLHA_CNPJ);
            ret.add(WhatsAppEtapaEnum.NOME);
            ret.add(WhatsAppEtapaEnum.EMAIL);
            ret.add(WhatsAppEtapaEnum.FUNCAO);
            ret.add(WhatsAppEtapaEnum.CONFIRMACAO_CADASTRO);
            ret.add(WhatsAppEtapaEnum.ABRIR_CHAMADO);
            ret.add(WhatsAppEtapaEnum.RESUMO);
            ret.add(WhatsAppEtapaEnum.ESCOLHA_TIPO);
            ret.add(WhatsAppEtapaEnum.ESCOLHA_CONSULTOR);
            ret.add(WhatsAppEtapaEnum.ATENDENTE);
            ret.add(WhatsAppEtapaEnum.FECHADO);
            ret.add(WhatsAppEtapaEnum.OPCOES);
        } else {
            ret.add(WhatsAppEtapaEnum.INICIAL);
            ret.add(WhatsAppEtapaEnum.CPF_CNPJ);
            ret.add(WhatsAppEtapaEnum.ESCOLHA_CNPJ);
            ret.add(WhatsAppEtapaEnum.NOME);
            ret.add(WhatsAppEtapaEnum.EMAIL);
            ret.add(WhatsAppEtapaEnum.FUNCAO);
            ret.add(WhatsAppEtapaEnum.CONFIRMACAO_CADASTRO);
            ret.add(WhatsAppEtapaEnum.ABRIR_CHAMADO);
            ret.add(WhatsAppEtapaEnum.RESUMO);
            ret.add(WhatsAppEtapaEnum.ESCOLHA_TIPO);
            ret.add(WhatsAppEtapaEnum.ESCOLHA_CONSULTOR);
            ret.add(WhatsAppEtapaEnum.ATENDENTE);
            ret.add(WhatsAppEtapaEnum.FECHADO);
            ret.add(WhatsAppEtapaEnum.COMO_CONHECEU);
        }
        return ret;
    }
}

