/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.components.importacao.ImportacaoColunas;
import br.com.system.app.components.importacao.ImportacaoExcel;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.whatsapp.service.WhatsAppImportacaoThread;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="importacao-whatsapp", layout=MainLayout.class)
@PageTitle(value="Importacao Cadastro Whatsapp")
@RolesAllowed(value={"MASTER"})
public class WhatsAppImportacaoView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private ImportacaoExcel ie;
    private final WhatsAppImportacaoThread whatsImportacaoThread;
    private List<ImportacaoColunas> colunas;

    @Autowired
    public WhatsAppImportacaoView(WhatsAppImportacaoThread whatsImportacaoThread) {
        this.whatsImportacaoThread = whatsImportacaoThread;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.create());
        }
    }

    private Component create() {
        this.setColunas();
        this.ie.getBtnConfirmar().addClickListener((ComponentEventListener & Serializable)e -> {
            if (!this.ie.isValido()) {
                this.showNotification("H\u00e1 colunas obrigatorias n\u00e3o vinculadas");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Importar Cadastro Whatsapp", "Confirma importa\u00e7\u00e3o?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirmar -> {
                try {
                    this.whatsImportacaoThread.importar(this.ie.getPosicoes(), this.ie.getContent(), this.ie.getNomeArquivo(), this.getEu());
                    UIUtils.showProcessNotification((String)"Importa\u00e7\u00e3o finalizada com sucesso");
                    this.ie.clear();
                    cd.close();
                }
                catch (Exception ex) {
                    this.showNotification("Erro ao importar, avise o suporte");
                }
            });
        });
        return new VerticalContainer(new Component[]{this.ie});
    }

    private void setColunas() {
        this.colunas = new ArrayList();
        this.colunas.add(new ImportacaoColunas("NUMERO", Boolean.TRUE));
        this.colunas.add(new ImportacaoColunas("CPF-CNPJ", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("NOME", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("FUNCAO", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("EMAIL", Boolean.FALSE));
        this.ie = new ImportacaoExcel(this.colunas);
    }
}

