/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.MainLayout;
import br.com.system.app.components.GridX;
import br.com.system.app.components.containers.Container;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.kanbanpedidos.model.KanbanPedidos;
import br.com.system.app.features.kanbanpedidos.service.KanbanPedidosService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoFilter;
import br.com.system.app.features.producaopainel.service.ProducaoPainelService;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.whatsapp.EtapaNotRead;
import br.com.system.app.features.whatsapp.WhatsAppConversaView;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.avatar.Avatar;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.spring.annotation.SpringComponent;
import com.vaadin.flow.spring.annotation.UIScope;
import com.vdurmont.emoji.EmojiParser;
import jakarta.annotation.security.PermitAll;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.vaadin.lineawesome.LineAwesomeIcon;

@SpringComponent
@PageTitle(value="WhatsApp")
@Route(value="whats-screen-view", layout=MainLayout.class)
@PermitAll
@UIScope
public class WhatsAppScreenView
extends ViewFrame {
    private static final long serialVersionUID = 1L;
    private final WhatsAppAtendimentoService whatsAppAtendimentoService;
    private final WhatsAppConversaView whatsAppConversaView;
    private final KanbanPedidosService kanbanPedidosService;
    private final WhatsAppContaService whatsappContaService;
    private final UsuarioHierarquiaService usuarioHierarquiaService;
    private final ProducaoPainelService producaoPainelService;
    private final WhatsAppService whatsAppService;
    private final WhatsAppHaveService whatsAppHaveService;
    private final TextField txtFiltro = UIUtils.createTextField((String)"Pesquisa");
    private final GridX<ProducaoPedidoDTO> gridX = new GridX(ProducaoPedidoDTO.class);
    private final HorizontalContainer statusContainer = new HorizontalContainer(new Component[0]);
    private final Button btnNovaConversa = UIUtils.createInsertButton((String)"");
    private final Button btnDoFind = UIUtils.createSearchButton();
    private final ComboBox<WhatsAppConta> cbConta = new ComboBox();
    private final PedidoEtapa statusInicial;
    private final VerticalContainer conteinerConversa = new VerticalContainer(new Component[0]);
    private final Image iconNewMessage = new Image();
    private final Map<Long, EtapaNotRead> mapEtapa = new HashMap();
    private List<KanbanPedidos> filas;
    private Set<Long> hierarquia;
    private PedidoEtapa statusAtual;
    private WhatsAppAtendimento atendimentoSelecionado = null;

    @Autowired
    public WhatsAppScreenView(WhatsAppAtendimentoService whatsAppAtendimentoService, WhatsAppConversaView whatsAppConversaView, KanbanPedidosService kanbanPedidosService, PedidoEtapaService pedidoEtapaService, WhatsAppContaService whatsappContaService, UsuarioHierarquiaService usuarioHierarquiaService, ProducaoPainelService producaoPainelService, WhatsAppService whatsAppService, WhatsAppHaveService whatsAppHaveService) {
        this.whatsappContaService = whatsappContaService;
        this.whatsAppHaveService = whatsAppHaveService;
        this.whatsAppService = whatsAppService;
        this.producaoPainelService = producaoPainelService;
        this.whatsAppAtendimentoService = whatsAppAtendimentoService;
        this.kanbanPedidosService = kanbanPedidosService;
        this.whatsAppConversaView = whatsAppConversaView;
        this.statusInicial = pedidoEtapaService.getEtapaInicial(this.getEstrutura(), PedidoTipoEnum.WHATSAPP);
        this.usuarioHierarquiaService = usuarioHierarquiaService;
        this.create();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.povoa();
    }

    private void create() {
        this.iconNewMessage.setSrc("images/whats.gif");
        this.iconNewMessage.setWidth("20px");
        this.iconNewMessage.setHeight("20px");
        this.txtFiltro.getStyle().set("padding", "unset");
        this.txtFiltro.setPlaceholder("Por numero, nome ou cpf-cnpj");
        this.txtFiltro.setWidth("100%");
        this.cbConta.getStyle().set("padding", "unset");
        this.btnDoFind.addClickListener((ComponentEventListener & Serializable)e -> this.povoa());
        this.gridX.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> this.getConversa(p))).setHeader("Conversas").setFlexGrow(0).setWidth("335px");
        this.gridX.setWidth("340px");
        this.gridX.setPageSize(60);
        this.gridX.addItemClickListener((ComponentEventListener & Serializable)e -> {
            WhatsAppAtendimento conversa;
            this.atendimentoSelecionado = null;
            if (!this.gridX.getSelectedItems().isEmpty() && (conversa = this.whatsAppAtendimentoService.getById(((ProducaoPedidoDTO)e.getItem()).getWhatsappAtendimentoId())) != null) {
                this.whatsAppAtendimentoService.setRead(conversa);
                this.atendimentoSelecionado = conversa;
                this.conteinerConversa.removeAll();
                this.conteinerConversa.add(new Component[]{this.whatsAppConversaView.create(conversa, this.filas, arg_0 -> this.listenerStatus(arg_0))});
                this.povoa();
            }
        });
        List contas = this.whatsappContaService.getAtivos(this.getEstrutura());
        if (contas.size() <= 0) {
            UIUtils.showError((String)"Nao ha contas de whatsapp configuradas nesta estrutura");
            return;
        }
        this.cbConta.setItemLabelGenerator(WhatsAppConta::getNumero);
        this.cbConta.setWidth("330px");
        this.cbConta.setItems((Collection)contas);
        if (this.getUsuario().getWhatsappConta() != null) {
            this.cbConta.setValue((Object)this.getUsuario().getWhatsappConta());
            this.cbConta.setVisible(false);
        } else {
            this.cbConta.setValue((Object)((WhatsAppConta)contas.get(0)));
        }
        if (contas.size() == 1) {
            this.cbConta.setValue((Object)((WhatsAppConta)contas.get(0)));
            this.cbConta.setVisible(false);
        }
        this.cbConta.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.povoa());
        this.btnNovaConversa.setTooltipText("Nova Conversa");
        this.btnNovaConversa.addClickListener((ComponentEventListener & Serializable)e -> this.newConversation());
        HorizontalContainer filterContainer = new HorizontalContainer(new Component[]{this.txtFiltro, this.btnDoFind, this.btnNovaConversa}).setNoWrap();
        filterContainer.setWidthFull();
        VerticalContainer leftContainer = new VerticalContainer(new Component[]{this.cbConta, filterContainer, this.gridX});
        leftContainer.setWidth("360px");
        leftContainer.setHeight("100%");
        leftContainer.setAlignItems(FlexComponent.Alignment.START);
        this.statusContainer.setAlignSelf(FlexComponent.Alignment.START, new HasElement[0]);
        this.conteinerConversa.setHeightFull();
        this.conteinerConversa.setId("containerMessages");
        VerticalContainer rightContainer = new VerticalContainer(new Component[]{this.statusContainer, this.conteinerConversa});
        rightContainer.setWidth("100%");
        rightContainer.setHeight("100%");
        rightContainer.setAlignItems(FlexComponent.Alignment.CENTER);
        HorizontalContainer body = new HorizontalContainer(new Component[]{leftContainer, rightContainer}).setNoWrap();
        body.setPaddingOff();
        body.setSpacingOff();
        body.setHeight("100%");
        body.setWidth("100%");
        this.add(new Component[]{body});
        this.hierarquia = this.hasPermission("IGNORAR_HIERARQUIA") ? new HashSet() : (this.hasPermission("KANBAN_VER_HIERARQUIA") || this.getEu().getUsuario().getPerfil().equals((Object)UsuarioPerfilEnum.ADMINISTRATIVO) || this.getEu().getUsuario().getPerfil().equals((Object)UsuarioPerfilEnum.PROPRIETARIO) ? this.usuarioHierarquiaService.getHierarquia(this.getEu()) : new HashSet<Long>(Arrays.asList(this.getEu().getId())));
    }

    public void listenerStatus(Map<WhatsAppAtendimento, PedidoEtapa> map) {
        this.conteinerConversa.removeAll();
        this.povoa();
    }

    public void listener(WhatsAppAtendimento c) {
        ((UI)this.getUI().get()).access((Command & Serializable)() -> this.povoa());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void povoa() {
        ProducaoPedidoFilter ppf;
        block7: {
            if (!this.isAttached()) {
                return;
            }
            this.mapEtapa.clear();
            this.statusAtual = this.statusAtual == null ? this.statusInicial : this.statusAtual;
            this.povoaStatus();
            ppf = new ProducaoPedidoFilter(this.getEstrutura());
            ppf.setKanban(true);
            ppf.setHierarquia(this.hierarquia);
            ppf.setPedidoTipo(PedidoTipoEnum.WHATSAPP);
            ppf.setFilterPedidoEtapa(new HashSet<Long>(Arrays.asList(this.statusAtual.getId())));
            ppf.setSomenteComAtendimento(Boolean.valueOf(true));
            if (this.txtFiltro.getValue() != null && !this.txtFiltro.getValue().isEmpty() && TelefoneUtil.isValid((String)this.txtFiltro.getValue())) {
                WhatsAppHave have = this.whatsAppHaveService.getHave(this.txtFiltro.getValue());
                if (have != null && have.getHave().booleanValue()) {
                    ppf.setNumeroWhats(have.getNumeroWhats());
                    break block7;
                } else {
                    this.showNotification("Numero invalido, nao tem whatsapp");
                    return;
                }
            }
            if (this.txtFiltro.getValue() != null && !this.txtFiltro.getValue().isEmpty() && ValidationUtil.isValidCnpjAndCpf((String)this.txtFiltro.getValue())) {
                ppf.setFilterCnpj(new HashSet<String>(Arrays.asList(this.txtFiltro.getValue())));
            } else if (this.txtFiltro.getValue() != null && !this.txtFiltro.getValue().isEmpty()) {
                ppf.setNomeWhats(this.txtFiltro.getValue());
            }
        }
        this.gridX.setItems((CallbackDataProvider.FetchCallback & Serializable)query -> this.producaoPainelService.getProducaoByFilter(this.getEu(), ppf, (Pageable)this.gridX.page(query)).stream());
    }

    private HorizontalContainer getConversa(ProducaoPedidoDTO conversa) {
        String texto = conversa.getWhatsUltimaMensagem() == null ? "" : (conversa.getWhatsUltimaMensagem().length() > 35 ? conversa.getWhatsUltimaMensagem().substring(0, 35) + "..." : conversa.getWhatsUltimaMensagem());
        texto = EmojiParser.parseToUnicode((String)texto);
        Avatar avatar = new Avatar(conversa.getWhatsappNome() == null ? "Sem Nome" : conversa.getWhatsappNome());
        avatar.getStyle().set("align-self", "center");
        Span spanNovas = new Span(new Component[]{this.iconNewMessage});
        spanNovas.getElement().getThemeList().add((Object)"badge success");
        if (conversa.getWhatsLida() != null && !conversa.getWhatsLida().booleanValue()) {
            spanNovas.setVisible(true);
            if (this.mapEtapa.containsKey(conversa.getPedidoEtapaId())) {
                EtapaNotRead enr = (EtapaNotRead)this.mapEtapa.get(conversa.getPedidoEtapaId());
                enr.setQtde(Integer.valueOf(enr.getQtde() + 1));
                this.mapEtapa.put(conversa.getPedidoEtapaId(), enr);
                enr.getButton().setText(enr.getNomeButton() + "(" + enr.getQtde() + ")");
            }
        } else {
            spanNovas.setVisible(false);
        }
        String nome = conversa.getWhatsappNome() == null ? conversa.getWhatsappNumero() : conversa.getWhatsappNumero() + " " + conversa.getWhatsappNome();
        nome = nome.length() > 33 ? nome.substring(0, 33) + "..." : nome;
        VerticalContainer containerDados = new VerticalContainer(new Component[]{new HorizontalContainer(new Component[]{new Span(nome), spanNovas}).setHorizontalAlign(FlexComponent.JustifyContentMode.START), new HorizontalContainer(new Component[]{new Span(texto)}).setHorizontalAlign(FlexComponent.JustifyContentMode.START)}).setHorizontalAlign(FlexComponent.Alignment.START);
        HorizontalContainer cc = new HorizontalContainer(new Component[]{avatar, containerDados}).setHorizontalAlign(FlexComponent.JustifyContentMode.START).setNoWrap();
        if (this.atendimentoSelecionado != null && conversa.getWhatsappAtendimentoId().equals(this.atendimentoSelecionado.getId())) {
            cc.getStyle().set("background-color", "#436071");
            cc.getStyle().set("color", "#ffffff");
        } else {
            cc.getStyle().remove("background-color");
            cc.getStyle().set("color", "#000000");
        }
        return cc;
    }

    private void povoaStatus() {
        this.statusContainer.removeAll();
        int totalNotRead = 0;
        this.filas = this.kanbanPedidosService.getKanban(this.getEu().getId(), PedidoTipoEnum.WHATSAPP);
        for (KanbanPedidos fila : this.filas) {
            Button b = new Button(fila.getPedidoEtapa().getNome());
            EtapaNotRead enr = new EtapaNotRead();
            enr.setButton(b);
            enr.setNomeButton(fila.getPedidoEtapa().getNome());
            enr.setQtde(Integer.valueOf(0));
            this.mapEtapa.put(fila.getPedidoEtapa().getId(), enr);
            b.getStyle().remove("background-color");
            if (this.statusAtual.getNome().equals(fila.getPedidoEtapa().getNome())) {
                b.getStyle().set("background-color", "darkcyan");
            }
            b.addClickListener((ComponentEventListener & Serializable)e -> {
                this.statusAtual = fila.getPedidoEtapa();
                this.conteinerConversa.removeAll();
                this.atendimentoSelecionado = null;
                this.povoa();
            });
            this.statusContainer.add(new Component[]{b});
        }
        ((UI)this.getUI().get()).getPage().setTitle((String)(totalNotRead > 0 ? "WhatsApp (" + totalNotRead + ")" : "WhatsApp"));
    }

    private void newConversation() {
        Container c = new Container();
        c.getButtonClose().addClickListener((ComponentEventListener & Serializable)close -> c.close());
        c.setHeader("Nova Conversa");
        TextField txtNumero = new TextField("N\u00famero Whats");
        TextField txtNome = new TextField("Nome");
        Button btnIniciar = UIUtils.createButton((String)"Iniciar Conversa", (LineAwesomeIcon)LineAwesomeIcon.WHATSAPP);
        btnIniciar.addClickListener((ComponentEventListener & Serializable)e -> {
            try {
                if (!TelefoneUtil.isValid((String)txtNumero.getValue())) {
                    UIUtils.showWarning((String)"Telefone parece estar inv\u00e1lido");
                    return;
                }
                if (txtNome.getValue() == null || txtNome.getValue().isEmpty()) {
                    UIUtils.showWarning((String)"Informe um nome");
                    return;
                }
                WhatsAppHave have = this.whatsAppHaveService.getHave(txtNumero.getValue());
                if (have == null || !have.getHave().booleanValue()) {
                    this.showNotification("Este numero nao tem WhatsApp");
                    return;
                }
                WhatsApp w = this.whatsAppService.getAndCreate(have.getNumeroWhats(), this.getEu(), (WhatsAppConta)this.cbConta.getValue(), WhatsAppEtapaEnum.ATENDENTE, txtNome.getValue());
                if (w == null) {
                    this.showNotification("Erro ao criar whatsapp, verifique este numero, se o erro persistir, entre em contato com o suporte");
                    return;
                }
                List conversas = this.whatsAppAtendimentoService.getAbertos(w);
                if (!conversas.isEmpty()) {
                    UIUtils.showError((String)"J\u00e1 existe uma conversa com esse n\u00famero");
                    this.findConversation(have.getNumeroWhats(), ((WhatsAppAtendimento)conversas.get(0)).getPedido().getPedidoEtapa());
                    this.povoa();
                    c.close();
                    return;
                }
                WhatsAppAtendimento conversa = this.whatsAppAtendimentoService.getAndCreate(w, null, WhatsAppEtapaEnum.ATENDENTE);
                this.statusAtual = conversa.getPedido().getPedidoEtapa();
                c.close();
                this.povoa();
            }
            catch (Exception ex) {
                UIUtils.showError((String)ex.getMessage());
            }
        });
        c.insert(new Component[]{txtNome, txtNumero, btnIniciar});
        c.setJustClose();
        c.open();
    }

    private void findConversation(String number, PedidoEtapa pedidoEtapa) {
        if (!pedidoEtapa.getEstrutura().getId().equals(this.getEstrutura().getId())) {
            return;
        }
        this.statusAtual = pedidoEtapa;
        this.txtFiltro.setValue(number);
    }
}

