/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.whatsapp.dto.WhatsAppAtendimentoDTO;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WhatsAppAtendimentoExportacao
implements Serializable {
    private static final long serialVersionUID = 1L;

    public String exportMovimentacao(List<WhatsAppAtendimentoDTO> atendimentos) {
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = StorageUtil.getObjectModelo((String)"ExportacaoAtendimento-v4.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            CellStyle styleCellDouble = xls.createCellStyle();
            styleCellDouble.setDataFormat((short)2);
            int linha = 1;
            for (WhatsAppAtendimentoDTO wa : atendimentos) {
                int col = 0;
                Row row = aba.createRow(linha);
                row.createCell(col).setCellValue((double)wa.getId().longValue());
                row.createCell(++col).setCellValue(wa.getPedidoId() == null ? "" : wa.getPedidoId().toString());
                row.createCell(++col).setCellValue(wa.getCnpj());
                row.createCell(++col).setCellValue(wa.getNomeCliente());
                row.createCell(++col).setCellValue(wa.getNumero());
                row.createCell(++col).setCellValue(wa.getNome());
                row.createCell(++col).setCellValue(wa.getEmail());
                row.createCell(++col).setCellValue(wa.getFuncao());
                row.createCell(++col).setCellValue(wa.getEtapa());
                row.createCell(++col).setCellValue(wa.getUltimaMensagem());
                row.createCell(++col).setCellValue(wa.getEscolhaTipo() == null ? "" : wa.getEscolhaTipo());
                row.createCell(++col).setCellValue(wa.getNomeUsuario());
                row.createCell(++col).setCellValue(wa.getLogin());
                String tempo = "";
                if (wa.getDataTransf() != null && wa.getDataFim() != null) {
                    tempo = String.valueOf(Duration.between(wa.getDataTransf(), wa.getDataFim()).toMinutes());
                }
                row.createCell(++col).setCellValue(tempo);
                row.createCell(++col).setCellValue(wa.getDataInicio() == null ? "" : wa.getDataInicio().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(++col).setCellValue(wa.getDataTransf() == null ? "" : wa.getDataTransf().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(++col).setCellValue(wa.getDataFim() == null ? "" : wa.getDataFim().format(FormatDate.DATETIME_BR.toDTF()));
                ++linha;
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                atendimentos = null;
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
    }
}

