/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.whatsapp.dto.WhatsAppAtendimentoDTO;
import br.com.system.app.features.whatsapp.dto.WhatsAppFiltroEnum;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppControle;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import br.com.system.app.features.whatsapp.repository.WhatsAppAtendimentoRepository;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendenteService;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import br.com.system.app.features.whatsapp.service.WhatsAppMensagemService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.commons.TelefoneUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WhatsAppAtendimentoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ConfigurationsService configurationsService;
    @Autowired
    private WhatsAppAtendimentoRepository repository;
    @Autowired
    private WhatsAppHaveService whatsAppHaveService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private PedidoEtapaService pedidoEtapaService;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppControleService controleService;
    @Autowired
    private WhatsAppAtendenteService whatsAppAtendenteService;
    @Autowired
    private WhatsAppMensagemService whatsAppMensagemService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private UsuarioService usuarioService;

    public void fechar(WhatsAppAtendimento wa, EstruturaUsuario eu, boolean notificar) {
        wa.setEtapa(WhatsAppEtapaEnum.FECHADO);
        wa.setDataHoraFim(LocalDateTime.now());
        wa.setFechado(true);
        this.save(wa);
        WhatsApp w = wa.getWhatsapp();
        w.setEtapa(WhatsAppEtapaEnum.FECHADO);
        this.whatsAppService.save(w);
        Pedido pedido = wa.getPedido();
        if (pedido != null) {
            pedido.setPedidoEtapa(this.pedidoEtapaService.getEtapaFinal(w.getWhatsappConta().getEstrutura(), pedido.getPedidoTipo()));
            this.pedidoService.salvar(pedido, "Atendimento fechado", eu, notificar);
        }
    }

    @Async(value="asyncDefault")
    public void closeByAtividadeNumber(Set<String> lista, EstruturaUsuario eu) {
        for (String s : lista) {
            WhatsAppAtendimento wa = this.getByPedido(Long.valueOf(s));
            if (wa == null || !wa.getWhatsapp().getWhatsappConta().getEstrutura().getId().equals(eu.getEstrutura().getId())) continue;
            this.fechar(wa, eu, false);
        }
        this.notificacoesService.notify(eu, "Fechamento de atendimentos", "Seus atendimentos foram fechados com sucesso!");
    }

    @Async(value="asyncDefault")
    public void closeByAtividadeId(Set<String> lista, EstruturaUsuario eu) {
        for (String id : lista) {
            WhatsAppAtendimento wa = this.getById(Long.valueOf(id));
            if (wa == null || !wa.getWhatsapp().getWhatsappConta().getEstrutura().getId().equals(eu.getEstrutura().getId())) continue;
            this.fechar(wa, eu, false);
        }
        this.notificacoesService.notify(eu, "Fechamento de atendimentos", "Seus atendimentos foram fechados com sucesso!");
    }

    public void transferir(WhatsAppAtendimento wa, EstruturaUsuario euTransf) {
        wa.setAtendente(euTransf);
        this.save(wa);
        WhatsApp w = wa.getWhatsapp();
        this.whatsAppService.save(w);
    }

    @Async(value="asyncDefault")
    public void checkPool(EstruturaUsuario eu) {
        WhatsAppAtendente atendente = this.whatsAppAtendenteService.getAtendente(eu);
        if (atendente == null) {
            return;
        }
        EstruturaUsuario master = this.eus.getMasterEstrutura(eu.getEstrutura());
        List lista = this.getByAtendente(master);
        for (WhatsAppAtendimento wa : lista) {
            WhatsApp w = wa.getWhatsapp();
            EstruturaUsuario euAtendente = atendente.getWhatsappSetores() == null ? this.whatsAppAtendenteService.getAtendenteOnline(w, master) : eu;
            if (euAtendente == null || !euAtendente.getId().equals(eu.getId())) continue;
            w.setUltimoAtendente(euAtendente);
            this.whatsAppService.save(w);
            wa.setAtendente(euAtendente);
            this.save(wa);
            WhatsAppMensagem wm = this.whatsAppMensagemService.inserirAnotacao(wa, euAtendente, "Transferido do master");
            this.controleService.gravarNova(wm, WhatsAppStatusEnum.LIDA);
        }
    }

    public void reabrir(WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario euTransf) {
        w.setUltimoAtendente(euTransf);
        w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        w = this.whatsAppService.save(w);
        wa.setWhatsapp(w);
        wa.setAtendente(euTransf);
        wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        wa.setFechado(false);
        wa.setFechadoInatividade(false);
        this.save(wa);
    }

    public WhatsAppAtendimento getById(Long id) {
        return this.repository.findById((Object)id).orElse(null);
    }

    public WhatsAppAtendimento getByPedido(Long pedidoId) {
        return this.repository.findFirstByPedidoId(pedidoId);
    }

    public List<WhatsAppAtendimento> getByWhatsappAndEtapa(WhatsApp w, WhatsAppEtapaEnum etapa) {
        return this.repository.findByWhatsappAndEtapa(w, etapa);
    }

    public List<WhatsAppAtendimento> getByAtendente(EstruturaUsuario eu) {
        return this.repository.findByAtendenteAndEtapa(eu, WhatsAppEtapaEnum.ATENDENTE);
    }

    public List<WhatsAppAtendimento> getByHierarquia(Set<Long> hierarquia, Pageable pageable) {
        return this.repository.findByAtendenteIdInAndEtapaOrderByIdDesc(hierarquia, WhatsAppEtapaEnum.ATENDENTE, pageable);
    }

    public List<WhatsAppAtendimento> getByHierarquiaAndNumero(Set<Long> hierarquia, String numero, Pageable pageable) {
        return this.repository.findByAtendenteIdInAndEtapaAndWhatsappNumeroOrderByIdDesc(hierarquia, WhatsAppEtapaEnum.ATENDENTE, numero, pageable);
    }

    public List<WhatsAppAtendimento> getAbertosByCnpj(Estrutura e, String cnpj) {
        return this.repository.findByWhatsappWhatsappContaEstruturaAndFechadoAndCnpj(e, false, cnpj);
    }

    public List<WhatsAppAtendimento> getByWhatsapp(WhatsApp w, String cnpj) {
        return this.repository.findByWhatsappAndCnpjOrderByIdDesc(w, cnpj);
    }

    public WhatsAppAtendimento getFirst(WhatsApp w) {
        return this.repository.findFirstByWhatsappOrderByIdDesc(w);
    }

    public List<WhatsAppAtendimento> getAbertos(WhatsApp w) {
        if (w == null) {
            // empty if block
        }
        return this.repository.findByWhatsappAndFechadoOrderByIdDesc(w, false);
    }

    public List<WhatsAppAtendimento> getAtendimentos(WhatsApp w) {
        return this.repository.findByWhatsapp(w);
    }

    public List<WhatsAppAtendimentoDTO> getCadastros(Estrutura estrutura, LocalDate dIni, LocalDate dFim, WhatsAppFiltroEnum filtro, Set<String> cnpjs, Set<String> numeros) {
        return this.repository.findAtendimento(dIni.atStartOfDay(), dFim.atTime(LocalTime.MAX), estrutura, null, null, filtro, cnpjs, numeros);
    }

    public List<WhatsAppAtendimentoDTO> getMais10Minutos(Estrutura estrutura) {
        return this.repository.findAtendimento(null, null, estrutura, null, WhatsAppEtapaEnum.ATENDENTE, WhatsAppFiltroEnum.MAIS_10MINUTOS, null, null);
    }

    public List<WhatsAppAtendimentoDTO> getAtendimento(Estrutura estrutura, EstruturaUsuario eu, LocalDate dIni, LocalDate dFim, WhatsAppEtapaEnum etapa, Set<String> cnpjs, Set<String> numeros) {
        return this.getAtendimento(estrutura, eu, dIni, dFim, etapa, cnpjs, numeros, WhatsAppFiltroEnum.TODOS);
    }

    public List<WhatsAppAtendimentoDTO> getAtendimento(Estrutura estrutura, EstruturaUsuario eu, LocalDate dIni, LocalDate dFim, WhatsAppEtapaEnum etapa, Set<String> cnpjs, Set<String> numeros, WhatsAppFiltroEnum filtroEnum) {
        HashSet<String> whatsNum = new HashSet<String>();
        for (String numero : numeros) {
            WhatsAppHave have = this.whatsAppHaveService.getHave(numero);
            if (have != null && have.getHave().booleanValue()) {
                whatsNum.add(have.getNumeroWhats());
            }
            have = null;
        }
        numeros = null;
        return this.repository.findAtendimento(dIni != null ? dIni.atStartOfDay() : null, dFim != null ? dFim.atTime(LocalTime.MAX) : null, estrutura, eu, etapa, filtroEnum, cnpjs, whatsNum);
    }

    public WhatsAppAtendimento save(WhatsAppAtendimento wa) {
        return this.save(wa, null);
    }

    public WhatsAppAtendimento save(WhatsAppAtendimento wa, PedidoEtapa etapaAtividade) {
        Pedido p = wa.getPedido();
        if (p != null) {
            if (wa.getCnpj() != null && !wa.getCnpj().isEmpty() && !wa.getCnpj().equals(wa.getPedido().getCliente().getCpfCnpj())) {
                p.setCliente(this.clienteService.getAndCreateCliente(wa.getAtendente(), wa.getCnpj(), new ClienteContato[]{new ClienteContato(TipoContatoEnum.TELEFONE, TelefoneUtil.normalize((String)wa.getWhatsapp().getNumero()))}));
            }
            if (etapaAtividade != null) {
                p.setPedidoEtapa(etapaAtividade);
            }
            p.setEstruturaUsuario(wa.getAtendente());
            p.setDataHoraAtualizacao(LocalDateTime.now());
            this.pedidoService.salvar(p);
        }
        if (wa.getLida() == null) {
            wa.setLida(Boolean.TRUE);
        }
        return (WhatsAppAtendimento)this.repository.save((Object)wa);
    }

    public void setRead(WhatsAppAtendimento wa) {
        wa.setLida(Boolean.TRUE);
        if (wa.getLida() == null) {
            wa.setLida(Boolean.TRUE);
        }
        this.repository.save((Object)wa);
    }

    public WhatsAppAtendimento getAndCreate(WhatsApp w, Pedido pedido) {
        return this.getAndCreate(w, pedido, null);
    }

    public WhatsAppAtendimento getAndCreate(WhatsApp w, Pedido pedido, WhatsAppEtapaEnum etapa) {
        List abertos = this.getAbertos(w);
        if (w.getErros() != null && w.getErros() >= 4 && w.getDataErro().equals(LocalDate.now())) {
            if (!abertos.isEmpty()) {
                if (etapa == null) {
                    etapa = WhatsAppEtapaEnum.FECHADO;
                }
                WhatsAppAtendimento wa = (WhatsAppAtendimento)abertos.get(0);
                wa.setFechado(true);
                wa.setEtapa(etapa);
                wa.setDataHoraFim(LocalDateTime.now());
                wa.setLida(Boolean.TRUE);
                this.repository.save((Object)wa);
            }
            return null;
        }
        if (abertos.size() <= 0) {
            WhatsAppAtendimento wa = new WhatsAppAtendimento();
            wa.setAtendente(w.getUltimoAtendente());
            wa.setDataHoraInicio(LocalDateTime.now());
            wa.setFechado(false);
            wa.setEtapa(etapa == null ? WhatsAppEtapaEnum.INICIAL : etapa);
            wa.setWhatsapp(w);
            wa.setCnpj(w.getCnpjEscolhido());
            String cnpj = wa.getCnpj() == null || wa.getCnpj().isEmpty() ? w.getWhatsappConta().getEstrutura().getCpfCnpj() : wa.getCnpj();
            if (pedido == null) {
                pedido = new Pedido();
                pedido.setCliente(this.clienteService.getAndCreateCliente(w.getUltimoAtendente(), cnpj, new ClienteContato[0]));
                pedido.setDataCadastro(LocalDate.now());
                pedido.setDataHoraAtualizacao(LocalDateTime.now());
                pedido.setDataHoraUltimaMov(LocalDateTime.now());
                pedido.setEstruturaUsuario(w.getUltimoAtendente());
                pedido.setPedidoTipo(PedidoTipoEnum.WHATSAPP);
                pedido.setPedidoEtapa(this.pedidoEtapaService.getEtapaInicial(w.getWhatsappConta().getEstrutura(), PedidoTipoEnum.WHATSAPP));
                pedido = this.pedidoService.salvar(pedido);
            }
            wa.setLida(Boolean.TRUE);
            wa.setPedido(pedido);
            wa = (WhatsAppAtendimento)this.repository.save((Object)wa);
            if (w.getWhatsappConta().getId().equals(161L)) {
                Usuario u = null;
                if (wa.getWhatsapp().getLogin() != null && !wa.getWhatsapp().getLogin().isEmpty()) {
                    u = this.usuarioService.getByLogin(wa.getWhatsapp().getLogin());
                } else {
                    List lu = this.usuarioService.getByCelular(TelefoneUtil.normalize((String)w.getNumero()));
                    if (lu.size() == 1) {
                        u = (Usuario)lu.get(0);
                    }
                }
                StringBuilder anotacao = new StringBuilder();
                if (u == null) {
                    anotacao.append("Usu\u00e1rio n\u00e3o encontrado");
                } else {
                    anotacao.append("Login: ").append(u.getLogin()).append("<BR>");
                    anotacao.append("Perfil: ").append(u.getPerfil()).append("<BR>");
                    anotacao.append("Nome: ").append(u.getNome()).append("<BR>");
                    anotacao.append("Celular: ").append(u.getCelular() == null ? "" : u.getCelular()).append("<BR>");
                    w.setEmail(u.getEmail());
                    w.setLogin(u.getLogin());
                    w.setNome(u.getNome());
                    w = this.whatsAppService.save(w);
                }
                this.whatsAppMensagemService.inserirAnotacao(wa, wa.getAtendente(), anotacao.toString());
            }
            return wa;
        }
        return (WhatsAppAtendimento)abertos.get(0);
    }

    public List<Long> getInativos() {
        return this.repository.findInativos(LocalDateTime.now().minusMinutes(this.configurationsService.get(ConfigurationEnum.TEMPO_FECHAMENTO_ATENDIMENTO_INATIVO).getIntValue().intValue()));
    }

    @Transactional
    public void deleteByWhatsApp(Long whatsAppId) throws Exception {
        WhatsApp w = this.whatsAppService.getById(whatsAppId);
        if (w == null) {
            return;
        }
        List listaDel = this.getAtendimentos(w);
        for (WhatsAppAtendimento waDel : listaDel) {
            for (WhatsAppControle wc : this.controleService.getAll(waDel)) {
                this.controleService.delete(wc);
            }
            for (WhatsAppMensagem wm : this.whatsAppMensagemService.getByAtendimento(waDel)) {
                this.whatsAppMensagemService.deleteMensage(wm);
            }
            if (waDel.getPedido() != null) {
                this.pedidoService.delete(waDel.getPedido());
            }
            this.repository.delete((Object)waDel);
        }
        this.whatsAppService.delete(w);
    }
}

