/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service.bot;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteContatoVerficadoEnum;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppFuncaoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendenteService;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.app.features.whatsapp.service.WhatsAppTimeService;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppBotMaxplanet325
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppSendService sendService;
    @Autowired
    private WhatsAppAtendenteService whatsAppAtendenteService;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private WhatsAppControleService whatsAppControleService;
    @Autowired
    private WhatsAppTimeService whatsAppTimeService;

    public void botDefault(WhatsAppAtendimento wa, EstruturaUsuario master, String resposta) {
        WhatsApp w = wa.getWhatsapp();
        if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.INICIAL)) {
            if (w.getCpfCnpj() == null || w.getEmail() == null || w.getNome() == null || w.getFuncao() == null) {
                this.sendService.sendMessageText(wa, master, "Ol\u00e1, seja bem vindo.\nSou o atendente virtual da MAXPLANET e vou guia-lo no atendimento.");
                this.sendService.sendMessageText(wa, master, "Seu telefone ainda n\u00e3o est\u00e1 no nosso cadastro. Vamos faz\u00ea-lo agora.\n\u00c9 rapidinho, apenas 4 perguntas.\n\nInforme por favor o CNPJ da sua empresa");
                w.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
                wa.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
            } else {
                this.mostrarCnpj(w, wa, master);
                w.setEtapa(WhatsAppEtapaEnum.ESCOLHA_CNPJ);
                wa.setEtapa(WhatsAppEtapaEnum.ESCOLHA_CNPJ);
            }
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.ESCOLHA_CNPJ)) {
            if (resposta.equals("Inserir Novo")) {
                this.sendService.sendMessageText(wa, master, "Ok, informe o CNPJ para cadastrar");
                w.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
                wa.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
            } else {
                if (!ValidationUtil.isValidCnpjAndCpf((String)resposta) || !w.getCpfCnpj().contains(resposta)) {
                    this.mostrarCnpj(w, wa, master);
                    w.setDataErro(LocalDate.now());
                    w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                    this.whatsAppService.save(w);
                    return;
                }
                if (!this.whatsAppTimeService.noHorario(wa)) {
                    this.whatsAppTimeService.sendOffTime(wa);
                    return;
                }
                this.sendService.sendMessageText(wa, master, "Descreva sua solicita\u00e7\u00e3o para que possamos encaminhar ao atendente");
                w.setEtapa(WhatsAppEtapaEnum.RESUMO);
                w.setCnpjEscolhido(resposta);
                wa.setCnpj(w.getCnpjEscolhido());
                wa.setEtapa(WhatsAppEtapaEnum.RESUMO);
            }
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.CPF_CNPJ)) {
            String cpfCnpj = StringUtil.numbersOnly((String)resposta);
            if (!ValidationUtil.isValidCnpjAndCpf((String)cpfCnpj)) {
                this.sendService.sendMessageText(wa, master, "Este CNPJ (" + resposta + ") parece estar inv\u00e1lido, vamos tentar novamente?\nInforme seu Cnpj");
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            if (w.getCpfCnpj() == null || w.getCpfCnpj().isEmpty()) {
                w.setCpfCnpj(cpfCnpj);
            } else {
                w.setCpfCnpj(w.getCpfCnpj() + "," + cpfCnpj);
            }
            this.sendService.sendMessageText(wa, master, "S\u00f3 um minuto, vou pesquisar no nosso banco de dados");
            Cliente cliente = this.clienteService.getAndCreateCliente(master, cpfCnpj, new ClienteContato[0]);
            if (cliente.getNome() != null && !cliente.getNome().isEmpty()) {
                this.sendService.sendMessageText(wa, master, "J\u00e1 achei aqui, " + cliente.getNome());
            }
            if (w.getCpfCnpj().length() > 20 && w.getNome() != null && w.getEmail() != null && w.getFuncao() != null) {
                this.enviarAtendente(w, wa, master);
            } else if (cpfCnpj.length() == 11 && cliente.getNome() != null && !cliente.getNome().isEmpty()) {
                w.setEtapa(WhatsAppEtapaEnum.EMAIL);
                wa.setEtapa(WhatsAppEtapaEnum.EMAIL);
                w.setNome(cliente.getNome());
                this.sendService.sendMessageText(wa, master, "Agora informe seu e-mail");
            } else {
                w.setEtapa(WhatsAppEtapaEnum.NOME);
                wa.setEtapa(WhatsAppEtapaEnum.NOME);
                this.sendService.sendMessageText(wa, master, "Agora informe seu nome completo");
            }
            w.setCnpjEscolhido(cpfCnpj);
            wa.setCnpj(w.getCnpjEscolhido());
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.NOME)) {
            String nome = resposta;
            if (nome.split(" ").length < 2) {
                this.sendService.sendMessageText(wa, master, "Informa\u00e7\u00e3o inv\u00e1lida, informe seu nome completo, com NOME e SOBRENOME");
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            w.setEtapa(WhatsAppEtapaEnum.EMAIL);
            w.setNome(nome);
            this.sendService.sendMessageText(wa, master, "Agora informe seu E-mail");
            wa.setEtapa(WhatsAppEtapaEnum.EMAIL);
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.EMAIL)) {
            String email = resposta;
            if (!ValidationUtil.isValidEmail((String)email)) {
                this.sendService.sendMessageText(wa, master, "Este E-mail(" + email + ") parece estar inv\u00e1lido, vamos tentar novamente?\nInforme seu E-mail");
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            try {
                ClienteContato cc = new ClienteContato(TipoContatoEnum.EMAIL, email, ClienteContatoVerficadoEnum.VALIDO);
                this.clienteService.getAndCreateCliente(master, w.getCnpjEscolhido(), new ClienteContato[]{cc});
            }
            catch (Exception e) {
                System.out.println("Erro whatsapp ao gravar email no cliente " + e.getMessage());
            }
            w.setEtapa(WhatsAppEtapaEnum.FUNCAO);
            w.setEmail(email);
            ArrayList<String> buttons = new ArrayList<String>();
            buttons.add("S\u00f3cio");
            buttons.add("Colaborador");
            buttons.add("Outros");
            this.sendService.sendButton(wa, master, "Qual sua fun\u00e7\u00e3o na empresa?", "", buttons);
            wa.setEtapa(WhatsAppEtapaEnum.FUNCAO);
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.FUNCAO)) {
            if (resposta == null || resposta.isEmpty() || !resposta.equals("S\u00f3cio") && !resposta.equals("Colaborador") && !resposta.equals("Outros")) {
                ArrayList<String> buttons = new ArrayList<String>();
                buttons.add("S\u00f3cio");
                buttons.add("Colaborador");
                buttons.add("Outros");
                this.sendService.sendButton(wa, master, "Informa\u00e7\u00e3o inv\u00e1lida Selecione", "", buttons);
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            WhatsAppFuncaoEnum fn = WhatsAppFuncaoEnum.getByResposta((String)resposta);
            if (fn == null) {
                ArrayList<String> buttons = new ArrayList<String>();
                buttons.add("S\u00f3cio");
                buttons.add("Colaborador");
                buttons.add("Outros");
                this.sendService.sendButton(wa, master, "Informa\u00e7\u00e3o inv\u00e1lida selecione", "", buttons);
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            w.setFuncao(fn);
            w.setEtapa(WhatsAppEtapaEnum.CONFIRMACAO_CADASTRO);
            wa.setEtapa(WhatsAppEtapaEnum.CONFIRMACAO_CADASTRO);
            ArrayList<String> buttons = new ArrayList<String>();
            buttons.add("Tudo Ok");
            buttons.add("Iniciar Novamente");
            this.sendService.sendButton(wa, master, "Ok, por favor confira seus dados:\nCNPJ(s) " + w.getCnpjEscolhido() + "\nNome: " + w.getNome() + "\nEmail: " + w.getEmail() + "\nFun\u00e7\u00e3o: " + w.getFuncao().name(), "Selecione a op\u00e7\u00e3o", buttons);
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.CONFIRMACAO_CADASTRO)) {
            if (resposta.isEmpty() || !resposta.equals("Tudo Ok") && !resposta.equals("Iniciar Novamente")) {
                ArrayList<String> buttons = new ArrayList<String>();
                buttons.add("Tudo Ok");
                buttons.add("Iniciar Novamente");
                this.sendService.sendButton(wa, master, "Informa\u00e7\u00e3o inv\u00e1lida Selecione", "", buttons);
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            if (resposta.equals("Tudo Ok")) {
                this.enviarAtendente(w, wa, master);
                Cliente cliente = this.clienteService.getAndCreateCliente(master, wa.getCnpj(), new ClienteContato[0]);
                cliente.setCadastroWhatsapp(Boolean.valueOf(true));
                this.clienteService.salvar(cliente, master);
            } else if (resposta.equals("Iniciar Novamente")) {
                w.setNome(null);
                w.setEmail(null);
                w.setCpfCnpj(null);
                w.setFuncao(null);
                w.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
                wa.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
                this.sendService.sendMessageText(wa, master, "Ok, vamos iniciar o cadastro novamente.\nInforme seu CNPJ");
            }
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.RESUMO)) {
            EstruturaUsuario eu = this.whatsAppAtendenteService.getAtendenteOnline(w, master);
            WhatsAppMensagem m = this.whatsAppTimeService.isAlmoco(wa.getWhatsapp().getWhatsappConta()) ? this.whatsAppTimeService.sendAlmoco(wa) : this.sendService.sendMessageText(wa, master, "Muito obrigado. Sua solicita\u00e7\u00e3o j\u00e1 foi direcionada. Pode ser que seu atendimento leve um tempinho, mas n\u00e3o se preocupe que logo um de nossos atendentes te chamar\u00e1 e dar\u00e1 continuidade ao atendimento por aqui mesmo");
            w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            w.setUltimoAtendente(eu);
            wa.setAtendente(eu);
            wa.setDataHoraTransferencia(LocalDateTime.now());
            wa.setFechado(false);
            wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            this.whatsAppControleService.gravarNova(m, m.getStatus());
        }
        w.setDataErro(null);
        w.setErros(Integer.valueOf(0));
        this.whatsAppService.save(w);
        this.whatsAppAtendimentoService.save(wa);
    }

    private void mostrarCnpj(WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario master) {
        String[] cnpjs;
        ArrayList<String> buttons = new ArrayList<String>();
        for (String cnpj : cnpjs = w.getCpfCnpj().split(",")) {
            buttons.add(cnpj);
        }
        this.sendService.sendButton(wa, master, "Ol\u00e1 " + w.getNome() + " tudo bem?", "Selecione o CNPJ", buttons);
        buttons.clear();
        buttons.add("Inserir Novo");
        this.sendService.sendButton(wa, master, "Clique abaixo para inserir um novo", "", buttons);
    }

    private void enviarAtendente(WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario master) {
        EstruturaUsuario eu = this.whatsAppAtendenteService.getAtendenteOnline(w, master);
        WhatsAppMensagem m = this.whatsAppTimeService.isAlmoco(wa.getWhatsapp().getWhatsappConta()) ? this.whatsAppTimeService.sendAlmoco(wa) : this.sendService.sendMessageText(wa, master, "Muito obrigado. Sua solicita\u00e7\u00e3o j\u00e1 foi direcionada para um atendente e logo ele ir\u00e1 interagir aqui mesmo.");
        w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        w.setUltimoAtendente(eu);
        wa.setAtendente(eu);
        wa.setDataHoraTransferencia(LocalDateTime.now());
        wa.setFechado(false);
        wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        this.whatsAppControleService.gravarNova(m, m.getStatus());
    }
}

