/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.security;

import br.com.system.app.features.login.LoginView;
import com.vaadin.flow.spring.security.VaadinWebSecurity;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableWebSecurity
@Configuration
public class SecurityConfiguration
extends VaadinWebSecurity {
    @Value(value="${spring.profiles.active:}")
    private String activeProfile;

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    protected void configure(HttpSecurity http) throws Exception {
        System.out.println(this.activeProfile);
        if (!"cloud".equalsIgnoreCase(this.activeProfile)) {
            http.requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.anyRequest()).requiresSecure());
        }
        http.csrf(c -> c.ignoringRequestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/api/v1/**")})).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/images/*.png"), new AntPathRequestMatcher("/line-awesome/**/*.svg"), new AntPathRequestMatcher("/reset-password/**"), new AntPathRequestMatcher("/api/v1/**"), new AntPathRequestMatcher("/force-gc")})).permitAll());
        super.configure(http);
        this.setLoginView(http, LoginView.class);
    }
}

