/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.security;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.usuario.dto.UsuarioTemaEnum;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.security.CustomUserDetails;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WebBrowser;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public interface SecurityContext
extends Serializable {
    private CustomUserDetails getContext() {
        if (SecurityContextHolder.getContext() == null || SecurityContextHolder.getContext().getAuthentication() == null || SecurityContextHolder.getContext().getAuthentication().getPrincipal() == null) {
            return null;
        }
        Object context = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (context instanceof CustomUserDetails) {
            CustomUserDetails cud = (CustomUserDetails)context;
            cud.getEu().getUsuario().setSenha(null);
            return cud;
        }
        return null;
    }

    default public String getUrl() {
        VaadinRequest vaadinRequest = VaadinService.getCurrentRequest();
        HttpServletRequest httpServletRequest = ((VaadinServletRequest)vaadinRequest).getHttpServletRequest();
        return httpServletRequest.getRequestURL().toString().replace("http:", "https:");
    }

    default public boolean autenticado() {
        return this.getEu() != null;
    }

    default public EstruturaTipoEnum getTipoEstrutura() {
        if (this.getContext() == null || this.getContext().getEu() == null) {
            return EstruturaTipoEnum.UNKNOW;
        }
        return EstruturaTipoEnum.getById((Long)this.getContext().getEu().getEstrutura().getEstruturaTipo().getId());
    }

    default public boolean isProvedor() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.PROVEDOR);
    }

    default public boolean isWhatsapp() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.WHATSAPP);
    }

    default public boolean isDarkTheme() {
        return this.getUsuario().getTema().equals((Object)UsuarioTemaEnum.DARK);
    }

    default public boolean isLigthTheme() {
        return this.getUsuario().getTema().equals((Object)UsuarioTemaEnum.LIGHT);
    }

    default public boolean isAlianca() {
        return this.getEstrutura().getId().equals(1452L);
    }

    default public boolean isGeradorLead() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.GERADOR_LEADS);
    }

    default public boolean isTelefonia() {
        return this.isVivo() || this.isTim() || this.isClaro() || this.isConsultoria() || this.isAlgar() || this.isOi() || this.isProvedor();
    }

    default public boolean isOi() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.OI);
    }

    default public boolean isConsultoria() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.CONSULTORIA);
    }

    default public boolean isVivo() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.VIVO);
    }

    default public boolean isFaturaFacil() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.FFW);
    }

    default public boolean isClaro() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.CLARO);
    }

    default public boolean isTicket() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.TICKET);
    }

    default public boolean isTim() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.TIM);
    }

    default public boolean isAlgar() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.ALGAR);
    }

    default public boolean isGeneric() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.GENERICO);
    }

    default public boolean isPolo() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.POLO);
    }

    default public boolean isNeoCrm() {
        return this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.NEOCRM);
    }

    default public EstruturaUsuario getEu() {
        if (this.getContext() == null) {
            return null;
        }
        return this.getContext().getEu();
    }

    default public Usuario getUsuario() {
        CustomUserDetails cud = this.getContext();
        if (cud == null || cud.getEu() == null || cud.getEu().getUsuario() == null) {
            return null;
        }
        return cud.getEu().getUsuario();
    }

    default public boolean isMaster() {
        CustomUserDetails cud = this.getContext();
        if (cud == null || cud.getEu() == null || cud.getEu().getUsuario() == null) {
            return false;
        }
        return cud.getEu().getUsuario().isMaster();
    }

    default public Estrutura getEstrutura() {
        CustomUserDetails cud = this.getContext();
        if (cud == null || cud.getEu() == null || cud.getEu().getEstrutura() == null) {
            return null;
        }
        return cud.getEu().getEstrutura();
    }

    default public boolean hasPermission(String permissao) {
        CustomUserDetails cud = this.getContext();
        if (cud == null) {
            return false;
        }
        if (cud.getEu().getUsuario().isMaster()) {
            return true;
        }
        Collection grantedAuthorityList = cud.getAuthorities();
        for (GrantedAuthority grantedAuthority : grantedAuthorityList) {
            if (grantedAuthority.getAuthority() == null || !grantedAuthority.getAuthority().equals("ROLE_" + permissao)) continue;
            return true;
        }
        return false;
    }

    default public boolean isMobileDevice() {
        WebBrowser webBrowser = VaadinSession.getCurrent().getBrowser();
        return webBrowser.isAndroid() || webBrowser.isIPhone() || webBrowser.isWindowsPhone();
    }

    default public void setWidthScreen(Integer width) {
        if (width == null || this.getContext() == null) {
            return;
        }
        this.getContext().setScreenWidth(width);
    }

    default public Integer getWidthScreen() {
        if (this.getContext() == null || this.getContext().getScreenWidth() == null) {
            return 0;
        }
        return this.getContext().getScreenWidth();
    }
}

