/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons.datetime;

import java.time.format.DateTimeFormatter;

public enum FormatDate {
    MYSQLDATETIME("yyyy-MM-dd HH:mm:ss"),
    LOCALDATETIME("yyyy-MM-dd'T'HH:mm:ss.SSSX"),
    DATE_BR("dd/MM/yyyy"),
    DATE_BR_YY("dd/MM/yy"),
    TIME_BR("HH:mm:ss"),
    TIME_BR_NO_SEC("HH:mm"),
    DATETIME_BR(FormatDate.DATE_BR.pattern + " " + FormatDate.TIME_BR.pattern),
    US_DATE("yyyy-MM-dd"),
    US_TIME("HH:mm:ss"),
    US_DATETIME(FormatDate.US_DATE.pattern + " " + FormatDate.US_TIME.pattern),
    DATABASE_DATETIME_MS(FormatDate.US_DATETIME.pattern + ".sss"),
    BR_MES_ANO("MM-yyyy"),
    BR_ANO_MES("yyyy-MM");

    private final String pattern;

    private FormatDate(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.name();
    }

    public DateTimeFormatter toDTF() {
        return DateTimeFormatter.ofPattern(this.getPattern());
    }
}

