/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.integreation.conexaoExterna;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.message.AbstractHttpMessage;

public class Headers {
    private Map<String, String> headers = new HashMap();
    private Map<String, String> headersDefault = new HashMap();
    private boolean resetHeaders = false;

    public Headers setMethodHeaders(AbstractHttpMessage method) {
        this.addDefaultHeaders();
        for (Map.Entry entry : this.headers.entrySet()) {
            method.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : this.headersDefault.entrySet()) {
            method.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public Headers addDefaultHeaders() {
        this.headers.put("Accept", "application/json,text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8");
        this.headers.put("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36");
        this.headers.put("Connection", "keep-alive");
        this.headers.put("Accept-Charset", "utf-8");
        this.headers.put("Accept-Language", "pt-BR,pt;q=0.9,en-US;q=0.8,en;q=0.7");
        this.headers.put("Accept-Encoding", "gzip");
        return this;
    }

    public Headers add(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Headers addDefault(String key, String value) {
        this.headersDefault.put(key, value);
        return this;
    }

    public Headers remove(String key) {
        this.headers.remove(key);
        return this;
    }

    public Headers setResetHeaders(boolean resetHeaders) {
        this.resetHeaders = resetHeaders;
        return this;
    }

    public Headers resetHeaders() {
        if (this.resetHeaders) {
            this.headers = new HashMap();
        }
        return this;
    }

    public String get(String header) {
        return (String)this.headers.get(header);
    }
}

