/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components;

import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ListField
extends CustomField<Set<String>> {
    private static final long serialVersionUID = 1L;
    private MultiComboBox<String> comboBox;
    private Set<String> dtp = null;
    private Integer minLength;
    private Integer maxLength;
    private final ListFieldTypeEnum type;
    private Button btnClear;

    public Set<String> getValue() {
        return this.comboBox.getValue();
    }

    public void clear() {
        this.comboBox.clear();
    }

    public ListField(ListFieldTypeEnum type) {
        this.type = type;
        this.create();
    }

    public ListField(ListFieldTypeEnum type, String label) {
        this.type = type;
        this.setLabel(label);
        this.create();
    }

    private void create() {
        this.dtp = new HashSet();
        this.comboBox = new MultiComboBox();
        this.comboBox.setAutoOpen(true);
        this.comboBox.setClearButtonVisible(false);
        this.comboBox.addCustomValueSetListener((ComponentEventListener & Serializable)event -> this.change(event.getDetail()));
        this.btnClear = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CLOSE_SMALL, (String)"Limpar Dados");
        this.btnClear.addClickListener((ComponentEventListener & Serializable)e -> {
            this.comboBox.clear();
            this.dtp.clear();
        });
        HorizontalLayout lay = new HorizontalLayout();
        lay.setMargin(false);
        lay.setSpacing(false);
        lay.setPadding(false);
        lay.setAlignItems(FlexComponent.Alignment.END);
        lay.add(new Component[]{this.comboBox, this.btnClear});
        this.add(new Component[]{lay});
    }

    private void change(String value) {
        Object erro = "";
        this.dtp.clear();
        if (this.comboBox.getValue() != null && !this.comboBox.getValue().isEmpty()) {
            for (String s : this.comboBox.getValue()) {
                this.dtp.add(s);
            }
        }
        if (this.type.equals((Object)ListFieldTypeEnum.GENERIC_STRING) && value.contains("\"")) {
            for (String item : value.split("\"")) {
                if (item.trim().isBlank()) continue;
                erro = (String)erro + this.add(item.replace("\"", "").trim());
            }
        } else {
            for (String item : value.split(" ")) {
                erro = (String)erro + this.add(item.trim());
            }
        }
        this.comboBox.setItems((Collection)this.dtp);
        this.comboBox.setValue(this.dtp);
        if (!((String)erro).isEmpty()) {
            UIUtils.showNotification((String)erro);
        }
    }

    private String add(String value) {
        if (value.isBlank()) {
            return "";
        }
        if (this.type.equals((Object)ListFieldTypeEnum.GENERIC_NUMBER) || this.type.equals((Object)ListFieldTypeEnum.CEP) || this.type.equals((Object)ListFieldTypeEnum.CPF_CNPJ)) {
            value = StringUtil.numbersOnly((String)value);
        }
        if (this.type.equals((Object)ListFieldTypeEnum.CEP) && value.length() != 8) {
            return "Cep " + value + " inv\u00e1lido";
        }
        if (this.type.equals((Object)ListFieldTypeEnum.CPF_CNPJ) && !ValidationUtil.isValidCnpjAndCpf((String)value)) {
            return value + " inv\u00e1lido";
        }
        if (this.type.equals((Object)ListFieldTypeEnum.TELEFONE) && !TelefoneUtil.isValid((String)value)) {
            return value + " inv\u00e1lido";
        }
        if (this.type.equals((Object)ListFieldTypeEnum.EMAIL) && !ValidationUtil.isValidEmail((String)value)) {
            return value + " inv\u00e1lido";
        }
        if (this.minLength != null && value.length() < this.minLength) {
            return value + " inv\u00e1lido, precisa de pelo menos " + this.minLength + " caracteres.";
        }
        if (this.minLength != null && this.maxLength > 0 && value.length() > this.maxLength) {
            return value + " inv\u00e1lido, m\u00e1ximo de " + this.minLength + " caracteres.";
        }
        if (this.type.equals((Object)ListFieldTypeEnum.GENERIC_STRING)) {
            // empty if block
        }
        if (this.dtp == null || value == null) {
            return "";
        }
        this.dtp.add(value);
        return "";
    }

    protected Set<String> generateModelValue() {
        return this.comboBox.getValue();
    }

    protected void setPresentationValue(Set<String> newPresentationValue) {
        if (newPresentationValue == null) {
            // empty if block
        }
    }

    public void setValue(Set<String> values) {
        this.change(StringUtils.join(values, (String)" "));
    }

    public void setValue(String values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        this.change(values.replaceAll(",", " "));
    }
}

