/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.analisefatura;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.analisefatura.model.AnaliseFatura;
import br.com.system.app.features.analisefatura.model.AnaliseFaturaItem;
import br.com.system.app.features.analisefatura.model.AnaliseFaturaProposta;
import br.com.system.app.features.analisefatura.model.ProdutoValorDTO;
import br.com.system.app.features.analisefatura.repository.AnaliseFaturaItemRepository;
import br.com.system.app.features.analisefatura.repository.AnaliseFaturaPropostaRepository;
import br.com.system.app.features.analisefatura.service.AnaliseFaturaService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoItemSolicitacao;
import br.com.system.app.features.pedido.model.PedidoItemTipoEnum;
import br.com.system.app.features.pedido.service.PedidoItemSolicitacaoService;
import br.com.system.app.features.produto.model.Produto;
import br.com.system.app.features.produto.model.ProdutoOrigem;
import br.com.system.app.features.produto.repository.ProdutoRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class AnaliseFaturaAtividadeView
extends Dialog {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private AnaliseFaturaItemRepository analiseFaturaItemRepository;
    @Autowired
    private AnaliseFaturaPropostaRepository analiseFaturaPropostaRepository;
    @Autowired
    private AnaliseFaturaService analiseFaturaService;
    @Autowired
    private PedidoItemSolicitacaoService pedidoItemSolicitacaoService;
    private AnaliseFatura af;
    private PedidoItemSolicitacao renovacao;
    private PedidoItemSolicitacao portado;
    private Set<AnaliseFaturaProposta> itemsProposta;
    private EstruturaUsuario eu;
    private VerticalContainer containerLinhas;
    private VerticalContainer containerOutros;
    private List<Produto> outros;
    private List<Produto> produtosViaveis;
    private List<ProdutoValorDTO> arrComboProdutos;
    private List<TextField> numeros;
    private Set<Produto> arrProdutosSelecionados;
    private List<PedidoItemSolicitacao> solicitacoes;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void create(AnaliseFatura af, EstruturaUsuario eu) {
        this.outros = this.produtoRepository.findByEstruturaTipoAndOrigemAndCompromissoMensalAndAtivoOrderByNome(eu.getEstrutura().getEstruturaTipo(), ProdutoOrigem.NEOCRM, Boolean.valueOf(false), Boolean.valueOf(true));
        this.produtosViaveis = this.produtoRepository.findByEstruturaTipoAndOrigemAndQuantosMegasGreaterThanEqualAndAtivoOrderByQuantosMegas(eu.getEstrutura().getEstruturaTipo(), ProdutoOrigem.NEOCRM, BigDecimal.ZERO, Boolean.valueOf(true));
        this.solicitacoes = this.pedidoItemSolicitacaoService.getAtivos(eu.getEstrutura().getEstruturaTipo());
        this.arrComboProdutos = new ArrayList();
        this.arrProdutosSelecionados = new HashSet();
        this.numeros = new ArrayList();
        this.removeAll();
        if (af == null) {
            throw new BusinessException("Fatura \u00e9 obrigatoria.");
        }
        this.renovacao = this.analiseFaturaService.getRenovacao(eu.getEstrutura());
        this.portado = this.analiseFaturaService.getPortado(eu.getEstrutura());
        this.af = af;
        this.eu = eu;
        this.setPropostaItens();
        this.containerLinhas = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        this.containerOutros = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        this.povoaLinhas();
        this.povoaOutros();
        Button btnAddLinha = UIUtils.createSmallButton((String)"Inserir", (VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar novo registro");
        btnAddLinha.addClickListener((ComponentEventListener & Serializable)e -> this.addItem(PedidoItemTipoEnum.LINHAS));
        Button btnExcluidosLinha = UIUtils.createSmallButton((String)"Voltar Excluidos", (VaadinIcon)VaadinIcon.RECYCLE, (String)"Voltar excluidos");
        btnExcluidosLinha.setVisible(false);
        btnExcluidosLinha.addClickListener((ComponentEventListener & Serializable)e -> this.voltarExcluidos(PedidoItemTipoEnum.LINHAS));
        NumberField valor = new NumberField("Valor");
        ComboBox cbProdutoDe = new ComboBox("DE");
        cbProdutoDe.setItemLabelGenerator(Produto::getNome);
        cbProdutoDe.setItems((Collection)this.arrProdutosSelecionados);
        ComboBox cbProdutoPara = new ComboBox("Para");
        cbProdutoPara.setItemLabelGenerator(Produto::getNome);
        cbProdutoPara.setItems((Collection)this.produtosViaveis);
        cbProdutoPara.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.getValue() != null && ((Produto)e.getValue()).getValor() != null) {
                valor.setValue((Number)((Produto)e.getValue()).getValor().doubleValue());
            } else {
                valor.setValue(null);
            }
        });
        Button btnAll = UIUtils.createSmallButton((String)"Alterar", (String)"Atribuir a todos");
        btnAll.addClickListener((ComponentEventListener & Serializable)e -> {
            try {
                if (cbProdutoDe.getValue() == null || cbProdutoPara.getValue() == null && valor.getValue() == null) {
                    UIUtils.showNotification((String)"Selecione um produto DE e um produto PARA e/ou Valor");
                    return;
                }
                for (ProdutoValorDTO dto : this.arrComboProdutos) {
                    if (dto.getComboProduto().getValue() == null || !((Produto)dto.getComboProduto().getValue()).equals(cbProdutoDe.getValue())) continue;
                    if (cbProdutoPara.getValue() != null) {
                        dto.getComboProduto().setValue((Object)((Produto)cbProdutoPara.getValue()));
                    }
                    if (valor.getValue() == null) continue;
                    dto.getFieldValor().setValue((Number)((Double)valor.getValue()));
                }
                if (cbProdutoPara.getValue() != null) {
                    this.arrProdutosSelecionados.remove(cbProdutoDe.getValue());
                    this.arrProdutosSelecionados.add((Produto)cbProdutoPara.getValue());
                    cbProdutoDe.setItems((Collection)this.arrProdutosSelecionados);
                }
                cbProdutoPara.setValue(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Button btnAddOthers = UIUtils.createSmallButton((String)"Inserir", (VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar novo registro");
        btnAddOthers.addClickListener((ComponentEventListener & Serializable)e -> this.addItem(PedidoItemTipoEnum.OUTROS, null, null, null, null, Integer.valueOf(1)));
        Button btnExcluidosOutros = UIUtils.createSmallButton((String)"Voltar Excluidos", (VaadinIcon)VaadinIcon.RECYCLE, (String)"Voltar excluidos");
        btnExcluidosOutros.setVisible(false);
        btnExcluidosOutros.addClickListener((ComponentEventListener & Serializable)e -> this.voltarExcluidos(PedidoItemTipoEnum.OUTROS));
        Button btnClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"Fechar");
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        Button btnSave = UIUtils.createSmallButton((String)"Salvar", (VaadinIcon)VaadinIcon.INBOX, (String)"Salvar");
        btnSave.addClickListener((ComponentEventListener & Serializable)e -> {
            String erros = this.getErros();
            if (!erros.isEmpty()) {
                UIUtils.showNotification((String)erros);
                return;
            }
            this.salvar();
            this.close();
        });
        Button btnBack = UIUtils.createSmallButton((String)"Reiniciar Proposta");
        btnBack.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Reiniciar proposta", "A proposta ir\u00e1 voltar ao estado original baseado na fatura, confirma?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                this.analiseFaturaPropostaRepository.deleteByAnaliseFatura(af);
                this.create(af, eu);
                this.createAtividade();
                cd.close();
            });
        });
        Button btnAtividade = UIUtils.createSmallButton((String)(af.getAtividadeId() != null && af.getAtividadeId() > 0L ? "Atualizar Atividade" : "Criar Atividade"), (VaadinIcon)VaadinIcon.TASKS, (String)"Cria/Atualiza atividade");
        btnAtividade.addClickListener((ComponentEventListener & Serializable)e -> {
            String erros = this.getErros();
            if (!erros.isEmpty()) {
                UIUtils.showNotification((String)erros);
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Atividade", (String)(af.getAtividadeId() != null && af.getAtividadeId() > 0L ? "Atividade #" + af.getAtividadeId() + " os itens ser\u00e3o sobrepostos, confirma?" : "Confirma cria\u00e7\u00e3o de atividade com base nessa fatura?"));
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                this.createAtividade();
                this.salvar();
                cd.close();
                this.close();
            });
        });
        FlexBoxLayout btnContainer = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new com.vaadin.flow.component.Component[0]);
        btnContainer.setWidthFull();
        UIUtils.setShadow((Shadow)Shadow.XS, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{btnContainer});
        btnContainer.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        btnContainer.add(new com.vaadin.flow.component.Component[]{btnClose, btnBack, btnAtividade});
        VerticalContainer mainContainer = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        mainContainer.add(new com.vaadin.flow.component.Component[]{af.getAtividadeId() == null || af.getAtividadeId() <= 0L ? UIUtils.createHeader((String)("Fatura #" + af.getId() + " Atividade n\u00e3o criada")) : UIUtils.createHeader((String)("Fatura #" + af.getId() + " Atividade #" + af.getAtividadeId()))});
        mainContainer.add(new com.vaadin.flow.component.Component[]{btnContainer});
        TextField txtSearch = new TextField("Localizar Linha");
        Button btnSearch = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.SEARCH, (String)"Localizar linha");
        btnSearch.addClickListener((ComponentEventListener & Serializable)e -> {
            for (TextField n : this.numeros) {
                if (!StringUtil.numbersOnly((String)n.getValue()).contains(StringUtil.numbersOnly((String)txtSearch.getValue()))) continue;
                n.focus();
                n.setAutoselect(true);
                break;
            }
        });
        HorizontalContainer h = new HorizontalContainer(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{btnAddLinha, btnExcluidosLinha, txtSearch, btnSearch}), new VerticalContainer(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Altera\u00e7\u00e3o em lote"), new HorizontalContainer(new com.vaadin.flow.component.Component[]{cbProdutoDe, cbProdutoPara, valor, btnAll})})});
        h.setWidthFull();
        h.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        mainContainer.add(new com.vaadin.flow.component.Component[]{h});
        mainContainer.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Linhas")});
        mainContainer.add(new com.vaadin.flow.component.Component[]{this.containerLinhas});
        mainContainer.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Aparelhos e Outros")});
        mainContainer.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{btnAddOthers, btnExcluidosOutros})});
        mainContainer.add(new com.vaadin.flow.component.Component[]{this.containerOutros});
        this.add(new com.vaadin.flow.component.Component[]{mainContainer});
    }

    private void povoaLinhas() {
        this.containerLinhas.removeAll();
        for (AnaliseFaturaProposta p : this.itemsProposta) {
            if (!p.getTipo().equals((Object)PedidoItemTipoEnum.LINHAS) || p.getExcluido().booleanValue()) continue;
            this.setItem(p, false, false);
        }
    }

    private void povoaOutros() {
        this.containerOutros.removeAll();
        for (AnaliseFaturaProposta p : this.itemsProposta) {
            if (!p.getTipo().equals((Object)PedidoItemTipoEnum.OUTROS) || p.getExcluido().booleanValue()) continue;
            this.setItem(p, true, false);
        }
    }

    private void addItem(PedidoItemTipoEnum tipo) {
        Dialog d = new Dialog();
        NumberField qt = new NumberField("Quantos Itens?");
        qt.setStep(1.0);
        qt.setMin(1.0);
        qt.setValue((Number)1.0);
        NumberField vl = new NumberField("Valor");
        ComboBox cb = new ComboBox("Produto");
        if (tipo.equals((Object)PedidoItemTipoEnum.LINHAS)) {
            cb.setItems((Collection)this.produtosViaveis);
        } else {
            cb.setItems((Collection)this.outros);
        }
        cb.setItemLabelGenerator(Produto::getNome);
        cb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.getValue() != null && ((Produto)e.getValue()).getValor() != null) {
                vl.setValue((Number)((Produto)e.getValue()).getValor().doubleValue());
            } else {
                vl.setValue(null);
            }
        });
        ComboBox cbs = new ComboBox("Solicita\u00e7\u00e3o", (Collection)this.solicitacoes);
        cbs.setItemLabelGenerator(PedidoItemSolicitacao::getNome);
        TextField ddd = new TextField("DDD");
        Button btnConfirmar = UIUtils.createSmallButton((String)"Confirmar", (String)"Confirmar inclus\u00e3o de itens");
        btnConfirmar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (qt.getValue() == null || ((Double)qt.getValue()).intValue() <= 0 || cb.getValue() == null || cbs.getValue() == null) {
                UIUtils.showNotification((String)"Obrigat\u00f3rio quantidade, produto e solicita\u00e7\u00e3o");
                return;
            }
            if (tipo.equals((Object)PedidoItemTipoEnum.LINHAS)) {
                int i = 0;
                while ((double)i < (Double)qt.getValue()) {
                    this.addItem(tipo, ddd.getValue(), (PedidoItemSolicitacao)cbs.getValue(), (Produto)cb.getValue(), (Double)vl.getValue(), Integer.valueOf(1));
                    ++i;
                }
            } else {
                this.addItem(tipo, ddd.getValue(), (PedidoItemSolicitacao)cbs.getValue(), (Produto)cb.getValue(), (Double)vl.getValue(), Integer.valueOf(((Double)qt.getValue()).intValue()));
            }
            d.close();
        });
        Button btnCancelar = UIUtils.createSmallButton((String)"Cancelar", (String)"Cancelar inclus\u00e3o de itens");
        btnCancelar.addClickListener((ComponentEventListener & Serializable)e -> d.close());
        VerticalContainer v = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        v.add(new com.vaadin.flow.component.Component[]{qt});
        if (tipo.equals((Object)PedidoItemTipoEnum.LINHAS)) {
            v.add(new com.vaadin.flow.component.Component[]{ddd});
        }
        v.add(new com.vaadin.flow.component.Component[]{cb, cbs, vl, new FooterContainer(new com.vaadin.flow.component.Component[]{btnCancelar, btnConfirmar})});
        d.add(new com.vaadin.flow.component.Component[]{v});
        d.open();
    }

    private void addItem(PedidoItemTipoEnum tipo, String ddd, PedidoItemSolicitacao solicitacao, Produto produto, Double valor, Integer quantidade) {
        AnaliseFaturaProposta p = new AnaliseFaturaProposta();
        p.setAnaliseFatura(this.af);
        p.setNumero(ddd == null ? "" : ddd);
        p.setTipo(tipo);
        p.setExcluido(Boolean.valueOf(false));
        p.setPosicao(Integer.valueOf(0));
        p.setValor(valor == null ? null : BigDecimal.valueOf(valor));
        p.setProduto(produto);
        p.setPedidoItemSolicitacao(solicitacao);
        p.setQuantidade(quantidade);
        p.setConsumoDados(BigDecimal.ZERO);
        this.setItem(p, tipo.equals((Object)PedidoItemTipoEnum.OUTROS), true);
        this.itemsProposta.add(p);
    }

    private void setPropostaItens() {
        this.itemsProposta = this.analiseFaturaPropostaRepository.findByAnaliseFatura(this.af);
        if (this.itemsProposta != null && this.itemsProposta.size() > 0) {
            return;
        }
        for (AnaliseFaturaItem i : this.analiseFaturaItemRepository.findByAnaliseFatura(this.af)) {
            AnaliseFaturaProposta p = new AnaliseFaturaProposta();
            p.setAnaliseFatura(this.af);
            p.setConsumoDados(i.getDadosLocal());
            p.setNumero(i.getNumero());
            p.setPosicao(Integer.valueOf(0));
            p.setQuantidade(Integer.valueOf(1));
            p.setTipo(PedidoItemTipoEnum.LINHAS);
            p.setNomePlano(i.getPlanoNome());
            p.setValorTotal(i.getValorTotal());
            p.setExcluido(Boolean.valueOf(false));
            if (!this.eu.getEstrutura().getEstruturaTipo().getOperadora().equals((Object)this.af.getOperadora())) {
                p.setPedidoItemSolicitacao(this.portado);
            } else {
                p.setPedidoItemSolicitacao(this.renovacao);
            }
            this.itemsProposta.add(p);
        }
    }

    private void setItem(AnaliseFaturaProposta item, boolean other, boolean setFocus) {
        List produtos;
        ComboBox cbProduto = new ComboBox("Produtos");
        NumberField valor = new NumberField("Valor");
        valor.setWidth("100px");
        valor.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> item.setValor(BigDecimal.valueOf((Double)valor.getValue())));
        ComboBox produto = new ComboBox("Produto");
        UIUtils.setFontSize((FontSize)FontSize.XXS, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{produto});
        produto.setItemLabelGenerator(Produto::getNome);
        produto.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            item.setProduto((Produto)e.getValue());
            item.setValor(((Produto)produto.getValue()).getValor());
            valor.setValue((Number)item.getValor().doubleValue());
        });
        produto.setWidth("250px");
        produto.getStyle().set("word-wrap", "break-word");
        if (item.getTipo().equals((Object)PedidoItemTipoEnum.LINHAS)) {
            produtos = this.produtoRepository.findByEstruturaTipoAndOrigemAndQuantosMegasGreaterThanEqualAndAtivoOrderByQuantosMegas(this.eu.getEstrutura().getEstruturaTipo(), ProdutoOrigem.NEOCRM, BigDecimal.ZERO, Boolean.valueOf(true));
            produto.setItems((Collection)produtos);
            if (!produtos.isEmpty()) {
                item.setValor(item.getValor() == null ? ((Produto)produtos.get(0)).getValor() : item.getValor());
                int posicao = 0;
                for (Produto p : produtos) {
                    if (p.getApareceProposta() == null || !p.getApareceProposta().booleanValue()) continue;
                    if (item.getProduto() == null) {
                        if (p.getQuantosMegas().compareTo(item.getConsumoDados()) >= 0 && p.getQuantosMegas().compareTo(BigDecimal.ZERO) > 0) {
                            item.setProduto(item.getProduto() == null ? p : item.getProduto());
                            item.setValor(item.getValor() == null ? p.getValor() : item.getValor());
                            item.setPosicao(Integer.valueOf(posicao));
                            produto.setValue((Object)p);
                            this.arrProdutosSelecionados.add(p);
                            break;
                        }
                    } else if (p.getId().equals(item.getProduto().getId())) {
                        produto.setValue((Object)p);
                        this.arrProdutosSelecionados.add(p);
                        break;
                    }
                    ++posicao;
                }
            }
        } else {
            produtos = this.outros;
            cbProduto.setItems((Collection)produtos);
            cbProduto.setItemLabelGenerator(Produto::getNomeAndCategoriaAndOrigem);
            cbProduto.setWidth("300px");
            cbProduto.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                item.setProduto((Produto)e.getValue());
                item.setValor(((Produto)cbProduto.getValue()).getValor());
                valor.setValue((Number)item.getValor().doubleValue());
            });
            if (item.getProduto() != null) {
                cbProduto.setValue((Object)item.getProduto());
            }
        }
        valor.setValue((Number)(item.getValor() != null ? item.getValor().doubleValue() : Double.valueOf("0").doubleValue()));
        ComboBox cbSolicitacao = new ComboBox("Solicita\u00e7\u00e3o", (Collection)this.solicitacoes);
        cbSolicitacao.setItemLabelGenerator(PedidoItemSolicitacao::getNome);
        cbSolicitacao.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> item.setPedidoItemSolicitacao((PedidoItemSolicitacao)e.getValue()));
        cbSolicitacao.setWidth("130px");
        if (item.getPedidoItemSolicitacao() != null) {
            cbSolicitacao.setValue((Object)item.getPedidoItemSolicitacao());
        }
        HorizontalContainer row = new HorizontalContainer(new com.vaadin.flow.component.Component[0]);
        row.setAlignItems(FlexComponent.Alignment.CENTER);
        UIUtils.setShadow((Shadow)Shadow.XS, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{row});
        Button btnDel = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir registro");
        btnDel.addClickListener((ComponentEventListener & Serializable)e -> {
            if (other) {
                this.containerOutros.remove(new com.vaadin.flow.component.Component[]{row});
            } else {
                this.containerLinhas.remove(new com.vaadin.flow.component.Component[]{row});
            }
            item.setExcluido(Boolean.valueOf(true));
        });
        TextField numero = new TextField("N\u00famero");
        numero.setReadOnly(item.getNumero().length() > 10);
        numero.setValue(item.getNumero() == null ? "" : item.getNumero());
        numero.setWidth("135px");
        numero.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> item.setNumero((String)e.getValue()));
        this.numeros.add(numero);
        TextField consumo = new TextField("Consumo");
        consumo.setWidth("100px");
        consumo.setReadOnly(true);
        if (item.getConsumoDados() != null) {
            if (item.getConsumoDados().intValue() < 1000) {
                consumo.setValue(item.getConsumoDados().toString() + " MB");
            } else {
                consumo.setValue(UIUtils.formatDecimal((Double)item.getConsumoDados().divide(BigDecimal.valueOf(1000L)).doubleValue(), (int)2) + " GB");
            }
        }
        Span plano = UIUtils.createBreakWrapSpan((String)(item.getNomePlano() == null ? "" : item.getNomePlano()));
        plano.setWidth("200px");
        Span valorTotal = UIUtils.createBreakWrapSpan((String)UIUtils.formatCurrency((BigDecimal)item.getValorTotal()));
        valorTotal.setWidth("80px");
        NumberField quantidade = new NumberField("Quantidade");
        quantidade.setWidth("100px");
        quantidade.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> item.setQuantidade(Integer.valueOf(((Double)e.getValue()).intValue())));
        if (!item.getNumero().isBlank()) {
            quantidade.setReadOnly(true);
        }
        quantidade.setValue((Number)(item.getQuantidade() == null ? Double.valueOf("1").doubleValue() : item.getQuantidade().doubleValue()));
        Button btnUp = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_UP, (String)"Pr\u00f3ximo produto");
        btnUp.addClickListener((ComponentEventListener & Serializable)e -> {
            if (item.getPosicao() < produtos.size() - 1) {
                item.setPosicao(Integer.valueOf(item.getPosicao() + 1));
                produto.setValue((Object)((Produto)produtos.get(item.getPosicao())));
                valor.setValue((Number)((Produto)produtos.get(item.getPosicao())).getValor().doubleValue());
                item.setProduto((Produto)produtos.get(item.getPosicao()));
            }
        });
        Button btnDown = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_DOWN, (String)"Produto anterior");
        btnDown.addClickListener((ComponentEventListener & Serializable)e -> {
            if (item.getPosicao() > 0) {
                item.setPosicao(Integer.valueOf(item.getPosicao() - 1));
                produto.setValue((Object)((Produto)produtos.get(item.getPosicao())));
                valor.setValue((Number)((Produto)produtos.get(item.getPosicao())).getValor().doubleValue());
                item.setProduto((Produto)produtos.get(item.getPosicao()));
            }
        });
        if (other) {
            row.add(new com.vaadin.flow.component.Component[]{btnDel, cbSolicitacao, cbProduto, quantidade, valor});
            this.containerOutros.add(new com.vaadin.flow.component.Component[]{row});
            if (setFocus) {
                cbSolicitacao.focus();
            }
        } else {
            ProdutoValorDTO dto = new ProdutoValorDTO();
            dto.setComboProduto(produto);
            dto.setFieldValor(valor);
            this.arrComboProdutos.add(dto);
            row.add(new com.vaadin.flow.component.Component[]{btnDel, cbSolicitacao, numero, plano, valorTotal, consumo, btnUp, btnDown, produto, quantidade, valor});
            this.containerLinhas.add(new com.vaadin.flow.component.Component[]{row});
            if (setFocus) {
                numero.focus();
            }
        }
    }

    private Pedido createAtividade() {
        Pedido pedido = this.analiseFaturaService.createTask(this.eu, this.af, this.itemsProposta);
        this.af.setAtividadeId(pedido.getId());
        return pedido;
    }

    private void salvar() {
        this.af.setItensProposta(this.itemsProposta);
        this.analiseFaturaService.save(this.af);
    }

    private String getErros() {
        String erros = "";
        for (AnaliseFaturaProposta item : this.itemsProposta) {
            if (item.getExcluido().booleanValue()) continue;
            if (item.getProduto() == null || item.getPedidoItemSolicitacao() == null) {
                return "H\u00e1 itens sem produto ou solicita\u00e7\u00e3o definido(s)";
            }
            if (!item.getNumero().isEmpty() && !TelefoneUtil.isValid((String)item.getNumero())) {
                return "H\u00e1 itens com n\u00famero inv\u00e1lido";
            }
            if (item.getNumero().isEmpty() || item.getQuantidade() <= 1) continue;
            return "H\u00e1 itens com n\u00famero e quantidade >1";
        }
        return erros;
    }

    private void voltarExcluidos(PedidoItemTipoEnum tipo) {
        for (AnaliseFaturaProposta p : this.itemsProposta) {
            if (!p.getExcluido().booleanValue() || !p.getTipo().equals((Object)tipo)) continue;
            p.setExcluido(Boolean.valueOf(false));
        }
        if (tipo.equals((Object)PedidoItemTipoEnum.LINHAS)) {
            this.povoaLinhas();
        } else {
            this.povoaOutros();
        }
    }
}

