/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.analisefatura.service.oribt;

import br.com.system.app.features.analisefatura.model.AnaliseFatura;
import br.com.system.app.features.analisefatura.model.StatusAnalise;
import br.com.system.app.features.analisefatura.service.oribt.OrbitToSystem;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.SleepUtil;
import br.com.system.commons.StringUtil;
import br.com.system.integreation.conexaoExterna.ExternalConnection;
import br.com.system.integreation.conexaoExterna.exception.ExternalConnectionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONObject;

public class OrbitAnalise
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ExternalConnection conexao = new ExternalConnection();

    public OrbitAnalise() throws Exception {
        this.logar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnaliseFatura analisar(AnaliseFatura af) {
        InputStream is = null;
        InputStream isOrbitDetalhamento = null;
        InputStream isOrbit = null;
        InputStream isOrbitPerfil = null;
        InputStream isModelo = null;
        XSSFWorkbook appXls = null;
        try {
            is = StorageUtil.getObject((String)af.getHashArquivoOriginal());
            Integer arquivoId = this.upload(is, af.getHashArquivoOriginal());
            Integer idTarefa = this.novaAnalise(arquivoId, af.getHashArquivoOriginal());
            JSONObject dadosFatura = this.aguardarProcesso(idTarefa);
            isOrbitPerfil = this.downloadPerfil(dadosFatura);
            HashMap planos = this.getPlano(isOrbitPerfil);
            String downloadCode = StringUtil.numbersOnly((String)this.getDownloadCode());
            isOrbit = this.download(dadosFatura, downloadCode);
            OrbitToSystem otn = new OrbitToSystem();
            isModelo = StorageUtil.getObjectModelo((String)"Exportacao-fatura-v2.xlsx");
            appXls = new XSSFWorkbook(isModelo);
            otn.convert(af, isOrbit, planos, (Workbook)appXls);
            isOrbitDetalhamento = this.downloadDetalhamento(dadosFatura);
            otn.setDetalhamento(isOrbitDetalhamento, (Workbook)appXls);
            this.excluir(dadosFatura);
            af.setStatusAnalise(StatusAnalise.FINALIZADA);
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)appXls);
            StorageUtil.uploadObjectInputStream((String)af.getHashArquivoAnalisado(), (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            otn = null;
            arquivoId = null;
            idTarefa = null;
            dadosFatura = null;
            isOutput.close();
        }
        catch (Exception e) {
            af.setStatusAnalise(StatusAnalise.ERRO);
            af.setObservacao("Erro ao processar Fatura, verifique o formato e se h\u00e1 detalhamento");
        }
        finally {
            try {
                isModelo.close();
                appXls.close();
                isOrbit.close();
                isOrbitPerfil.close();
                is.close();
                isOrbitDetalhamento.close();
                isModelo = null;
                appXls = null;
                isOrbit = null;
                isOrbitPerfil = null;
                is = null;
                isOrbitDetalhamento = null;
            }
            catch (Exception exception) {}
        }
        return af;
    }

    private InputStream downloadPerfil(JSONObject dadosFatura) throws Exception {
        this.conexao.executeGet("https://fatura.orbitsistemas.com.br/ServletRelatorioRevendaPerfilDeUtilizacao?id_analise=" + dadosFatura.getString("idAnalise") + "&id_analise_geral=" + dadosFatura.getString("idAnaliseGeral") + "&id_conta=" + dadosFatura.getString("idConta"));
        String downloadCode = StringUtil.numbersOnly((String)this.getDownloadCode());
        this.downloadIsPreparePerfil(dadosFatura, downloadCode);
        String url = "https://fatura.orbitsistemas.com.br/ServletRelatorioRevendaPerfilDeUtilizacao?p=t&_codigoDownload=download" + downloadCode;
        return this.conexao.executeGet(url).getEntity().getContent();
    }

    private InputStream downloadDetalhamento(JSONObject dadosFatura) throws Exception {
        this.conexao.executeGet("https://fatura.orbitsistemas.com.br/ServletRelatorioRevendaDetalhamentoCompleto?id_analise=" + dadosFatura.getString("idAnalise") + "&id_analise_geral=" + dadosFatura.getString("idAnaliseGeral") + "&id_conta=" + dadosFatura.getString("idConta"));
        String downloadCode = StringUtil.numbersOnly((String)this.getDownloadCode());
        this.downloadIsPrepare(dadosFatura, downloadCode);
        String url = "https://fatura.orbitsistemas.com.br/ServletRelatorioRevendaDetalhamentoCompleto?p=t&_codigoDownload=download" + downloadCode;
        return this.conexao.executeGet(url).getEntity().getContent();
    }

    private InputStream download(JSONObject dadosFatura, String downloadCode) throws ExternalConnectionException, IOException {
        String url = "https://fatura.orbitsistemas.com.br/ServletDownloadAnalise?acao=downloadAnalise&id_analise=" + dadosFatura.getString("idAnalise") + "&id_analise_geral=" + dadosFatura.getString("idAnaliseGeral") + "&id_conta=" + dadosFatura.getString("idConta") + "&relatorio=idDiagnosticoContratacao&_codigoDownload=download" + downloadCode;
        return this.conexao.executeGet(url).getEntity().getContent();
    }

    private String getDownloadCode() throws ExternalConnectionException, IOException {
        String xml = this.conexao.addParameter("acao", "getTime").executePost("https://fatura.orbitsistemas.com.br/ServletControleDownload").getReturnedHtml();
        String downloadCode = xml.substring(xml.indexOf("mensagem"));
        downloadCode = downloadCode.substring(0, downloadCode.indexOf(">"));
        return downloadCode;
    }

    private Integer upload(InputStream is, String hashFilename) {
        try {
            File file = InputStreamUtil.toFile((InputStream)is, (String)hashFilename);
            JSONObject jsonUpload = this.conexao.setMultipartParameters(file).executePost("https://fatura.orbitsistemas.com.br/ServletBillOrganizador?acao=uploadFatura").toJsonObject();
            if (!jsonUpload.getBoolean("sucesso")) {
                throw new BusinessException("Erro ao fazer upload do arquivo: " + jsonUpload.getString("mensagem"));
            }
            file.delete();
            file = null;
            Integer n = jsonUpload.getJSONObject("bean").getJSONObject("ArquivoFaturaBean").getInt("id_arquivo_fatura");
            return n;
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao fazer upload do arquivo: " + e.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public void logout() {
        try {
            this.conexao.executeGet("https://fatura.orbitsistemas.com.br/ServletLogin?acao=logOut");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JSONObject aguardarProcesso(Integer idTarefa) throws ExternalConnectionException, IOException {
        Integer retry = 0;
        while (retry < 360) {
            Integer n = retry;
            retry = retry + 1;
            SleepUtil.inSeconds((Integer)5);
            JSONObject json = this.conexao.addParameter("acao", "acompanharProgressoTarefa").addParameter("idExecucaoTarefa", idTarefa.toString()).addParameter("esperarPorMudanca", "false").executeGet("https://fatura.orbitsistemas.com.br/ServletTarefa").toJsonObject();
            if (!json.getBoolean("sucesso")) continue;
            if (json.getJSONObject("bean").getJSONObject("ExecucaoTarefa").getBoolean("finalizada")) {
                return json.getJSONObject("bean").getJSONObject("ExecucaoTarefa").getJSONObject("parametrosRetorno");
            }
            n = null;
        }
        throw new BusinessException("Erro ao pegar status do processo");
    }

    private Integer novaAnalise(Integer arquivoId, String filename) throws ExternalConnectionException, IOException {
        JSONObject json = this.conexao.addParameter("acao", "novoCadastrarAnaliseBill").addParameter("id_arquivo", arquivoId.toString()).addParameter("nome_arquivo_" + arquivoId, filename).executePost("https://fatura.orbitsistemas.com.br/ServletAnalisadorFatura").toJsonObject();
        if (!json.getBoolean("sucesso")) {
            throw new BusinessException(json.getString("mensagem").replaceAll("orbit", ""));
        }
        return json.getJSONObject("bean").getJSONObject("ExecucaoTarefa").getInt("idExecucaoTarefa");
    }

    private ExternalConnection logar() throws ExternalConnectionException, IOException {
        this.conexao = new ExternalConnection();
        this.conexao.setTimeOut(Integer.valueOf(1800000));
        for (int retry = 0; retry <= 60; ++retry) {
            JSONObject jsonLogin = this.conexao.addParameter("acao", "autenticar").addParameter("st_login", "rbsolucoescorp.telecom@gmail.com").addParameter("st_senha", "df97f0d").executePost("https://fatura.orbitsistemas.com.br/ServletLogin").toJsonObject();
            if (!jsonLogin.getBoolean("sucesso")) {
                SleepUtil.inSeconds((Integer)60);
                continue;
            }
            return this.conexao;
        }
        throw new BusinessException("Problemas ao logar no ORBIT");
    }

    private void excluir(JSONObject dadosFatura) {
        try {
            this.conexao.addParameter("acao", "excluirAnaliseLogicamente").addParameter("id_analise", dadosFatura.getString("idAnalise")).addParameter("id_analise_geral", dadosFatura.getString("idAnaliseGeral")).executePost("https://fatura.orbitsistemas.com.br/ServletAnaliseGeral");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean downloadIsPrepare(JSONObject dadosFatura, String codigoDownload) throws Exception {
        this.conexao.addParameter("acao", "resetaStatusDownload").addParameter("codigoDownload", "download" + codigoDownload).executePost("https://fatura.orbitsistemas.com.br/ServletControleDownload");
        this.conexao.addParameter("acao", "verificaDownload").addParameter("codigoDownload", "download" + codigoDownload).executePost("https://fatura.orbitsistemas.com.br/ServletControleDownload");
        String xml = this.conexao.addParameter("acao", "setParametros").addParameter("codigoDownload", "download" + codigoDownload).addParameter("id_analise", dadosFatura.getString("idAnalise")).addParameter("id_analise_geral", dadosFatura.getString("idAnaliseGeral")).addParameter("id_conta", dadosFatura.getString("idConta")).addParameter("idsFiltro", "1").addParameter("tipoFiltro_1", "DISTINCT WITH ILIKE").addParameter("text_1", "").addParameter("idsFiltro", "2").addParameter("tipoFiltro_2", "DISTINCTSELECTION").addParameter("idsFiltro", "3").addParameter("tipoFiltro_3", "DISTINCTSELECTION").addParameter("idsFiltro", "4").addParameter("tipoFiltro_4", "DATE").addParameter("data_de_4", "").addParameter("data_ate_4", "").addParameter("idsFiltro", "5").addParameter("tipoFiltro_5", "TIME").addParameter("data_de_5", "").addParameter("data_ate_5", "").addParameter("idsFiltro", "6").addParameter("tipoFiltro_6", "DISTINCTSELECTION").addParameter("idsFiltro", "7").addParameter("tipoFiltro_7", "DISTINCTSELECTION").addParameter("idsFiltro", "8").addParameter("tipoFiltro_8", "DISTINCTSELECTION").addParameter("idsFiltro", "9").addParameter("tipoFiltro_9", "DISTINCTSELECTION").addParameter("idsFiltro", "10").addParameter("tipoFiltro_10", "DISTINCTSELECTION").addParameter("idsFiltro", "11").addParameter("tipoFiltro_11", "DISTINCTSELECTION").addParameter("idsFiltro", "12").addParameter("tipoFiltro_12", "DISTINCTSELECTION").addParameter("idsFiltro", "13").addParameter("tipoFiltro_13", "DISTINCTSELECTION").addParameter("idsFiltro", "14").addParameter("tipoFiltro_14", "DISTINCTSELECTION").addParameter("idsFiltro", "15").addParameter("tipoFiltro_15", "DISTINCTSELECTION").addParameter("idsFiltro", "16").addParameter("tipoFiltro_16", "DISTINCT WITH ILIKE").addParameter("text_16", "").addParameter("idsFiltro", "17").addParameter("tipoFiltro_17", "DISTINCT WITH ILIKE").addParameter("text_17", "").addParameter("idsFiltro", "18").addParameter("tipoFiltro_18", "BETWEEN").addParameter("valor_de_18", "").addParameter("valor_ate_18", "").addParameter("idsFiltro", "19").addParameter("tipoFiltro_19", "DISTINCTSELECTION").addParameter("idsFiltro", "20").addParameter("tipoFiltro_20", "BETWEEN").addParameter("valor_de_20", "").addParameter("valor_ate_20", "").addParameter("idsFiltro", "21").addParameter("tipoFiltro_21", "BETWEEN").addParameter("valor_de_21", "").addParameter("valor_ate_21", "").addParameter("idsOrdenacao", "1").addParameter("ordemOrdenacao1", "").addParameter("tipoOrdenacao1", "").addParameter("idsOrdenacao", "2").addParameter("ordemOrdenacao2", "").addParameter("tipoOrdenacao2", "").addParameter("idsOrdenacao", "3").addParameter("ordemOrdenacao3", "").addParameter("tipoOrdenacao3", "").addParameter("idsOrdenacao", "4").addParameter("ordemOrdenacao4", "").addParameter("tipoOrdenacao4", "").addParameter("idsOrdenacao", "5").addParameter("ordemOrdenacao5", "").addParameter("tipoOrdenacao5", "").addParameter("idsOrdenacao", "6").addParameter("ordemOrdenacao6", "").addParameter("tipoOrdenacao6", "").addParameter("idsOrdenacao", "7").addParameter("ordemOrdenacao7", "").addParameter("tipoOrdenacao7", "").addParameter("idsOrdenacao", "8").addParameter("ordemOrdenacao8", "").addParameter("tipoOrdenacao8", "").addParameter("idsOrdenacao", "9").addParameter("ordemOrdenacao9", "").addParameter("tipoOrdenacao9", "").addParameter("idsOrdenacao", "10").addParameter("ordemOrdenacao10", "").addParameter("tipoOrdenacao10", "").addParameter("idsOrdenacao", "11").addParameter("ordemOrdenacao11", "").addParameter("tipoOrdenacao11", "").addParameter("idsOrdenacao", "12").addParameter("ordemOrdenacao12", "").addParameter("tipoOrdenacao12", "").addParameter("idsOrdenacao", "13").addParameter("ordemOrdenacao13", "").addParameter("tipoOrdenacao13", "").addParameter("idsOrdenacao", "14").addParameter("ordemOrdenacao14", "").addParameter("tipoOrdenacao14", "").addParameter("idsOrdenacao", "15").addParameter("ordemOrdenacao15", "").addParameter("tipoOrdenacao15", "").addParameter("idsOrdenacao", "16").addParameter("ordemOrdenacao16", "").addParameter("tipoOrdenacao16", "").addParameter("idsOrdenacao", "17").addParameter("ordemOrdenacao17", "").addParameter("tipoOrdenacao17", "").addParameter("idsOrdenacao", "18").addParameter("ordemOrdenacao18", "").addParameter("tipoOrdenacao18", "").addParameter("idsOrdenacao", "19").addParameter("ordemOrdenacao19", "").addParameter("tipoOrdenacao19", "").addParameter("idsOrdenacao", "20").addParameter("ordemOrdenacao20", "").addParameter("tipoOrdenacao20", "").addParameter("idsOrdenacao", "21").addParameter("ordemOrdenacao21", "").addParameter("tipoOrdenacao21", "").addParameter("paginaAtual", "0").addParameter("maximo_resultados_pagina", "50").addParameter("formatoRetorno", "CSV").executePost("https://fatura.orbitsistemas.com.br/ServletControleDownload").getReturnedHtml();
        String msg = xml.substring(xml.indexOf("mensagem"));
        msg = msg.substring(0, msg.indexOf(">"));
        return msg.contains("OK");
    }

    private boolean downloadIsPreparePerfil(JSONObject dadosFatura, String codigoDownload) throws Exception {
        this.conexao.addParameter("acao", "resetaStatusDownload").addParameter("codigoDownload", "download" + codigoDownload).executePost("https://fatura.orbitsistemas.com.br/ServletControleDownload");
        this.conexao.addParameter("acao", "verificaDownload").addParameter("codigoDownload", "download" + codigoDownload).executePost("https://fatura.orbitsistemas.com.br/ServletControleDownload");
        String xml = this.conexao.addParameter("acao", "setParametros").addParameter("codigoDownload", "download" + codigoDownload).addParameter("id_analise", dadosFatura.getString("idAnalise")).addParameter("id_analise_geral", dadosFatura.getString("idAnaliseGeral")).addParameter("id_conta", dadosFatura.getString("idConta")).addParameter("idsFiltro", "1").addParameter("tipoFiltro_1", "ILIKE").addParameter("text_1", "").addParameter("idsFiltro", "2").addParameter("tipoFiltro_2", "DISTINCTSELECTION INNER").addParameter("idsFiltro", "3").addParameter("tipoFiltro_3", "DISTINCTSELECTION INNER").addParameter("idsFiltro", "4").addParameter("tipoFiltro_4", "DISTINCTSELECTION INNER").addParameter("idsFiltro", "5").addParameter("tipoFiltro_5", "BETWEEN").addParameter("valor_de_5", "").addParameter("valor_ate_5", "").addParameter("idsFiltro", "6").addParameter("tipoFiltro_6", "BETWEEN").addParameter("valor_de_6", "").addParameter("valor_ate_6", "").addParameter("idsFiltro", "7").addParameter("tipoFiltro_7", "BETWEEN").addParameter("valor_de_7", "").addParameter("valor_ate_7", "").addParameter("idsFiltro", "8").addParameter("tipoFiltro_8", "BETWEEN").addParameter("valor_de_8", "").addParameter("valor_ate_8", "").addParameter("idsFiltro", "9").addParameter("tipoFiltro_9", "BETWEEN").addParameter("valor_de_9", "").addParameter("valor_ate_9", "").addParameter("idsFiltro", "10").addParameter("tipoFiltro_10", "BETWEEN").addParameter("valor_de_10", "").addParameter("valor_ate_10", "").addParameter("idsFiltro", "11").addParameter("tipoFiltro_11", "BETWEEN").addParameter("valor_de_11", "").addParameter("valor_ate_11", "").addParameter("idsFiltro", "12").addParameter("tipoFiltro_12", "BETWEEN").addParameter("valor_de_12", "").addParameter("valor_ate_12", "").addParameter("idsFiltro", "13").addParameter("tipoFiltro_13", "BETWEEN").addParameter("valor_de_13", "").addParameter("valor_ate_13", "").addParameter("idsFiltro", "14").addParameter("tipoFiltro_14", "BETWEEN").addParameter("valor_de_14", "").addParameter("valor_ate_14", "").addParameter("idsFiltro", "15").addParameter("tipoFiltro_15", "ILIKE").addParameter("text_15", "").addParameter("idsFiltro", "16").addParameter("tipoFiltro_16", "BETWEEN").addParameter("valor_de_16", "").addParameter("valor_ate_16", "").addParameter("idsFiltro", "17").addParameter("tipoFiltro_17", "ILIKE").addParameter("text_17", "").addParameter("idsFiltro", "18").addParameter("tipoFiltro_18", "BETWEEN").addParameter("valor_de_18", "").addParameter("valor_ate_18", "").addParameter("idsFiltro", "19").addParameter("tipoFiltro_19", "BETWEEN").addParameter("valor_de_19", "").addParameter("valor_ate_19", "").addParameter("idsFiltro", "20").addParameter("tipoFiltro_20", "BETWEEN").addParameter("valor_de_20", "").addParameter("valor_ate_20", "").addParameter("idsOrdenacao", "1").addParameter("ordemOrdenacao1", "").addParameter("tipoOrdenacao1", "").addParameter("idsOrdenacao", "2").addParameter("ordemOrdenacao2", "").addParameter("tipoOrdenacao2", "").addParameter("idsOrdenacao", "3").addParameter("ordemOrdenacao3", "").addParameter("tipoOrdenacao3", "").addParameter("idsOrdenacao", "4").addParameter("ordemOrdenacao4", "").addParameter("tipoOrdenacao4", "").addParameter("idsOrdenacao", "5").addParameter("ordemOrdenacao5", "").addParameter("tipoOrdenacao5", "").addParameter("idsOrdenacao", "6").addParameter("ordemOrdenacao6", "").addParameter("tipoOrdenacao6", "").addParameter("idsOrdenacao", "7").addParameter("ordemOrdenacao7", "").addParameter("tipoOrdenacao7", "").addParameter("idsOrdenacao", "8").addParameter("ordemOrdenacao8", "").addParameter("tipoOrdenacao8", "").addParameter("idsOrdenacao", "9").addParameter("ordemOrdenacao9", "").addParameter("tipoOrdenacao9", "").addParameter("idsOrdenacao", "10").addParameter("ordemOrdenacao10", "").addParameter("tipoOrdenacao10", "").addParameter("idsOrdenacao", "11").addParameter("ordemOrdenacao11", "").addParameter("tipoOrdenacao11", "").addParameter("idsOrdenacao", "12").addParameter("ordemOrdenacao12", "").addParameter("tipoOrdenacao12", "").addParameter("idsOrdenacao", "13").addParameter("ordemOrdenacao13", "").addParameter("tipoOrdenacao13", "").addParameter("idsOrdenacao", "14").addParameter("ordemOrdenacao14", "").addParameter("tipoOrdenacao14", "").addParameter("idsOrdenacao", "15").addParameter("ordemOrdenacao15", "").addParameter("tipoOrdenacao15", "").addParameter("idsOrdenacao", "16").addParameter("ordemOrdenacao16", "").addParameter("tipoOrdenacao16", "").addParameter("idsOrdenacao", "17").addParameter("ordemOrdenacao17", "").addParameter("tipoOrdenacao17", "").addParameter("idsOrdenacao", "18").addParameter("ordemOrdenacao18", "").addParameter("tipoOrdenacao18", "").addParameter("idsOrdenacao", "19").addParameter("ordemOrdenacao19", "").addParameter("tipoOrdenacao19", "").addParameter("idsOrdenacao", "20").addParameter("ordemOrdenacao20", "").addParameter("tipoOrdenacao20", "").addParameter("paginaAtual", "0").addParameter("maximo_resultados_pagina", "50").addParameter("formatoRetorno", "CSV").executePost("https://fatura.orbitsistemas.com.br/ServletControleDownload").getReturnedHtml();
        String msg = xml.substring(xml.indexOf("mensagem"));
        msg = msg.substring(0, msg.indexOf(">"));
        return msg.contains("OK");
    }

    private HashMap<String, String> getPlano(InputStream isOrbit) {
        HashMap<String, String> retorno = new HashMap<String, String>();
        try {
            String[] arr;
            String csv = InputStreamUtil.toString((InputStream)isOrbit, (Charset)Charset.forName("iso-8859-1"));
            for (String linha : arr = csv.split("\n")) {
                String[] cols = linha.split(";");
                if (cols.length < 4) continue;
                String n = StringUtil.numbersOnly((String)cols[0]);
                String p = cols[3].replace("\"", "");
                if (p.contains(" 05GB")) {
                    p = p.replace("05GB", "0.5GB");
                }
                if (n.length() < 10) continue;
                retorno.put(n, p);
                cols = null;
                n = null;
                p = null;
            }
            csv = null;
            arr = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retorno;
    }
}

