/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.model;

import br.com.system.app.features.cliente.model.ClienteClassificacao;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteResponsavel;
import br.com.system.app.features.cliente.model.ClienteVencimento;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.pessoa.model.Pessoa;
import br.com.system.app.features.shared.model.IEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@DynamicUpdate
@Table(name="cliente")
public class Cliente
implements IEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @OneToOne
    private Estrutura estrutura;
    @NotNull
    private String cpfCnpj;
    @NotNull
    private String nome;
    private String cep;
    private String logradouro;
    private String numero;
    private String complemento;
    private String bairro;
    private String cidade;
    private String estado;
    @OneToOne
    private ClienteClassificacao clienteClassificacao;
    private Integer tempoMedio;
    @OneToMany(mappedBy="cliente", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true, targetEntity=Pessoa.class)
    private Set<Pessoa> pessoas = new HashSet();
    @OneToMany(mappedBy="cliente", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true, targetEntity=ClienteVencimento.class)
    private Set<ClienteVencimento> vencimentos = new HashSet();
    private String tags;
    @NotNull
    @OneToMany(mappedBy="cliente", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true, targetEntity=ClienteContato.class)
    private Set<ClienteContato> clienteContato = new HashSet();
    @NotNull
    @OneToMany(mappedBy="cliente", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true, targetEntity=ClienteResponsavel.class)
    private Set<ClienteResponsavel> clienteResponsavel = new HashSet();
    private LocalDateTime dataHoraAtualizacao;
    private String inscricaoEstadual;
    private String observacao;
    private String loginGestor;
    private String senhaGestor;
    private String loginContaOnline;
    private String senhaContaOnline;
    private String cpfContaOnline;
    private Boolean cadastroWhatsapp;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Estrutura getEstrutura() {
        return this.estrutura;
    }

    public void setEstrutura(Estrutura estrutura) {
        this.estrutura = estrutura;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public Set<Pessoa> getPessoas() {
        return this.pessoas;
    }

    public void setPessoas(Set<Pessoa> pessoas) {
        this.pessoas = pessoas;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public Set<ClienteContato> getClienteContato() {
        return this.clienteContato;
    }

    public void setClienteContato(Set<ClienteContato> clienteContato) {
        this.clienteContato = clienteContato;
    }

    public LocalDateTime getDataHoraAtualizacao() {
        return this.dataHoraAtualizacao;
    }

    public void setDataHoraAtualizacao(LocalDateTime dataHoraAtualizacao) {
        this.dataHoraAtualizacao = dataHoraAtualizacao;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public String getCidade() {
        return this.cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public String getEstado() {
        return this.estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public Set<ClienteResponsavel> getClienteResponsavel() {
        return this.clienteResponsavel;
    }

    public void setClienteResponsavel(Set<ClienteResponsavel> clienteResponsavel) {
        this.clienteResponsavel = clienteResponsavel;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public ClienteClassificacao getClienteClassificacao() {
        return this.clienteClassificacao;
    }

    public void setClienteClassificacao(ClienteClassificacao clienteClassificacao) {
        this.clienteClassificacao = clienteClassificacao;
    }

    public Integer getTempoMedio() {
        return this.tempoMedio;
    }

    public void setTempoMedio(Integer tempoMedio) {
        this.tempoMedio = tempoMedio;
    }

    public String getLoginGestor() {
        return this.loginGestor;
    }

    public void setLoginGestor(String loginGestor) {
        this.loginGestor = loginGestor;
    }

    public String getSenhaGestor() {
        return this.senhaGestor;
    }

    public void setSenhaGestor(String senhaGestor) {
        this.senhaGestor = senhaGestor;
    }

    public String getLoginContaOnline() {
        return this.loginContaOnline;
    }

    public void setLoginContaOnline(String loginContaOnline) {
        this.loginContaOnline = loginContaOnline;
    }

    public String getSenhaContaOnline() {
        return this.senhaContaOnline;
    }

    public void setSenhaContaOnline(String senhaContaOnline) {
        this.senhaContaOnline = senhaContaOnline;
    }

    public String getCpfContaOnline() {
        return this.cpfContaOnline;
    }

    public void setCpfContaOnline(String cpfContaOnline) {
        this.cpfContaOnline = cpfContaOnline;
    }

    public Boolean getCadastroWhatsapp() {
        return this.cadastroWhatsapp;
    }

    public void setCadastroWhatsapp(Boolean cadastroWhatsapp) {
        this.cadastroWhatsapp = cadastroWhatsapp;
    }

    public Set<ClienteVencimento> getVencimentos() {
        return this.vencimentos;
    }

    public void setVencimentos(Set<ClienteVencimento> vencimentos) {
        this.vencimentos = vencimentos;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.cpfCnpj);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cliente other = (Cliente)obj;
        return Objects.equals(this.cpfCnpj, other.cpfCnpj);
    }
}

