/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.BorderStyle;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.pedido.dto.PedidoResumeDTO;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.pedido.view.atividade.AtividadeView;
import br.com.system.app.features.usuario.dto.UsuarioTemaEnum;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H4;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@RolesAllowed(value={"CLIENTE_TIME_LINE"})
public class ClienteTimeLineView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final Cliente cliente;
    private final AtividadeView atividadeView;
    private final EstruturaUsuarioService eus;
    private final PedidoService pedidoService;
    private final Button btnClose;

    @Autowired
    public ClienteTimeLineView(Cliente cliente, PedidoService pedidoService, EstruturaUsuarioService eus, AtividadeView atividadeView) {
        this.pedidoService = pedidoService;
        this.atividadeView = atividadeView;
        this.eus = eus;
        this.cliente = cliente;
        this.btnClose = UIUtils.createSmallButton((String)"Fechar");
    }

    public Button getCloseButton() {
        return this.btnClose;
    }

    public void createContent() {
        this.setWidth("450px");
        VerticalContainer cv = new VerticalContainer(new Component[0]);
        List pedidos = this.pedidoService.getForResume(this.getEu(), this.cliente.getCpfCnpj());
        if (pedidos.size() <= 0) {
            UIUtils.showNotification((String)"N\u00e3o h\u00e1 atividades para este cliente");
            return;
        }
        for (PedidoResumeDTO pedido : pedidos) {
            String dataHora = pedido.getDataHoraAtualizacao().format(FormatDate.DATETIME_BR.toDTF());
            String texto = "Atividade <strong>#" + pedido.getTipoAtividade() + "</strong> criada pelo usu\u00e1rio <strong>" + pedido.getLogin() + "</strong> em <strong>" + pedido.getDataCadastro().format(FormatDate.DATE_BR.toDTF()) + "</strong> etapa atual <strong>" + pedido.getStatus() + "</strong>";
            if (pedido.getTags() != null && !pedido.getTags().isBlank()) {
                texto = texto + " tags <strong>" + pedido.getTags() + "</strong>";
            }
            if (pedido.getDataRetornoFuturo() != null) {
                texto = texto + " retorno futuro em <strong>" + pedido.getDataRetornoFuturo().format(FormatDate.DATE_BR.toDTF()) + "</strong>";
            }
            FooterContainer footer = new FooterContainer(new Component[]{new H4(pedido.getNumero()), new H4(dataHora)});
            footer.setWidth("98%");
            Button btnOpen = UIUtils.createSmallButton((String)"Abrir Atividade");
            btnOpen.setVisible(this.atividadeView != null);
            btnOpen.addClickListener((ComponentEventListener & Serializable)e -> {
                Pedido p = this.pedidoService.getById(pedido.getId());
                this.abrePedido(p);
            });
            Div div = new Div();
            div.getElement().setProperty("innerHTML", "<span>" + texto + "</span>");
            div.setWidth("98%");
            VerticalContainer c = new VerticalContainer(new Component[0]);
            if (this.getUsuario().getTema().equals((Object)UsuarioTemaEnum.DARK)) {
                UIUtils.setBorder((BorderStyle)BorderStyle.DOTTED, (String)"2px", (Component[])new Component[]{c});
            } else {
                c.setShadow(Shadow.S);
            }
            c.setMinHeight("150px");
            c.setWidth("100%");
            c.add(new Component[]{footer, div});
            if (this.eus.naHierarquia(this.getEu(), pedido.getEstruturaUsuarioId())) {
                c.add(new Component[]{btnOpen});
            }
            cv.add(new Component[]{c});
        }
        cv.add(new Component[]{new FooterContainer(new Component[]{this.btnClose})});
        this.add(new Component[]{UIUtils.createHeader((String)"Timeline Cliente")});
        this.add(new Component[]{UIUtils.createHeader((String)this.cliente.getCpfCnpj())});
        this.add(new Component[]{UIUtils.createHeader((String)this.cliente.getNome())});
        this.add(new Component[]{cv});
        this.open();
    }

    private void abrePedido(Pedido pedido) {
        this.atividadeView.create(pedido, this.getEu(), pedido.getPedidoTipo());
        this.atividadeView.getBtnSalvar().setEnabled(pedido.getEstruturaUsuario().getId().equals(this.getEu().getId()));
        this.atividadeView.getBtnInserir().setEnabled(pedido.getEstruturaUsuario().getId().equals(this.getEu().getId()));
    }
}

