/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view.form;

import br.com.system.app.components.InformationDialog;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.vivo.model.VivoProspectBiEstrutura;
import br.com.system.app.features.vivo.service.VivoProspectBiService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

@org.springframework.stereotype.Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class ClienteFormBi
extends VerticalLayout
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private VivoProspectBiService prospectBiService;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public VerticalLayout create(Cliente cliente) {
        VivoProspectBiEstrutura pbi;
        VerticalLayout lay = new VerticalLayout();
        lay.removeAll();
        lay.setEnabled(cliente != null && cliente.getId() != null);
        lay.add(new Component[]{new Hr()});
        lay.add(new Component[]{UIUtils.createHeader((String)"Prospect BI(Cobertura)")});
        if (this.isVivo() && cliente != null && cliente.getCpfCnpj() != null && (pbi = this.prospectBiService.getByCpfCnpj(cliente.getEstrutura(), cliente.getCpfCnpj())) != null) {
            TextField flag = new TextField("Flag Disp");
            flag.setWidth("80px");
            flag.setValue(pbi.getFlagDisp().toString());
            flag.setReadOnly(true);
            Button b = UIUtils.createSmallButton((String)"Ver Dados");
            b.setEnabled(pbi.getFlagDisp() == 3 && pbi.getEnriquecimento() != null);
            b.addClickListener((ComponentEventListener & Serializable)bc -> InformationDialog.show((String)"Prospect BI", (String)pbi.getEnriquecimento().replace("|", "\n")));
            lay.add(new Component[]{flag, b});
        }
        return lay;
    }
}

