/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view.form;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteVencimento;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Set;

public class ClienteFormVencimento
extends VerticalLayout
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private Cliente cliente;
    private Set<ClienteVencimento> vencs = new HashSet();

    public ClienteFormVencimento(Cliente cliente) {
        this.cliente = cliente;
        this.create(cliente);
    }

    public Set<ClienteVencimento> getVencs() {
        return this.vencs;
    }

    private void create(Cliente cli) {
        this.cliente = cli;
        this.removeAll();
        this.setEnabled(this.cliente != null && this.cliente.getId() != null);
        this.add(new Component[]{new Hr()});
        this.add(new Component[]{UIUtils.createHeader((String)"Vencimento Faturas")});
        Button btnAdd = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar novo vencimento");
        btnAdd.addClickListener((ComponentEventListener & Serializable)e -> {
            ClienteVencimento cv = new ClienteVencimento();
            this.createItem(cv);
            this.vencs.add(cv);
        });
        this.add(new Component[]{btnAdd});
        if (this.cliente != null) {
            this.vencs = cli.getVencimentos();
            for (ClienteVencimento venc : this.vencs) {
                this.createItem(venc);
            }
        }
    }

    public void createItem(ClienteVencimento cv) {
        TextField nome = new TextField("Identificador");
        DatePicker aPartir = new DatePicker();
        DatePicker ate = new DatePicker();
        NumberField dia = new NumberField("Dia Vencimento");
        if (cv.getNome() != null) {
            nome.setValue(cv.getNome());
        }
        nome.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> cv.setNome(nome.getValue()));
        if (cv.getDia() != null) {
            dia.setValue((Number)cv.getDia().doubleValue());
        }
        dia.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> cv.setDia(Integer.valueOf(((Double)dia.getValue()).intValue())));
        aPartir.setLabel("A partir de");
        aPartir.setLocale(UIUtils.getLocale());
        if (cv.getApartir() != null) {
            aPartir.setValue(cv.getApartir());
        }
        aPartir.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> cv.setApartir((LocalDate)aPartir.getValue()));
        ate.setLabel("Enviar At\u00e9");
        ate.setLocale(UIUtils.getLocale());
        if (cv.getAte() != null) {
            ate.setValue(cv.getAte());
        }
        ate.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> cv.setAte((LocalDate)ate.getValue()));
        Button btnDel = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Deletar");
        HorizontalContainer hc = new HorizontalContainer(new Component[]{nome, dia, aPartir, ate, btnDel});
        btnDel.addClickListener((ComponentEventListener & Serializable)e -> {
            this.remove(new Component[]{hc});
            this.vencs.remove(cv);
        });
        this.add(new Component[]{hc});
    }

    public String validar() {
        Object s = "";
        Set vencimentos = this.getVencs();
        for (ClienteVencimento vencimento : vencimentos) {
            if (vencimento.getAte() == null) {
                s = (String)s + "Enviar At\u00e9 \u00e9 obrigat\u00f3rio\n";
            }
            if (vencimento.getApartir() == null) {
                s = (String)s + "A partir de \u00e9 obrigat\u00f3rio\n";
            }
            if (vencimento.getDia() == null || vencimento.getDia() <= 0 || vencimento.getDia() > 30) {
                s = (String)s + "Dia \u00e9 obrigat\u00f3rio e deve estar entre 1 e 30\n";
            }
            if (vencimento.getAte() == null || vencimento.getApartir() == null || !vencimento.getAte().isBefore(vencimento.getApartir())) continue;
            s = (String)s + "Enviar at\u00e9 deve ser posterior de A partir\n";
        }
        return s;
    }
}

