/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.endereco;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.cep.dto.CepResult;
import br.com.system.app.features.cep.model.CepLocalidade;
import br.com.system.app.features.cep.model.CepUf;
import br.com.system.app.features.cep.service.CepService;
import br.com.system.app.features.endereco.model.Endereco;
import br.com.system.app.features.endereco.model.EnderecoTipoEnum;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.commons.StringUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.util.Collection;

public class EnderecoView
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private TextField logradouro;
    private TextField numero;
    private TextField compl;
    private TextField bairro;
    private ComboBox<CepLocalidade> cidade;
    private ComboBox<CepUf> estado;
    private TextField cep;
    private Endereco endereco;
    private final EnderecoTipoEnum tipo;
    private final CepService cepService;
    private final String titulo;

    public EnderecoView(CepService cepService, Endereco endereco, EnderecoTipoEnum tipo, String titulo) {
        this.cepService = cepService;
        this.tipo = tipo;
        this.titulo = titulo;
        this.endereco = endereco;
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.create();
    }

    private void create() {
        this.setWidth("100%");
        this.removeAll();
        this.add(new Component[]{new Hr()});
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        this.cep = new TextField("Cep");
        this.cep.setWidth("150px");
        this.cep.setMinLength(8);
        this.cep.setMaxLength(8);
        this.cep.setValue(this.endereco.getCep() == null ? "" : this.endereco.getCep());
        this.cep.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            String inputCep = StringUtil.numbersOnly((String)((TextField)e.getSource()).getValue());
            if (inputCep.length() != 8) {
                return;
            }
            CepResult c = this.cepService.findByCep(inputCep);
            if (c != null) {
                CepUf cepUf = this.cepService.getUfBySigla(c.getEstado());
                CepLocalidade cl = this.cepService.getLocalidadeByNome(cepUf, c.getCidade());
                this.logradouro.setValue(c.getLogradouro());
                this.estado.setValue((Object)cepUf);
                this.cidade.setItems((Collection)this.cepService.getLocalidadeByUf(cepUf));
                this.cidade.setValue((Object)cl);
                this.bairro.setValue(c.getBairro());
            }
        });
        this.logradouro = new TextField("Logradouro");
        this.logradouro.setWidth("300px");
        this.logradouro.setValue(this.endereco.getLogradouro() == null ? "" : this.endereco.getLogradouro());
        this.numero = new TextField("Numero");
        this.numero.setWidth("80px");
        this.numero.setValue(this.endereco.getNumero() == null ? "" : this.endereco.getNumero());
        this.compl = new TextField("Complemento");
        this.compl.setWidth("250px");
        this.compl.setValue(this.endereco.getComplemento() == null ? "" : this.endereco.getComplemento());
        this.bairro = new TextField("Bairro");
        this.bairro.setWidth("80px");
        this.bairro.setValue(this.endereco.getBairro() == null ? "" : this.endereco.getBairro());
        this.cidade = new ComboBox("Cidade");
        this.cidade.setItemLabelGenerator(CepLocalidade::getNome);
        this.cidade.setWidth("300px");
        this.estado = new ComboBox("UF", (Collection)this.cepService.getUf());
        this.estado.setWidth("70px");
        this.estado.setItemLabelGenerator(CepUf::getSigla);
        CepUf cepUf = this.cepService.getUfBySigla(this.endereco.getEstado());
        if (cepUf != null) {
            this.estado.setValue((Object)cepUf);
            this.cidade.setItems((Collection)this.cepService.getLocalidadeByUf(cepUf));
            CepLocalidade cl = this.cepService.getLocalidadeByNome(cepUf, this.endereco.getCidade());
            if (cl != null) {
                this.cidade.setValue((Object)cl);
            }
            this.estado.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.cidade.setItems((Collection)this.cepService.getLocalidadeByUf((CepUf)e.getValue())));
        }
        this.add(new Component[]{UIUtils.createHeader((String)this.titulo), new HorizontalContainer(new Component[]{this.cep, this.logradouro, this.numero, this.compl, this.bairro, this.estado, this.cidade})});
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
        this.create();
    }

    public void clear() {
        this.bairro.clear();
        this.cep.clear();
        this.cidade.clear();
        this.estado.clear();
        this.logradouro.clear();
        this.numero.clear();
        this.compl.clear();
    }

    public Endereco getValue() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        this.endereco.setBairro(this.bairro.getValue() == null ? "" : this.bairro.getValue());
        this.endereco.setCep(StringUtil.numbersOnly((String)this.cep.getValue()));
        this.endereco.setCidade(this.cidade.getValue() == null ? "" : ((CepLocalidade)this.cidade.getValue()).getNome());
        this.endereco.setComplemento(this.compl.getValue());
        this.endereco.setEstado(this.estado.getValue() == null ? "" : ((CepUf)this.estado.getValue()).getSigla());
        this.endereco.setLogradouro(this.logradouro.getValue() == null ? "" : this.logradouro.getValue());
        this.endereco.setNumero(this.numero.getValue() == null ? "" : this.numero.getValue());
        this.endereco.setTipo(this.tipo);
        return this.endereco;
    }

    public String getErros() {
        Object erros = "";
        if (StringUtil.numbersOnly((String)this.cep.getValue()).length() != 8) {
            erros = (String)erros + "Cep inv\u00e1lido\n";
        }
        if (this.logradouro.getValue().length() < 3) {
            erros = (String)erros + "Logradouro inv\u00e1lido\n";
        }
        if (this.bairro.getValue().isBlank()) {
            erros = (String)erros + "Bairro inv\u00e1lido\n";
        }
        if (this.estado.getValue() == null) {
            erros = (String)erros + "Selecione um estado\n";
        }
        if (this.cidade.getValue() == null) {
            erros = (String)erros + "Selecione uma cidade\n";
        }
        return erros;
    }
}

