/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.model;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.sistemasexternos.model.SistemasExternos;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="estrutura_senhas")
@DynamicUpdate
public class EstruturaSenhas
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    @JsonIgnore
    @NotNull
    private Estrutura estrutura;
    @NotNull
    @OneToOne
    private SistemasExternos sistemasExternos;
    @NotNull
    private String nome;
    @NotNull
    private Boolean ativo;
    @NotNull
    private String login;
    private String senha;
    private String dadosExtras;
    private Boolean senhaCorreta = true;
    private LocalDateTime dataHoraChecagemSenha;
    private String listaCeps;

    public String getNomeLoginSistema() {
        return this.getNome() + " " + this.getLogin() + " (" + this.getSistemasExternos().getSistemaExterno().name() + ")";
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Estrutura getEstrutura() {
        return this.estrutura;
    }

    public void setEstrutura(Estrutura estrutura) {
        this.estrutura = estrutura;
    }

    public SistemasExternos getSistemasExternos() {
        return this.sistemasExternos;
    }

    public void setSistemasExternos(SistemasExternos sistemasExternos) {
        this.sistemasExternos = sistemasExternos;
    }

    public String getNome() {
        return this.nome;
    }

    public String getEstruturaAndNome() {
        return this.getEstrutura().getNome() + " " + this.getNome();
    }

    public String getNomeAndSistema() {
        return this.getNome() + "  (" + this.getSistemasExternos().getSistemaExterno().name() + ")";
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public String getDadosExtras() {
        return this.dadosExtras;
    }

    public void setDadosExtras(String dadosExtras) {
        this.dadosExtras = dadosExtras;
    }

    public Boolean getSenhaCorreta() {
        return this.senhaCorreta;
    }

    public void setSenhaCorreta(Boolean senhaCorreta) {
        this.senhaCorreta = senhaCorreta;
    }

    public LocalDateTime getDataHoraChecagemSenha() {
        return this.dataHoraChecagemSenha;
    }

    public void setDataHoraChecagemSenha(LocalDateTime dataHoraChecagemSenha) {
        this.dataHoraChecagemSenha = dataHoraChecagemSenha;
    }

    public String getListaCeps() {
        return this.listaCeps;
    }

    public void setListaCeps(String listaCeps) {
        this.listaCeps = listaCeps;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EstruturaSenhas other = (EstruturaSenhas)obj;
        return Objects.equals(this.id, other.id);
    }
}

