/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.repository;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.EstruturaUsuarioRepositoryQuery;
import br.com.system.app.features.estrutura.repository.projection.SimplifiedEstruturaUsuario;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface EstruturaUsuarioRepository
extends JpaRepository<EstruturaUsuario, Long>,
EstruturaUsuarioRepositoryQuery,
Serializable {
    public List<EstruturaUsuario> findByUsuarioWhatsappConta(WhatsAppConta var1);

    public EstruturaUsuario findByUsuarioAndEstrutura(Usuario var1, Estrutura var2);

    public EstruturaUsuario findFirstByUsuario(Usuario var1);

    @Query(value="SELECT CASE WHEN COUNT(eu) > 0 THEN true ELSE false END FROM EstruturaUsuario eu WHERE eu.usuario = :usuario AND eu.estrutura = :estrutura AND eu.ativo = true")
    public boolean usuarioHasAccessToEstrutura(@Param(value="usuario") Usuario var1, @Param(value="estrutura") Estrutura var2);

    @Query(value="SELECT e FROM Estrutura e, EstruturaUsuario eu WHERE e.id = eu.estrutura.id AND eu.usuario = :usuario AND eu.ativo = true AND e.ativo = true ")
    public Set<Estrutura> findEstruturasByUsuario(@Param(value="usuario") Usuario var1);

    @Query(value="SELECT NEW br.com.system.app.features.estrutura.repository.projection.SimplifiedEstruturaUsuario(eu.id, eu.usuario.id, eu.estrutura.id,eu.estrutura.estruturaTipo.id) FROM Usuario u, EstruturaUsuario eu WHERE u.id = eu.usuario.id AND eu.usuario = :usuario AND eu.ativo = true")
    public Set<SimplifiedEstruturaUsuario> findSimplifiedAccessList(@Param(value="usuario") Usuario var1);

    @Query(nativeQuery=true, value="SELECT h.estrutura_usuario_filho_id FROM hierarquia h INNER JOIN estrutura_usuario eu ON (h.estrutura_usuario_id = eu.id) WHERE eu.usuario_id = :usuarioId AND eu.estrutura_id = :estruturaId AND eu.ativo = true")
    public Set<Long> findHierarchy(@Param(value="usuarioId") Long var1, @Param(value="estruturaId") Long var2);

    @Query(nativeQuery=true, value="SELECT h.estrutura_usuario_filho_id FROM hierarquia h INNER JOIN estrutura_usuario eu ON (h.estrutura_usuario_id = eu.id) WHERE eu.usuario_id = :usuarioId AND eu.estrutura_id = :estruturaId AND eu.ativo = true")
    public Long[] findHierarchyLongArray(@Param(value="usuarioId") Long var1, @Param(value="estruturaId") Long var2);

    @Query(value="SELECT eu.id FROM EstruturaUsuario eu WHERE eu.usuario.id IN :usuarios AND eu.estrutura = :estrutura")
    public Set<Long> findUsersInEstruturaWithInatives(@Param(value="usuarios") Set<Long> var1, @Param(value="estrutura") Estrutura var2);

    @Query(value="SELECT eu FROM EstruturaUsuario eu WHERE eu.usuario = :usuario AND eu.estrutura = :estrutura AND eu.ativo = true")
    public EstruturaUsuario findEstruturaUsuario(@Param(value="usuario") Usuario var1, @Param(value="estrutura") Estrutura var2);

    @Query(value="SELECT eu FROM EstruturaUsuario eu WHERE eu.usuario = :usuario AND eu.estrutura = :estrutura")
    public EstruturaUsuario findEstruturaUsuarioWithInative(@Param(value="usuario") Usuario var1, @Param(value="estrutura") Estrutura var2);

    @Query(value="Select eu.usuario.nome from EstruturaUsuario eu WHERE eu.id=:estruturaUsuarioId")
    public String getNome(@Param(value="estruturaUsuarioId") Long var1);

    @Query(value="SELECT eu FROM EstruturaUsuario eu WHERE eu.id NOT IN :hierarquia and eu.estrutura = :estrutura")
    public List<EstruturaUsuario> findWithoutMyHierarquia(@Param(value="hierarquia") Set<Long> var1, @Param(value="estrutura") Estrutura var2);

    @Modifying
    @Transactional
    @Query(nativeQuery=true, value="update estrutura_usuario eu,usuario u set eu.ativo=0 where eu.usuario_id=u.id and u.ultimo_login<:dataHora")
    public void bloqueioInatividade(@Param(value="dataHora") LocalDateTime var1);
}

