/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.repository;

import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.equipe.model.EquipeFilterEnum;
import br.com.system.app.features.estrutura.dto.EstruturaUsuarioEquipeDTO;
import br.com.system.app.features.estrutura.dto.EstruturaUsuarioPermissaoDTO;
import br.com.system.app.features.estrutura.dto.EstruturaUsuarioSimplifyDTO;
import br.com.system.app.features.estrutura.dto.PermissaoFilterEnum;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.EstruturaUsuarioRepositoryQuery;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.commons.StringUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.transaction.annotation.Transactional;

public class EstruturaUsuarioRepositoryImpl
implements EstruturaUsuarioRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public List<Long> findByTagUsuario(Estrutura estrutura, String tagUsuario, Boolean ativo) {
        StringBuilder sql = new StringBuilder("select eu.id FROM estrutura_usuario eu,usuario u where eu.usuario_id=u.id ");
        if (ativo != null) {
            sql.append(" and eu.ativo=1");
        }
        sql.append(" and eu.estrutura_id=:estrutura AND find_in_set('").append(tagUsuario).append("',u.tags)");
        Query q = this.manager.createNativeQuery(sql.toString());
        q.setParameter("estrutura", (Object)estrutura.getId());
        return q.getResultList();
    }

    @Modifying
    @Transactional
    public void salvarHierarquia(EstruturaUsuario eu, Set<Long> hierarquia) {
        if (eu == null || hierarquia == null) {
            throw new BusinessException("EstruturaUsuario e Hierarquia s\u00e3o obrigatorios");
        }
        Query queryUpdate = this.manager.createNativeQuery("delete from hierarquia where estrutura_usuario_id=:euId");
        queryUpdate.setParameter("euId", (Object)eu.getId());
        queryUpdate.executeUpdate();
        if (hierarquia.size() > 0) {
            StringBuilder sql = new StringBuilder("insert ignore into hierarquia(estrutura_usuario_id,estrutura_usuario_filho_id) values");
            hierarquia.forEach(item -> sql.append("(").append(eu.getId()).append(",").append(item).append("),"));
            this.manager.createNativeQuery(StringUtil.removeLastChar((String)sql.toString())).executeUpdate();
        }
    }

    @Transactional
    public void insertHierarquia(EstruturaUsuario eu, EstruturaUsuario euModel) {
        String s = "select estrutura_usuario_id from hierarquia where estrutura_usuario_filho_id=" + euModel.getId() + " and estrutura_usuario_id!=" + euModel.getId();
        Query query = this.manager.createNativeQuery(s, Long.class);
        List ll = query.getResultList();
        if (ll.size() <= 0) {
            return;
        }
        StringBuilder sql = new StringBuilder("insert ignore into hierarquia(estrutura_usuario_id,estrutura_usuario_filho_id) values");
        for (Long bi : ll) {
            sql.append("(").append(bi.toString()).append(",").append(eu.getId()).append("),");
        }
        this.manager.createNativeQuery(StringUtil.removeLastChar((String)sql.toString())).executeUpdate();
    }

    @Transactional
    public void updateEquipe(Set<Long> listaIds, Equipe equipe, Boolean incluir) {
        if (equipe == null || listaIds.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        if (incluir.booleanValue()) {
            sql.append("update estrutura_usuario set equipe_id=:equipeId");
        } else {
            sql.append("update estrutura_usuario set equipe_id=null");
        }
        sql.append(" where id in :listaIds ");
        Query query = this.manager.createNativeQuery(sql.toString(), EstruturaUsuarioPermissaoDTO.class);
        if (incluir.booleanValue()) {
            query.setParameter("equipeId", (Object)equipe.getId());
        }
        query.setParameter("listaIds", listaIds);
        query.executeUpdate();
    }

    @Transactional
    public void updatePermission(Set<Long> listaIds, String rule, Boolean ativar) {
        StringBuilder sql = new StringBuilder();
        sql.append("update estrutura_usuario set ");
        if (ativar.booleanValue()) {
            sql.append("rules=CONCAT(rules,'").append(",").append(rule).append("')");
            sql.append(" where id in :listaIds AND not find_in_set(:rule,rules) ");
        } else {
            sql.append("rules=replace(replace(rules,'").append(",").append(rule).append("',''),'").append(rule).append(",").append("','')");
            sql.append(" where id in :listaIds ");
        }
        Query query = this.manager.createNativeQuery(sql.toString(), EstruturaUsuarioPermissaoDTO.class);
        if (ativar.booleanValue()) {
            query.setParameter("rule", (Object)rule);
        }
        query.setParameter("listaIds", listaIds);
        query.executeUpdate();
    }

    @Transactional(readOnly=true)
    public List<EstruturaUsuarioEquipeDTO> getEquipe(Estrutura estrutura, Equipe equipe, EquipeFilterEnum filter, String filterName, Boolean apenasAtivos) {
        StringBuilder sql = new StringBuilder();
        sql.append("select estrutura_usuario.id estrutura_usuario_id, usuario.nome as nome_usuario,equipe.id as equipe_id,equipe.nome nome_equipe,usuario.login,");
        sql.append(" estrutura_usuario.ativo,usuario.perfil");
        sql.append(" FROM");
        sql.append(" estrutura_usuario");
        sql.append(" LEFT JOIN usuario ON (estrutura_usuario.usuario_id = usuario.id)");
        sql.append(" LEFT OUTER JOIN equipe ON (estrutura_usuario.equipe_id = equipe.id)");
        sql.append(" WHERE estrutura_usuario.estrutura_id=:estruturaId");
        if (filter.equals((Object)EquipeFilterEnum.NA_EQUIPE)) {
            sql.append(" and estrutura_usuario.equipe_id=:equipeId");
        }
        if (filter.equals((Object)EquipeFilterEnum.FORA_EQUIPE)) {
            sql.append(" and estrutura_usuario.equipe_id is not null and estrutura_usuario.equipe_id !=:equipeId");
        }
        if (filter.equals((Object)EquipeFilterEnum.SEM_EQUIPE)) {
            sql.append(" and estrutura_usuario.equipe_id is null");
        }
        if (apenasAtivos.booleanValue()) {
            sql.append(" and estrutura_usuario.ativo=1");
        }
        if (!filterName.isEmpty()) {
            sql.append(" and usuario.nome like :filterName");
        }
        Query query = this.manager.createNativeQuery(sql.toString(), EstruturaUsuarioEquipeDTO.class);
        query.setParameter("estruturaId", (Object)estrutura.getId().toString());
        if (!filter.equals((Object)EquipeFilterEnum.TODOS) && !filter.equals((Object)EquipeFilterEnum.SEM_EQUIPE)) {
            query.setParameter("equipeId", (Object)equipe.getId());
        }
        if (!filterName.isEmpty()) {
            query.setParameter("filterName", (Object)("%" + filterName + "%"));
        }
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public boolean hasPermission(EstruturaUsuario eu, String permissao) {
        String sql = "select rules from estrutura_usuario where id=:euId";
        Query query = this.manager.createNativeQuery(sql.toString(), String.class);
        query.setParameter("euId", (Object)eu.getId());
        String rules = query.getSingleResult().toString();
        for (String rule : rules.split(",")) {
            if (!rule.toUpperCase().equals(permissao.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    @Transactional(readOnly=true)
    public List<EstruturaUsuarioPermissaoDTO> getPermissao(EstruturaUsuario eu, String permissao, PermissaoFilterEnum filter, String filterLogin, UsuarioPerfilEnum perfil, Boolean apenasAtivos) {
        StringBuilder sql = new StringBuilder();
        sql.append("select estrutura_usuario.id estrutura_id, usuario.login,estrutura_usuario.rules,usuario.perfil from estrutura_usuario,usuario");
        sql.append(" WHERE estrutura_usuario.usuario_id=usuario.id");
        if (!eu.getUsuario().isMaster()) {
            sql.append(" AND estrutura_usuario.estrutura_id=:estruturaId");
        }
        if (filter.equals((Object)PermissaoFilterEnum.COM_PERMISSAO)) {
            sql.append(" and find_in_set(:permissao,estrutura_usuario.rules)");
        }
        if (filter.equals((Object)PermissaoFilterEnum.SEM_PERMISSAO)) {
            sql.append(" and (not find_in_set(:permissao,estrutura_usuario.rules) or estrutura_usuario.rules is null)");
        }
        if (apenasAtivos.booleanValue()) {
            sql.append(" and estrutura_usuario.ativo=1");
        }
        if (!filterLogin.isEmpty()) {
            sql.append(" and usuario.login like :filterLogin");
        }
        if (perfil != null) {
            sql.append(" and usuario.perfil=:perfil");
        }
        Query query = this.manager.createNativeQuery(sql.toString(), EstruturaUsuarioPermissaoDTO.class);
        if (!eu.getUsuario().isMaster()) {
            query.setParameter("estruturaId", (Object)eu.getEstrutura().getId().toString());
        }
        if (!filter.equals((Object)PermissaoFilterEnum.TODOS)) {
            query.setParameter("permissao", (Object)permissao);
        }
        if (!filterLogin.isEmpty()) {
            query.setParameter("filterLogin", (Object)("%" + filterLogin));
        }
        if (perfil != null) {
            query.setParameter("perfil", (Object)perfil.name());
        }
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<HierarquiaDTO> findHierarquiaDto(EstruturaUsuario estruturaUsuario, String filtername, List<String> filterTags, List<String> perfil, Set<Equipe> equipe, Boolean onlyActives) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT h.estrutura_usuario_filho_id as estrutura_usuario_id,usu.nome as usuario_nome,usu.login,usu.perfil,");
        sql.append(" eq.nome as equipe_nome,eu.ativo ,usu.id usuario_id,if (usu.tags is null,'',usu.tags) tags,eu.rules,usu.email,usu.master,usu.celular");
        sql.append(" FROM hierarquia h");
        sql.append(" join estrutura_usuario eu on (h.estrutura_usuario_filho_id=eu.id)");
        sql.append(" join usuario usu on (eu.usuario_id=usu.id) ");
        sql.append(" left join equipe eq on (eu.equipe_id=eq.id)");
        sql.append(" WHERE h.estrutura_usuario_id= :estruturaUsuario ");
        if (!filtername.isEmpty()) {
            sql.append(" AND usu.nome like :filtername");
        }
        if (onlyActives.booleanValue()) {
            sql.append(" AND eu.ativo=1");
        }
        if (perfil != null && !perfil.isEmpty()) {
            sql.append(" AND usu.perfil in :perfil");
        }
        if (equipe != null && !equipe.isEmpty()) {
            HashSet<Long> ids = new HashSet<Long>();
            for (Equipe e : equipe) {
                ids.add(e.getId());
            }
            sql.append(" AND find_in_set(eu.equipe_id,'").append(StringUtils.join(ids, (String)",")).append("')");
        }
        if (filterTags != null && !filterTags.isEmpty()) {
            sql.append(" AND (");
            for (int i = 0; i < filterTags.size(); ++i) {
                sql.append("find_in_set('").append(filterTags.get(i)).append("',usu.tags)");
                if (i >= filterTags.size() - 1) continue;
                sql.append(" AND ");
            }
            sql.append(")");
        }
        sql.append(" order by usu.nome");
        Query query = this.manager.createNativeQuery(sql.toString(), HierarquiaDTO.class);
        if (!filtername.isEmpty()) {
            query.setParameter("filtername", (Object)("%" + filtername + "%"));
        }
        if (perfil != null && !perfil.isEmpty()) {
            query.setParameter("perfil", perfil);
        }
        query.setParameter("estruturaUsuario", (Object)estruturaUsuario.getId());
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<HierarquiaDTO> findOutHierarquiaDto(EstruturaUsuario estruturaUsuario, String filtername, List<String> filterTags, List<String> perfil, Set<Equipe> equipe, Boolean onlyActives) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT eu.id as estrutura_usuario_id,usu.nome as usuario_nome,usu.login,usu.perfil,");
        sql.append(" eq.nome as equipe_nome,eu.ativo ,usu.id usuario_id,if (usu.tags is null,'',usu.tags) tags,eu.rules,usu.email,usu.master,usu.celular");
        sql.append(" FROM estrutura_usuario eu ");
        sql.append(" join usuario usu on (eu.usuario_id=usu.id) ");
        sql.append(" left join equipe eq on (eu.equipe_id=eq.id)");
        sql.append(" WHERE eu.id not in (select estrutura_usuario_filho_id from hierarquia where estrutura_usuario_id=:estruturaUsuarioId)");
        sql.append(" AND eu.estrutura_id=:estruturaId");
        if (onlyActives.booleanValue()) {
            sql.append(" AND eu.ativo=1");
        }
        if (equipe != null && equipe.size() > 0) {
            HashSet<Long> ids = new HashSet<Long>();
            for (Equipe e : equipe) {
                ids.add(e.getId());
            }
            sql.append(" AND find_in_set(eu.equipe_id,'").append(StringUtils.join(ids, (String)",")).append("')");
        }
        if (!filtername.isEmpty()) {
            sql.append(" AND usu.nome like :filtername");
        }
        if (perfil != null && !perfil.isEmpty()) {
            sql.append(" AND find_in_set(usu.perfil,:perfil)");
        }
        if (filterTags != null && !filterTags.isEmpty()) {
            sql.append(" AND (");
            for (int i = 0; i < filterTags.size(); ++i) {
                sql.append("find_in_set('").append(filterTags.get(i)).append("',usu.tags)");
                if (i >= filterTags.size() - 1) continue;
                sql.append(" AND ");
            }
            sql.append(")");
        }
        sql.append(" order by usu.nome");
        Query query = this.manager.createNativeQuery(sql.toString(), HierarquiaDTO.class);
        if (!filtername.isEmpty()) {
            query.setParameter("filtername", (Object)("%" + filtername + "%"));
        }
        if (perfil != null && !perfil.isEmpty()) {
            query.setParameter("perfil", perfil);
        }
        query.setParameter("estruturaUsuarioId", (Object)estruturaUsuario.getId());
        query.setParameter("estruturaId", (Object)estruturaUsuario.getEstrutura().getId());
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<HierarquiaDTO> findByEstruturaAndAtivo(Estrutura estrutura, Boolean ativo) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT eu.id as estrutura_usuario_id,usu.nome as usuario_nome,usu.login,usu.perfil,");
        sql.append(" eq.nome as equipe_nome,eu.ativo ,usu.id usuario_id,if (usu.tags is null,'',usu.tags) tags,eu.rules,usu.email,usu.master,usu.celular");
        sql.append(" FROM estrutura_usuario eu");
        sql.append(" join usuario usu on (eu.usuario_id=usu.id) ");
        sql.append(" left join equipe eq on (eu.equipe_id=eq.id)");
        sql.append(" WHERE eu.estrutura_id=:estruturaId");
        sql.append(" AND eu.ativo=:ativo");
        sql.append(" order by usu.nome");
        Query query = this.manager.createNativeQuery(sql.toString(), HierarquiaDTO.class);
        query.setParameter("estruturaId", (Object)estrutura.getId());
        query.setParameter("ativo", (Object)ativo);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<HierarquiaDTO> findByEstruturaAndAtivoAndPerfil(Estrutura estrutura, Boolean ativo, UsuarioPerfilEnum perfil) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT eu.id as estrutura_usuario_id,usu.nome as usuario_nome,usu.login,usu.perfil,");
        sql.append(" eq.nome as equipe_nome,eu.ativo ,usu.id usuario_id,if (usu.tags is null,'',usu.tags) tags,eu.rules,usu.email,usu.master,usu.celular");
        sql.append(" FROM estrutura_usuario eu");
        sql.append(" join usuario usu on (eu.usuario_id=usu.id) ");
        sql.append(" left join equipe eq on (eu.equipe_id=eq.id)");
        sql.append(" WHERE eu.estrutura_id=:estruturaId");
        sql.append(" AND usu.perfil=:perfil");
        sql.append(" AND eu.ativo=:ativo");
        sql.append(" order by usu.nome");
        Query query = this.manager.createNativeQuery(sql.toString(), HierarquiaDTO.class);
        query.setParameter("estruturaId", (Object)estrutura.getId());
        query.setParameter("ativo", (Object)ativo);
        query.setParameter("perfil", (Object)perfil.name());
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<HierarquiaDTO> findByEstrutura(Estrutura estrutura) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT eu.id as estrutura_usuario_id,usu.nome as usuario_nome,usu.login,usu.perfil,");
        sql.append(" eq.nome as equipe_nome,eu.ativo ,usu.id usuario_id,if (usu.tags is null,'',usu.tags) tags,eu.rules,usu.email,usu.master,usu.celular");
        sql.append(" FROM estrutura_usuario eu");
        sql.append(" join usuario usu on (eu.usuario_id=usu.id) ");
        sql.append(" left join equipe eq on (eu.equipe_id=eq.id)");
        sql.append(" WHERE eu.estrutura_id=:estruturaId");
        sql.append(" order by usu.nome");
        Query query = this.manager.createNativeQuery(sql.toString(), HierarquiaDTO.class);
        query.setParameter("estruturaId", (Object)estrutura.getId());
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<HierarquiaDTO> findRamais(Estrutura estrutura) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT eu.id as estrutura_usuario_id,usu.nome as usuario_nome,usu.login,usu.perfil,");
        sql.append(" eq.nome as equipe_nome,eu.ativo ,usu.id usuario_id,if (usu.tags is null,'',usu.tags) tags,eu.rules,usu.email,usu.master,usu.celular");
        sql.append(" FROM estrutura_usuario eu");
        sql.append(" join usuario usu on (eu.usuario_id=usu.id) ");
        sql.append(" left join equipe eq on (eu.equipe_id=eq.id)");
        sql.append(" WHERE eu.estrutura_id=:estruturaId");
        sql.append(" AND usu.ramal is not null");
        Query query = this.manager.createNativeQuery(sql.toString(), HierarquiaDTO.class);
        query.setParameter("estruturaId", (Object)estrutura.getId());
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<EstruturaUsuarioSimplifyDTO> findSessaoAtiva(Estrutura estrutura, Equipe equipe, String nomeOuLogin) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT eu.id,e.id estrutura_id,u.id usuario_id,u.login,u.nome,u.email,u.master,eu.ativo,equipe.nome equipe_nome");
        sql.append(" FROM estrutura_usuario eu");
        sql.append(" join estrutura e on (eu.estrutura_id=e.id)");
        sql.append(" join usuario u on (eu.usuario_id=u.id)");
        sql.append(" join sessions s on (eu.id=s.estrutura_usuario_id)");
        sql.append(" left join equipe on (eu.equipe_id=equipe.id)");
        sql.append(" WHERE s.last_heartbeat >='").append(LocalDateTime.now().minusMinutes(7L)).append("'");
        sql.append(" AND eu.estrutura_id=:estruturaId");
        if (equipe != null) {
            sql.append(" AND eu.equipe_id=:equipeId");
        }
        if (nomeOuLogin != null && !nomeOuLogin.isEmpty()) {
            sql.append(" AND (u.nome like :nomeOuLogin or u.login like :nomeOuLogin)");
        }
        sql.append(" group by eu.id");
        Query query = this.manager.createNativeQuery(sql.toString(), EstruturaUsuarioSimplifyDTO.class);
        query.setParameter("estruturaId", (Object)estrutura.getId());
        if (equipe != null) {
            query.setParameter("equipeId", (Object)equipe.getId());
        }
        if (nomeOuLogin != null && !nomeOuLogin.isEmpty()) {
            query.setParameter("nomeOuLogin", (Object)("%" + nomeOuLogin + "%"));
        }
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<HierarquiaDTO> findUsuarioNaHierarquia(Long euId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT h.estrutura_usuario_id as estrutura_usuario_id,usu.nome as usuario_nome,usu.login,usu.perfil,");
        sql.append(" eq.nome as equipe_nome,eu.ativo ,usu.id usuario_id,if (usu.tags is null,'',usu.tags) tags,eu.rules,usu.email,usu.master,usu.celular");
        sql.append(" FROM hierarquia h");
        sql.append(" join estrutura_usuario eu on (h.estrutura_usuario_id=eu.id)");
        sql.append(" join usuario usu on (eu.usuario_id=usu.id) ");
        sql.append(" left join equipe eq on (eu.equipe_id=eq.id)");
        sql.append(" WHERE h.estrutura_usuario_filho_id= :euId ");
        Query query = this.manager.createNativeQuery(sql.toString(), HierarquiaDTO.class);
        query.setParameter("euId", (Object)euId);
        return query.getResultList();
    }

    @Transactional
    @Modifying
    public void deleteHierarquiaByEstrutura(Estrutura estrutura) {
        StringBuilder sql = new StringBuilder("select eu.id from estrutura_usuario where estrutura_id=:estruturaId ");
        Query q = this.manager.createNativeQuery(sql.toString());
        q.setParameter("estruturaId", (Object)estrutura.getId());
        q.setHint("org.hibernate.readOnly", (Object)true);
        try (Stream stream = q.getResultStream();){
            stream.forEach(e -> {
                Query queryDelete = this.manager.createNativeQuery("delete from hierarquia where estrutura_usuario_id=euId");
                queryDelete.setParameter("euId", (Object)((Long)e));
                queryDelete.executeUpdate();
            });
        }
    }
}

