/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.kanbanpedidos;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.InformationDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.view.ClienteContatoView;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.kanbanpedidos.KanbanColunaView;
import br.com.system.app.features.kanbanpedidos.model.KanbanListenerDTO;
import br.com.system.app.features.kanbanpedidos.model.KanbanPedidos;
import br.com.system.app.features.kanbanpedidos.model.KanbanViewDTO;
import br.com.system.app.features.kanbanpedidos.service.KanbanPedidosService;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.TextColor;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.layout.util.BorderStyle;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.pedido.dto.PedidoSlaENUM;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.dto.TagOptionEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.service.LeadTypeEnum;
import br.com.system.app.features.pedido.service.PedidoAnexoService;
import br.com.system.app.features.pedido.service.PedidoLogService;
import br.com.system.app.features.pedido.service.PedidoMovimentacaoService;
import br.com.system.app.features.pedido.service.PedidoNotificacaoService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.app.features.pedido.view.PedidoAnexoView;
import br.com.system.app.features.pedido.view.PedidoMovimentacaoView;
import br.com.system.app.features.pedido.view.atividade.AtividadeNotificationView;
import br.com.system.app.features.pedido.view.atividade.AtividadeView;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoFilter;
import br.com.system.app.features.producaopainel.service.ProducaoPainelService;
import br.com.system.app.features.produto.model.Produto;
import br.com.system.app.features.produto.model.ProdutoOrigem;
import br.com.system.app.features.produto.service.ProdutoService;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.model.UsuarioTag;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.usuario.service.UsuarioTagService;
import br.com.system.app.features.whatsapp.WhatsAppAtendimentoCreate;
import br.com.system.app.features.whatsapp.WhatsAppViewDialog;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppControle;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppSessao;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppCheckMessage;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.dnd.DragSource;
import com.vaadin.flow.component.dnd.DropTarget;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.Autocomplete;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import jakarta.annotation.security.PermitAll;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Route(value="kanban", layout=MainLayout.class)
@PageTitle(value="Kanban Atividades")
@PermitAll
public class KanbanView
extends ViewFrame {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(KanbanView.class);
    private final PedidoService pedidoService;
    private final EquipeService equipeService;
    private final PedidoAnexoService pedidoAnexoService;
    private final KanbanPedidosService kanbanPedidosService;
    private final UsuarioHierarquiaService hierarquiaService;
    private final ProducaoPainelService pps;
    private final PedidoTagsService pedidoTagsService;
    private final UsuarioTagService usuarioTagService;
    private final PedidoMovimentacaoService pedidoMovimentacaoService;
    private final AtividadeView atividadeView;
    private final PedidoNotificacaoService pedidoNotificacaoService;
    private final PedidoLogService pedidoLogService;
    private final WhatsAppViewDialog whatsAppViewDialog;
    private final WhatsAppAtendimentoService whatsAppAtendimentoService;
    private final UsuarioService usuarioService;
    private final WhatsAppCheckMessage whatsAppCheckMessage;
    private final WhatsAppService whatsAppService;
    private final WhatsAppAtendimentoCreate whatsAppAtendimentoCreate;
    private final ClienteContatoView clienteContatoView;
    private final WhatsAppControleService whatsAppControleService;
    private final ProdutoService produtoService;
    private ProdutoOrigem po = ProdutoOrigem.NEOCRM;
    private ComboBox<HierarquiaDTO> cbVerFila;
    private ComboBox<HierarquiaDTO> cbFiltroUsuario;
    private ListField filterCnpj;
    private MultiComboBox<PedidoTags> cbTags;
    private ComboBox<TagOptionEnum> cbTagOption;
    private MultiComboBox<UsuarioTag> cbUsuarioTags;
    private MultiComboBox<Equipe> cbEquipe;
    private RadioButtonGroup<PedidoTipoEnum> rbTipo;
    private PedidoTipoEnum tipoSetado;
    private DatePicker dataNotificacao;
    private Checkbox cbNotificacao;
    private TextField nomeCliente;
    private HorizontalContainer contentContainer;
    private List<KanbanPedidos> kanbanList;
    private Button fireGreenFilter;
    private Button fireRedFilter;
    private Integer indicePedido = 0;
    private Boolean ordenacaoAsc = false;
    private Set<Long> listaNotificacoes;
    private List<ProducaoPedidoDTO> listaAutomatica;
    private List<KanbanViewDTO> listaCards;
    private Long pedidoIdAberto;
    private WhatsAppSessao sessao;
    private final EstruturaUsuario eu;
    private Registration whatsRegistration;
    private Integer totalNovas = 0;
    private Registration openListner;
    private Checkbox cbOnlyActives;
    private List<Produto> produtos;
    private DatePicker dataInicialAtualizacao;
    private DatePicker dataFinalAtualizacao;
    private Registration broadcasterRegistration;

    public KanbanView(PedidoService pedidoService, EquipeService equipeService, PedidoAnexoService pedidoAnexoService, KanbanPedidosService kanbanPedidosService, UsuarioHierarquiaService hierarquiaService, ProducaoPainelService pps, PedidoTagsService pedidoTagsService, PedidoMovimentacaoService pedidoMovimentacaoService, AtividadeView atividadeView, PedidoNotificacaoService pedidoNotificacaoService, UsuarioTagService usuarioTagService, PedidoLogService pedidoLogService, WhatsAppViewDialog whatsAppViewDialog, WhatsAppAtendimentoService whatsAppAtendimentoService, UsuarioService usuarioService, WhatsAppCheckMessage whatsAppCheckMessage, WhatsAppService whatsAppService, WhatsAppAtendimentoCreate whatsAppAtendimentoCreate, WhatsAppControleService whatsAppControleService, ClienteContatoView clienteContatoView, ProdutoService produtoService) {
        this.pedidoService = pedidoService;
        this.produtoService = produtoService;
        this.clienteContatoView = clienteContatoView;
        this.whatsAppAtendimentoCreate = whatsAppAtendimentoCreate;
        this.whatsAppControleService = whatsAppControleService;
        this.whatsAppService = whatsAppService;
        this.usuarioService = usuarioService;
        this.whatsAppCheckMessage = whatsAppCheckMessage;
        this.whatsAppAtendimentoService = whatsAppAtendimentoService;
        this.pedidoLogService = pedidoLogService;
        this.whatsAppViewDialog = whatsAppViewDialog;
        this.usuarioTagService = usuarioTagService;
        this.pedidoNotificacaoService = pedidoNotificacaoService;
        this.equipeService = equipeService;
        this.pedidoAnexoService = pedidoAnexoService;
        this.kanbanPedidosService = kanbanPedidosService;
        this.hierarquiaService = hierarquiaService;
        this.pps = pps;
        this.pedidoTagsService = pedidoTagsService;
        this.pedidoMovimentacaoService = pedidoMovimentacaoService;
        this.atividadeView = atividadeView;
        this.tipoSetado = null;
        this.eu = this.getEu();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.create());
            this.updateContent();
            this.setWhatsOnline();
            this.povoaProdutos();
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.setWhatsOffLine();
        this.clear();
    }

    private void clear() {
        if (this.whatsRegistration != null) {
            this.whatsRegistration.remove();
        }
        if (this.openListner != null) {
            this.openListner.remove();
        }
        if (this.broadcasterRegistration != null) {
            this.broadcasterRegistration.remove();
            this.broadcasterRegistration = null;
        }
    }

    private void monitoramento(boolean ativar) {
        this.whatsAppCheckMessage.setDetachEu(Boolean.valueOf(!ativar));
        this.whatsAppCheckMessage.checkNewMessages(this.eu, arg_0 -> this.listenerAlteracaoMensagem(arg_0));
    }

    private void setWhatsOnline() {
        if (((PedidoTipoEnum)this.rbTipo.getValue()).equals((Object)PedidoTipoEnum.WHATSAPP)) {
            this.sessao = this.whatsAppService.setOnline(this.eu);
            this.whatsAppAtendimentoService.checkPool(this.eu);
            this.monitoramento(true);
            this.whatsOppenedRegistration();
        } else {
            this.setWhatsOffLine();
        }
    }

    private void setWhatsOffLine() {
        this.whatsAppService.setOffline(this.sessao);
        this.whatsAppCheckMessage.setDetachEu(Boolean.valueOf(true));
    }

    private void setTitle(Integer valor) {
        int n;
        if (valor == 0) {
            n = 0;
        } else {
            this.totalNovas = this.totalNovas + valor;
            n = this.totalNovas;
        }
        this.totalNovas = n;
        if (this.totalNovas > 0) {
            UI.getCurrent().getPage().executeJs("document.title='(" + this.totalNovas + ") Kanban Atividades'", new Serializable[0]);
        } else {
            UI.getCurrent().getPage().executeJs("document.title='Kanban Atividades'", new Serializable[0]);
        }
    }

    private void listenerAlteracaoMensagem(WhatsAppControle c) {
        try {
            if (!this.getUI().isPresent()) {
                return;
            }
            ((UI)this.getUI().get()).access((Command & Serializable)() -> {
                try {
                    WhatsAppMensagem m = c.getWhatsappMensagem();
                    boolean achei = false;
                    for (KanbanViewDTO d : this.listaCards) {
                        if (!d.getAtividadeId().equals(m.getWhatsappAtendimento().getPedido().getId())) continue;
                        if (this.pedidoIdAberto != null && d.getAtividadeId().equals(this.pedidoIdAberto)) {
                            return;
                        }
                        achei = true;
                        d.getColuna().getContainer().remove(new Component[]{d.getCard()});
                        d.getColuna().getContainer().addComponentAsFirst((Component)d.getCard());
                        if (d.getCard().getStyle().get("background-color") == null) {
                            this.setTitle(Integer.valueOf(1));
                            d.getCard().setBackgroundColor(Color.LIGHTYELLOW);
                        }
                        d.getCard().getChildren().forEach(children -> {
                            if (children.getId().isPresent() && ((String)children.getId().get()).equals("btnWhats")) {
                                children.getChildren().forEach(e -> {
                                    if (e.getId().isPresent() && ((String)e.getId().get()).equals("btnWhats")) {
                                        e.setVisible(true);
                                        Button b = (Button)e;
                                        b.setIcon((Component)this.getImageNewMessage());
                                    }
                                });
                            }
                        });
                        break;
                    }
                    if (!achei) {
                        this.updateContent();
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Component create() {
        this.listaCards = new ArrayList();
        if (this.tipoSetado == null) {
            this.tipoSetado = this.getUsuario().getTipoPedidoDefault();
        }
        this.cbOnlyActives = new Checkbox("Somente Ativos");
        this.cbOnlyActives.setValue((Object)true);
        this.cbOnlyActives.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.povoaHierarquia((Boolean)e.getValue()));
        VerticalContainer container = new VerticalContainer(new Component[0]);
        this.dataInicialAtualizacao = new DatePicker();
        this.dataInicialAtualizacao.setId("dataInicialAtualizacao");
        this.dataInicialAtualizacao.setLabel("Data Inicial");
        this.dataInicialAtualizacao.setValue(LocalDate.now().minusDays(90L));
        this.dataInicialAtualizacao.setLocale(UIUtils.getLocale());
        this.dataFinalAtualizacao = new DatePicker();
        this.dataFinalAtualizacao.setId("dataFinalAtualizacao");
        this.dataFinalAtualizacao.setLabel("Data Final");
        this.dataFinalAtualizacao.setValue(LocalDate.now());
        this.dataFinalAtualizacao.setLocale(UIUtils.getLocale());
        Icon greenIcon = new Icon(VaadinIcon.FIRE);
        greenIcon.setColor(Color.GREEN.getValue());
        Icon redIcon = new Icon(VaadinIcon.FIRE);
        redIcon.setColor(Color.RED.getValue());
        this.fireGreenFilter = UIUtils.createButton((Icon)greenIcon, (String)"Filtrar atividades NO PRAZO", (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.fireGreenFilter.setDisableOnClick(true);
        this.fireRedFilter = UIUtils.createButton((Icon)redIcon, (String)"Filtrar atividades FORA DO PRAZO", (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.fireRedFilter.setDisableOnClick(true);
        this.fireGreenFilter.addClickListener((ComponentEventListener & Serializable)e -> {
            this.fireGreenFilter.setText("Selecionado");
            this.fireRedFilter.setText("");
            this.updateContent(PedidoSlaENUM.NO_PRAZO, null);
            this.fireGreenFilter.setEnabled(true);
        });
        this.fireRedFilter.addClickListener((ComponentEventListener & Serializable)e -> {
            this.updateContent(PedidoSlaENUM.FORA_DO_PRAZO, null);
            this.fireRedFilter.setText("Selecionado");
            this.fireGreenFilter.setText("");
            this.fireRedFilter.setEnabled(true);
        });
        this.contentContainer = new HorizontalContainer(new Component[0]);
        this.contentContainer.setAlignItems(FlexComponent.Alignment.START);
        Button btnAdd = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Criar nova atividade");
        btnAdd.addClickListener((ComponentEventListener & Serializable)e -> {
            if (((PedidoTipoEnum)this.rbTipo.getValue()).equals((Object)PedidoTipoEnum.WHATSAPP)) {
                this.criarWhats();
            } else {
                this.abrePedido(null);
            }
            btnAdd.setEnabled(true);
        });
        btnAdd.setDisableOnClick(true);
        this.rbTipo = new RadioButtonGroup();
        if (this.isWhatsapp()) {
            this.rbTipo.setItems((Object[])new PedidoTipoEnum[]{PedidoTipoEnum.WHATSAPP});
        } else {
            this.rbTipo.setItems((Object[])PedidoTipoEnum.values());
        }
        this.rbTipo.setValue((Object)this.tipoSetado);
        UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{this.rbTipo});
        this.rbTipo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.cbTags.setItems((Collection)this.pedidoTagsService.getTags(this.getEstrutura(), (PedidoTipoEnum)this.rbTipo.getValue()));
            this.tipoSetado = (PedidoTipoEnum)e.getValue();
            this.updateContent();
            this.usuarioService.setTipoPedidoDefault(this.getUsuario(), (PedidoTipoEnum)e.getValue());
            this.getUsuario().setTipoPedidoDefault(this.tipoSetado);
            this.setWhatsOnline();
            this.povoaProdutos();
        });
        this.cbVerFila = new ComboBox("Ver fila Usu\u00e1rio");
        this.cbVerFila.setItemLabelGenerator(HierarquiaDTO::getUsuarioELogin);
        this.cbVerFila.setMinWidth("300px");
        this.cbFiltroUsuario = new ComboBox("Filtrar Usu\u00e1rio");
        this.cbFiltroUsuario.setItemLabelGenerator(HierarquiaDTO::getUsuarioELogin);
        this.cbFiltroUsuario.setMinWidth("300px");
        this.filterCnpj = new ListField(ListFieldTypeEnum.CPF_CNPJ, "Lista Cnpj");
        this.cbTags = new MultiComboBox("Tags Atividade", (Collection)this.pedidoTagsService.getTags(this.getEstrutura(), (PedidoTipoEnum)this.rbTipo.getValue()));
        this.cbTags.setItemLabelGenerator(PedidoTags::getTagAndCategoria);
        this.cbTagOption = new ComboBox("Op\u00e7\u00e3o");
        this.cbTagOption.setWidth("80px");
        this.cbTagOption.setItemLabelGenerator(Enum::name);
        this.cbTagOption.setItems((Object[])TagOptionEnum.values());
        this.cbTagOption.setValue((Object)TagOptionEnum.OU);
        this.cbUsuarioTags = new MultiComboBox("Tags Usu\u00e1rio", (Collection)this.usuarioTagService.getTags(this.getEstrutura()));
        this.cbUsuarioTags.setItemLabelGenerator(UsuarioTag::getTag);
        this.nomeCliente = new TextField("Nome Cliente(Inicio)");
        this.nomeCliente.setAutocomplete(Autocomplete.OFF);
        this.cbEquipe = new MultiComboBox("Equipe");
        if (this.hasPermission("EQUIPE_VISUALIZACAO_RESTRITA") && !this.isMaster()) {
            if (this.getEu().getEquipe() != null) {
                this.cbEquipe.setItems((Object[])new Equipe[]{this.getEu().getEquipe()});
            }
        } else {
            this.cbEquipe.setItems((Collection)this.equipeService.getEquipes(this.getEstrutura()));
        }
        this.cbEquipe.setItemLabelGenerator(Equipe::getNome);
        this.dataNotificacao = new DatePicker();
        this.dataNotificacao.setEnabled(false);
        this.dataNotificacao.setLabel("Notifica\u00e7\u00e3o");
        this.dataNotificacao.setValue(LocalDate.now());
        this.dataNotificacao.setLocale(UIUtils.getLocale());
        this.dataNotificacao.setWidth("130px");
        this.cbNotificacao = new Checkbox();
        this.cbNotificacao.getElement().setProperty("title", "Seleciona apenas atividades marcadas com a data selecionada");
        this.cbNotificacao.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (((Boolean)e.getValue()).booleanValue()) {
                this.dataNotificacao.setEnabled(true);
                this.dataNotificacao.setValue(LocalDate.now());
            } else {
                this.dataNotificacao.setValue(null);
                this.dataNotificacao.setEnabled(false);
            }
        });
        Button btnOrdenacaoAsc = UIUtils.createSmallButton((String)"Crescente", (VaadinIcon)VaadinIcon.SEARCH, (String)"Mais Antigos primeiro");
        btnOrdenacaoAsc.setDisableOnClick(true);
        btnOrdenacaoAsc.addClickListener((ComponentEventListener & Serializable)e -> {
            this.ordenacaoAsc = true;
            this.updateContent();
            btnOrdenacaoAsc.setEnabled(true);
        });
        Button btnOrdenacaoDesc = UIUtils.createSmallButton((String)"Decrescente", (VaadinIcon)VaadinIcon.SEARCH, (String)"Mais Novos Primeiro");
        btnOrdenacaoDesc.setDisableOnClick(true);
        btnOrdenacaoDesc.addClickListener((ComponentEventListener & Serializable)e -> {
            this.ordenacaoAsc = false;
            this.updateContent();
            btnOrdenacaoDesc.setEnabled(true);
        });
        Button btnClear = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.RECYCLE, (String)"Limpar campos de pesquisa");
        btnClear.addClickListener((ComponentEventListener & Serializable)e -> {
            this.cbVerFila.clear();
            this.cbFiltroUsuario.clear();
            this.filterCnpj.clear();
            this.cbTags.clear();
            this.nomeCliente.clear();
            this.cbUsuarioTags.clear();
            this.cbEquipe.clear();
            this.fireRedFilter.setText("");
            this.fireGreenFilter.setText("");
        });
        this.povoaHierarquia(Boolean.valueOf(true));
        HorizontalContainer cvTag = new HorizontalContainer(new Component[]{this.cbTags, this.cbTagOption});
        UIUtils.setBorder((BorderStyle)BorderStyle.SOLID, (String)"1px", (Component[])new Component[]{cvTag});
        container.add(new Component[]{new HorizontalContainer(new Component[]{this.rbTipo, this.cbEquipe, this.cbOnlyActives, this.cbVerFila, this.cbFiltroUsuario, this.filterCnpj, cvTag, this.cbUsuarioTags, this.nomeCliente, new HorizontalContainer(new Component[]{this.dataNotificacao, this.cbNotificacao}), this.dataInicialAtualizacao, this.dataFinalAtualizacao, btnOrdenacaoAsc, btnOrdenacaoDesc, btnClear, this.fireGreenFilter, this.fireRedFilter, btnAdd}), this.contentContainer});
        return container;
    }

    private void povoaHierarquia(Boolean value) {
        List hierarquia = this.hierarquiaService.getHierarquiaDto(this.eu, "", value);
        this.cbVerFila.setItems((Collection)hierarquia);
        this.cbFiltroUsuario.setItems((Collection)hierarquia);
    }

    private void updateContent() {
        this.updateContent(null, null);
    }

    private void updateContent(PedidoSlaENUM sla, KanbanPedidos kp) {
        if (this.nomeCliente.getValue() != null && !this.nomeCliente.getValue().isEmpty() && this.nomeCliente.getValue().length() < 3) {
            this.showNotification("Nome do cliente deve ter pelo menos 3 letras");
            return;
        }
        if (this.dataInicialAtualizacao.getValue() == null || this.dataFinalAtualizacao.getValue() == null) {
            this.showNotification("Data inicial e final \u00e9 obrigat\u00f3ria");
            return;
        }
        if (DateTimeUtil.diferencaEmDias((LocalDate)((LocalDate)this.dataInicialAtualizacao.getValue()), (LocalDate)((LocalDate)this.dataFinalAtualizacao.getValue())) > 91L) {
            this.showNotification("Range de datas, m\u00e1ximo de 90 dias");
            return;
        }
        this.clear();
        this.listaCards.clear();
        this.listaNotificacoes = this.getNotificacoes();
        Long euId = this.cbVerFila.getValue() == null ? this.eu.getId() : ((HierarquiaDTO)this.cbVerFila.getValue()).getEstruturaUsuarioId();
        HashSet<Long> el = new HashSet<Long>();
        for (Equipe e : this.cbEquipe.getValue()) {
            el.add(e.getId());
        }
        Set<Object> hierarquia = this.cbFiltroUsuario.getValue() != null ? new HashSet<Long>(Arrays.asList(((HierarquiaDTO)this.cbFiltroUsuario.getValue()).getEstruturaUsuarioId())) : (this.hasPermission("IGNORAR_HIERARQUIA") ? new HashSet() : (this.hasPermission("KANBAN_VER_HIERARQUIA") || !el.isEmpty() || this.eu.getUsuario().getPerfil().equals((Object)UsuarioPerfilEnum.ADMINISTRATIVO) || this.eu.getUsuario().getPerfil().equals((Object)UsuarioPerfilEnum.PROPRIETARIO) ? this.hierarquiaService.getHierarquia(euId) : new HashSet<Long>(Arrays.asList(euId))));
        this.contentContainer.removeAll();
        this.kanbanList = this.kanbanPedidosService.getKanban(euId, (PedidoTipoEnum)this.rbTipo.getValue());
        if (kp != null) {
            this.consultar(kp, sla, hierarquia, el);
        } else {
            for (KanbanPedidos k : this.kanbanList) {
                this.consultar(k, sla, hierarquia, el);
            }
        }
    }

    private void consultar(KanbanPedidos kp, PedidoSlaENUM sla, Set<Long> hierarquia, Set<Long> el) {
        this.setTitle(Integer.valueOf(0));
        HashSet<Long> sl = new HashSet<Long>();
        sl.add(kp.getPedidoEtapa().getId());
        ProducaoPedidoFilter ppf = new ProducaoPedidoFilter(this.eu.getEstrutura(), el, hierarquia, sl, this.filterCnpj.getValue(), this.cbTags.getValue(), (PedidoTipoEnum)this.rbTipo.getValue(), this.cbUsuarioTags.getValue(), this.nomeCliente.getValue(), (Boolean)this.cbNotificacao.getValue() != false && this.dataNotificacao.getValue() != null ? (LocalDate)this.dataNotificacao.getValue() : null, sla);
        ppf.setKanban(true);
        ppf.setTagOptionEnum((TagOptionEnum)this.cbTagOption.getValue());
        ppf.setDataInicialAtualizacao((LocalDate)this.dataInicialAtualizacao.getValue());
        ppf.setDataFinalAtualizacao((LocalDate)this.dataFinalAtualizacao.getValue());
        KanbanColunaView main = this.createKanbanCol(kp);
        this.contentContainer.add(new Component[]{main});
        this.contentContainer.setFlexGrow(0.0, new HasElement[]{main});
        KanbanListenerDTO dto = new KanbanListenerDTO();
        dto.setMain(main);
        dto.setAsc(this.ordenacaoAsc);
        dto.setFilter(ppf);
        dto.setKp(kp);
        dto.setPaginaAtual(Integer.valueOf(0));
        main.getBtnPrev().addClickListener((ComponentEventListener & Serializable)e -> {
            if (main.getDto().getPaginaAtual() > 0) {
                main.clearColumn();
                main.getTextoInicial().setText("carregando...");
                main.getTextoInicial().setVisible(true);
                main.getDto().setPaginaAtual(Integer.valueOf(main.getDto().getPaginaAtual() - 1));
                this.pps.getProducaoByPedido(this.getEu(), main.getDto(), arg_0 -> this.createKanban(arg_0));
            }
        });
        main.getBtnNext().addClickListener((ComponentEventListener & Serializable)e -> {
            main.clearColumn();
            main.getTextoInicial().setVisible(true);
            if (main.getDto() != null && main.getDto().getPaginaAtual() != null) {
                main.getDto().setPaginaAtual(Integer.valueOf(main.getDto().getPaginaAtual() + 1));
                this.pps.getProducaoByPedido(this.getEu(), main.getDto(), arg_0 -> this.createKanban(arg_0));
            }
        });
        main.getBtnCount().addClickListener((ComponentEventListener & Serializable)e -> main.setLabel(this.pps.countProducaoByPedido(this.getEu(), dto)));
        this.pps.getProducaoByPedido(this.getEu(), dto, arg_0 -> this.createKanban(arg_0));
    }

    public void createKanban(KanbanListenerDTO dto) {
        try {
            if (!this.getUI().isPresent()) {
                return;
            }
            ((UI)this.getUI().get()).access((Command & Serializable)() -> {
                try {
                    this.createColumn(dto);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createColumn(KanbanListenerDTO dto) {
        KanbanPedidos kp = dto.getKp();
        KanbanColunaView main = dto.getMain();
        List lista = dto.getLista();
        if (dto.getPaginaAtual() <= 0) {
            main.getBtnPrev().setEnabled(false);
        } else {
            main.getBtnPrev().setEnabled(true);
        }
        main.setDto(dto);
        if (dto.getLista().size() <= 0) {
            main.getTextoInicial().setVisible(true);
            main.getTextoInicial().setText("Sem mais itens");
        } else {
            main.getTextoInicial().setVisible(false);
            main.getBtnNext().setEnabled(true);
        }
        main.getBtnAuto().addClickListener((ComponentEventListener & Serializable)e -> {
            if (lista.size() <= 0) {
                this.showNotification("N\u00e3o h\u00e1 atividades nessa fila");
                return;
            }
            this.indicePedido = 0;
            Pedido ped = this.pedidoService.getById(((ProducaoPedidoDTO)lista.get(this.indicePedido)).getId());
            this.abrePedido(ped, lista);
        });
        Collections.sort(lista, new /* Unavailable Anonymous Inner Class!! */);
        LocalDateTime dataHoraAntes = null;
        for (int i = 0; i < lista.size(); ++i) {
            try {
                ProducaoPedidoDTO pedido = (ProducaoPedidoDTO)lista.get(i);
                this.proc(kp, main, pedido, dataHoraAntes);
                dataHoraAntes = pedido.getDataHoraAtualizacao();
                continue;
            }
            catch (Exception e2) {
                this.logger.error(e2.getMessage());
            }
        }
    }

    private void proc(KanbanPedidos kp, KanbanColunaView main, ProducaoPedidoDTO pedido, LocalDateTime dataHoraAntes) {
        VerticalContainer card;
        boolean isNew = false;
        if (pedido.getWhatsappAtendimentoId() != null && pedido.getWhatsappAtendimentoId() > 0L && !this.whatsAppControleService.getNova(pedido.getWhatsappAtendimentoId()).isEmpty()) {
            isNew = true;
        }
        if ((card = this.createCard(pedido, this.eu, isNew)) != null) {
            main.addCard(card, isNew);
            KanbanViewDTO k = new KanbanViewDTO();
            k.setAtividadeId(pedido.getId());
            k.setCard(card);
            k.setColuna(main);
            k.setKp(kp);
            this.listaCards.add(k);
        }
    }

    private KanbanColunaView createKanbanCol(KanbanPedidos kp) {
        KanbanColunaView main = new KanbanColunaView(kp);
        UIUtils.setShadow((Shadow)Shadow.S, (Component[])new Component[]{main});
        VerticalContainer kpContainer = main.create();
        DropTarget dropTarget = DropTarget.create((Component)main);
        dropTarget.addDropListener((ComponentEventListener & Serializable)event -> {
            event.getDragSourceComponent().ifPresent(xva$0 -> kpContainer.add(new Component[]{xva$0}));
            event.getDragData().ifPresent(data -> {
                ProducaoPedidoDTO ppd = (ProducaoPedidoDTO)data;
                KanbanPedidos kpe = (KanbanPedidos)((KanbanColunaView)event.getComponent()).getContainer().getDataObject();
                if (!kpe.getPedidoEtapa().getId().equals(ppd.getPedidoEtapaId())) {
                    this.pedidoService.alterarEtapaPedido(ppd.getId(), kpe.getPedidoEtapa(), this.eu);
                    for (KanbanViewDTO d : this.listaCards) {
                        if (!d.getAtividadeId().equals(ppd.getId())) continue;
                        d.setColuna((KanbanColunaView)event.getComponent());
                        d.getCard().getChildren().forEach(children -> {
                            if (!children.getId().isEmpty() && ((String)children.getId().get()).equals("footer")) {
                                children.getChildren().forEach(itens -> {
                                    if (!itens.getId().isEmpty() && ((String)itens.getId().get()).equals("bFire")) {
                                        Icon iconFire = new Icon(VaadinIcon.FIRE);
                                        iconFire.setColor(Color.GREEN.getValue());
                                        ((Button)itens).setIcon((Component)iconFire);
                                        UIUtils.setTooltip((String)"No Prazo ", (Component[])new Component[]{(Button)itens});
                                    }
                                });
                            }
                        });
                        break;
                    }
                }
            });
        });
        return main;
    }

    private Set<Long> getNotificacoes() {
        return this.pedidoNotificacaoService.getMarcadoByData(this.getEstrutura(), (Boolean)this.cbNotificacao.getValue() != false ? (LocalDate)this.dataNotificacao.getValue() : LocalDate.now());
    }

    private VerticalContainer createCard(ProducaoPedidoDTO pedido, EstruturaUsuario eu, boolean isNew) {
        VerticalContainer card = new VerticalContainer(new Component[0]);
        try {
            boolean haveNotification = this.haveNotificacoes(pedido);
            if (((Boolean)this.cbNotificacao.getValue()).booleanValue() && !haveNotification) {
                return null;
            }
            UIUtils.setBorder((BorderStyle)BorderStyle.DOTTED, (String)"2px", (Component[])new Component[]{card});
            card.setHeight(pedido.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP) ? "170px" : "150px");
            card.setWidth("300px");
            card.add(new Component[]{UIUtils.createHeader((String)("#" + pedido.getNumeroPedido()))});
            Span lblNome = UIUtils.createSmallSpan((String)(pedido.getCpfCnpj() + " " + pedido.getNomeCliente()));
            lblNome.setVisible(!pedido.getCpfCnpj().equals(eu.getEstrutura().getCpfCnpj()) || !pedido.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP));
            lblNome.setMaxWidth("400px");
            Span lblData = UIUtils.createSmallSpan((String)(pedido.getDataHoraAtualizacao().format(FormatDate.DATETIME_BR.toDTF()) + " " + pedido.getNomeUsuario()));
            Span lblTags = UIUtils.createBreakWrapSpan((String)pedido.getTags());
            String wNome = pedido.getWhatsappNome() != null ? pedido.getWhatsappNome() : "";
            String wLogin = pedido.getWhatsLogin() != null ? pedido.getWhatsLogin() : "";
            Span lblContato = UIUtils.createBreakWrapSpan((String)(wNome + " " + wLogin));
            lblTags.setWidth("235px");
            UIUtils.setTextColor((TextColor)TextColor.PRIMARY, (Component[])new Component[]{lblTags});
            UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{lblNome, lblData, lblTags});
            VerticalLayout lay = new VerticalLayout();
            lay.setMargin(false);
            lay.setPadding(false);
            lay.setSpacing(false);
            lay.setWidthFull();
            lay.setHeightFull();
            lay.setHeight(pedido.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP) ? "100px" : "80px");
            if (pedido.getLeadSistema() != null && pedido.getLeadSistema().equals((Object)LeadTypeEnum.HOT_LEAD)) {
                Div div = new Div();
                div.getElement().setProperty("innerHTML", "<span style=\"color: blue;\"><b><u>Enriquecido</u></b></span>");
                div.getStyle().setTextAlign(Style.TextAlign.RIGHT);
                div.setWidth("100%");
                lay.add(new Component[]{div});
            }
            if (pedido.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP) && pedido.getWhatsappNumero() != null) {
                lay.add(new Component[]{UIUtils.createSmallSpan((String)(pedido.getWhatsappNumero() + " " + (pedido.isWhatsappFechado() ? "Fechado" : "Aberto")))});
                lay.add(new Component[]{lblContato});
            }
            lay.add(new Component[]{lblNome, lblData, lblTags});
            Scroller scroller = new Scroller((Component)lay);
            scroller.setWidth("100%");
            card.add(new Component[]{scroller});
            Icon iconFire = new Icon(VaadinIcon.FIRE);
            Button bFire = UIUtils.createSmallButton((Icon)iconFire, (String)"SLA");
            bFire.setId("bFire");
            Integer tempo = pedido.getTempo() == null || !pedido.getTempo().contains(":") ? 0 : Integer.valueOf(pedido.getTempo().split(":")[0]);
            if (pedido.getTempo() != null && pedido.getSlaHoras() != null && pedido.getSlaHoras() > 0 && tempo >= pedido.getSlaHoras()) {
                iconFire.setColor(Color.RED.getValue());
                UIUtils.setTooltip((String)("Fora do Prazo. SLA " + pedido.getSlaHoras() + " TEMPO " + pedido.getTempo()), (Component[])new Component[]{bFire});
            } else if (pedido.getSlaHoras() != null) {
                iconFire.setColor(Color.GREEN.getValue());
                UIUtils.setTooltip((String)("No Prazo. SLA " + pedido.getSlaHoras() + " TEMPO " + pedido.getTempo()), (Component[])new Component[]{bFire});
            }
            Button bEdit = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Editar atividade");
            bEdit.setDisableOnClick(true);
            Button bMove = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_FORWARD, (String)"Mover a atividade");
            Button bClip = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PAPERCLIP, (String)"Anexos da atividade");
            Button bInfo = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.INFO_CIRCLE_O, (String)"Informa\u00e7\u00f5es iniciais da atividade");
            bInfo.setVisible(!pedido.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP));
            bMove.setVisible(false);
            bMove.setEnabled(this.hasPermission("KANBAN_ETAPA_CHANGE"));
            bMove.addClickListener((ComponentEventListener & Serializable)e -> this.moveEtapa(pedido, card));
            Button bRecords = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.RECORDS, (String)"Movimenta\u00e7\u00f5es da atividade");
            bRecords.addClickListener((ComponentEventListener & Serializable)e -> {
                Pedido ped = this.pedidoService.getById(pedido.getId());
                new PedidoMovimentacaoView(ped, this.pedidoMovimentacaoService, this.pedidoLogService, this.pedidoService);
            });
            bInfo.addClickListener((ComponentEventListener & Serializable)e -> InformationDialog.show((String)"Informa\u00e7\u00f5es", (String)pedido.getComplementos()));
            bClip.addClickListener((ComponentEventListener & Serializable)e -> {
                Pedido ped = this.pedidoService.getById(pedido.getId());
                new PedidoAnexoView(ped, eu, this.pedidoAnexoService);
            });
            Button bWhats = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.COMMENTS_O, (String)"Abrir conversa");
            bWhats.setId("btnWhats");
            bWhats.setVisible(pedido.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP));
            if (isNew) {
                bWhats.setIcon((Component)this.getImageNewMessage());
                this.setTitle(Integer.valueOf(1));
                card.setBackgroundColor(Color.LIGHTYELLOW);
            }
            bWhats.addClickListener((ComponentEventListener & Serializable)e -> {
                try {
                    WhatsAppAtendimento wa = this.whatsAppAtendimentoService.getById(pedido.getWhatsappAtendimentoId());
                    if (wa == null) {
                        this.whatsAppAtendimentoCreate.create(null, this.pedidoService.getById(pedido.getId()), this.getEu());
                        this.openListner = this.whatsAppAtendimentoCreate.addOpenedChangeListener((ComponentEventListener & Serializable)op -> {
                            if (!op.isOpened()) {
                                bWhats.setIcon((Component)VaadinIcon.COMMENTS_O.create());
                                WhatsAppAtendimento atendimento = this.whatsAppAtendimentoService.getByPedido(pedido.getId());
                                if (atendimento != null) {
                                    this.pedidoIdAberto = pedido.getId();
                                    this.whatsAppViewDialog.create(atendimento);
                                    this.removeNewIcon(bWhats, isNew);
                                    this.updateContent();
                                }
                            }
                        });
                    } else {
                        this.pedidoIdAberto = pedido.getId();
                        this.whatsAppViewDialog.create(wa);
                        this.removeNewIcon(bWhats, isNew);
                        UIUtils.removeBackgroundColor((Component[])new Component[]{card});
                    }
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage());
                }
            });
            Button bCloseWhats = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CLOSE, (String)"Fechar Atendimento");
            bCloseWhats.setVisible(pedido.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP) && pedido.getWhatsappAtendimentoId() != null && !pedido.isWhatsappFechado());
            bCloseWhats.addClickListener((ComponentEventListener & Serializable)e -> {
                ConfirmationDialog cd = new ConfirmationDialog("Fechar Atendimento", "Confirma fechamento do atendimento?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    this.whatsAppAtendimentoService.fechar(this.whatsAppAtendimentoService.getById(pedido.getWhatsappAtendimentoId()), this.getEu(), true);
                    cd.close();
                    bCloseWhats.setVisible(false);
                    this.updateContent();
                });
            });
            Button bClock = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CALENDAR_CLOCK, (String)"Notifica\u00e7\u00f5es da atividade");
            bClock.addClickListener((ComponentEventListener & Serializable)e -> {
                Pedido ped = this.pedidoService.getById(pedido.getId());
                AtividadeNotificationView anv = new AtividadeNotificationView(this.pedidoNotificacaoService, ped, eu);
                anv.openNotification();
                anv.addOpenedChangeListener((ComponentEventListener & Serializable)op -> {
                    if (!op.isOpened() && this.pedidoNotificacaoService.getAtividadeMarcada(pedido.getId(), LocalDate.now())) {
                        ((Button)e.getSource()).addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ERROR});
                    }
                });
            });
            Button bContatos = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PHONE_LANDLINE, (String)"Abrir contatos v\u00e1lidos do cliente");
            ((Icon)bContatos.getIcon()).setColor(Color.GREEN.getValue());
            bContatos.setEnabled(pedido.getId() != null);
            bContatos.addClickListener((ComponentEventListener & Serializable)e -> {
                Pedido ped = this.pedidoService.getById(pedido.getId());
                this.clienteContatoView.show(ped.getCliente(), ped.getId());
            });
            card.add(new Component[]{new FooterContainer(new Component[]{bFire, bEdit, bClip, bRecords, bInfo, bClock, bWhats, bCloseWhats, bContatos})});
            if (pedido.getLeadSistema() != null && pedido.getLeadSistema().equals((Object)LeadTypeEnum.RETORNO_FUTURO)) {
                card.setBackgroundColor(Color.GAINSBORO);
            }
            bEdit.addClickListener((ComponentEventListener & Serializable)e -> {
                Pedido ped = this.pedidoService.getById(pedido.getId());
                this.abrePedido(ped);
                bEdit.setEnabled(true);
            });
            DragSource dragSource = DragSource.create((Component)card);
            dragSource.setDraggable(true);
            dragSource.setDragData((Object)pedido);
            if (haveNotification) {
                bClock.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ERROR});
                if (this.dataNotificacao.getValue() == null) {
                    bClock.getElement().setProperty("title", "Atividade marcada para tratamento HOJE");
                } else {
                    bClock.getElement().setProperty("title", "Atividade marcada para tratamento " + ((LocalDate)this.dataNotificacao.getValue()).format(FormatDate.DATE_BR.toDTF()));
                }
            }
        }
        catch (Exception e2) {
            this.logger.error(e2.getMessage());
        }
        return card;
    }

    private void moveEtapa(ProducaoPedidoDTO pedido, VerticalContainer card) {
        ComboBox cbMove = new ComboBox("Fila");
        cbMove.setWidth("300px");
        cbMove.setItemLabelGenerator(PedidoEtapa::getNome);
        ArrayList<PedidoEtapa> etapas = new ArrayList<PedidoEtapa>();
        for (KanbanPedidos kp : this.kanbanList) {
            if (kp.getPedidoEtapa().getId().equals(pedido.getPedidoEtapaId())) continue;
            etapas.add(kp.getPedidoEtapa());
        }
        cbMove.setItems(etapas);
        Dialog d = new Dialog();
        Button btnConfirmar = UIUtils.createSmallButton((String)"Confirmar");
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar");
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> d.close());
        btnConfirmar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cbMove.getValue() == null) {
                this.showNotification("Selecione uma etapa para movimentar");
                return;
            }
            this.contentContainer.getChildren().forEach(kc -> {
                if (kc.getClass().equals(KanbanColunaView.class)) {
                    KanbanColunaView kcv = (KanbanColunaView)kc;
                    KanbanPedidos kp = kcv.getKp();
                    if (kp.getPedidoEtapa().getId().equals(pedido.getPedidoEtapaId())) {
                        kcv.removeCard(card);
                    }
                    if (kp.getPedidoEtapa().getId().equals(((PedidoEtapa)cbMove.getValue()).getId())) {
                        kcv.addCard(card, false);
                    }
                }
            });
            this.pedidoService.alterarEtapaPedido(pedido.getId(), (PedidoEtapa)cbMove.getValue(), this.eu);
            UIUtils.showNotification((String)"Atividade movido com sucesso");
            d.close();
        });
        d.add(new Component[]{new VerticalContainer(new Component[]{UIUtils.createHeader((String)"Mover atividade"), cbMove, new FooterContainer(new Component[]{btnFechar, btnConfirmar})})});
        d.open();
    }

    private void abrePedido(Pedido pedido) {
        this.abrePedido(pedido, null);
    }

    private void abrePedido(Pedido pedido, List<ProducaoPedidoDTO> lista) {
        this.listaAutomatica = lista;
        this.atividadeView.addOpenedChangeListener((ComponentEventListener & Serializable)s -> {
            if (s.isOpened()) {
                return;
            }
            if (this.listaAutomatica != null && !this.listaAutomatica.isEmpty() && (this.ordenacaoAsc.booleanValue() && this.indicePedido + 1 < this.listaAutomatica.size() || !this.ordenacaoAsc.booleanValue() && this.indicePedido >= 0)) {
                Integer n = this.indicePedido;
                this.indicePedido = this.indicePedido + 1;
                if (this.indicePedido >= this.listaAutomatica.size() - 1) {
                    this.showNotification("Pule para a proxima pagina");
                    return;
                }
                Pedido ped = this.pedidoService.getById(((ProducaoPedidoDTO)this.listaAutomatica.get(this.indicePedido)).getId());
                if (ped == null) {
                    this.showNotification("Pule para a proxima pagina");
                } else {
                    this.abrePedido(ped, this.listaAutomatica);
                }
            } else {
                this.updateContent();
            }
        });
        if (pedido != null && pedido.getId() != null && pedido.getLeadSistema() != null && pedido.getLeadSistema().equals((Object)LeadTypeEnum.RETORNO_FUTURO)) {
            pedido.setLeadSistema(null);
            pedido = this.pedidoService.salvar(pedido);
        }
        this.atividadeView.create(pedido, this.eu, (PedidoTipoEnum)this.rbTipo.getValue(), this.produtos);
    }

    private boolean haveNotificacoes(ProducaoPedidoDTO pedido) {
        for (Long pn : this.listaNotificacoes) {
            if (!pn.equals(pedido.getId())) continue;
            return true;
        }
        return false;
    }

    private void criarWhats() {
        this.whatsAppAtendimentoCreate.create(this.getEu());
        this.whatsAppAtendimentoCreate.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened()) {
                this.updateContent();
            }
        });
    }

    private Image getImageNewMessage() {
        Image iconNewMessage = new Image();
        iconNewMessage.setSrc("images/whats.gif");
        iconNewMessage.setWidth("20px");
        iconNewMessage.setHeight("20px");
        return iconNewMessage;
    }

    private void removeNewIcon(Button bWhats, boolean isNew) {
        bWhats.setIcon((Component)VaadinIcon.COMMENTS_O.create());
        if (isNew) {
            this.setTitle(Integer.valueOf(-1));
        }
    }

    private void povoaProdutos() {
        this.produtos = this.produtoService.getProdutosByOrigem(this.getEstrutura(), this.po);
    }

    private void whatsOppenedRegistration() {
        this.whatsRegistration = this.whatsAppViewDialog.addOpenedChangeListener((ComponentEventListener & Serializable)open -> {
            if (!open.isOpened()) {
                this.pedidoIdAberto = null;
                this.updateContent();
                this.monitoramento(true);
            } else {
                this.monitoramento(false);
            }
        });
    }
}

