/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.layout;

import br.com.system.app.features.layout.Border;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.size.Bottom;
import br.com.system.app.features.layout.size.Left;
import br.com.system.app.features.layout.size.Right;
import br.com.system.app.features.layout.size.Size;
import br.com.system.app.features.layout.size.Top;
import br.com.system.app.features.layout.util.BorderRadius;
import br.com.system.app.features.layout.util.BoxSizing;
import br.com.system.app.features.layout.util.Display;
import br.com.system.app.features.layout.util.Overflow;
import br.com.system.app.features.layout.util.Position;
import br.com.system.app.features.layout.util.Shadow;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import java.util.ArrayList;

public class FlexBoxLayout
extends FlexLayout {
    private static final long serialVersionUID = 1L;
    public static final String BACKGROUND_COLOR = "background-color";
    public static final String BORDER_RADIUS = "border-radius";
    public static final String BOX_SHADOW = "box-shadow";
    public static final String BOX_SIZING = "box-sizing";
    public static final String DISPLAY = "display";
    public static final String FLEX_DIRECTION = "flex-direction";
    public static final String FLEX_WRAP = "flex-wrap";
    public static final String MAX_WIDTH = "max-width";
    public static final String OVERFLOW = "overflow";
    public static final String POSITION = "position";
    private final ArrayList<Size> spacings;
    private Object dataObject;

    public Object getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(Object dataObject) {
        this.dataObject = dataObject;
    }

    public FlexBoxLayout() {
        this.spacings = new ArrayList();
    }

    public FlexBoxLayout(Component ... components) {
        super(components);
        this.spacings = new ArrayList();
    }

    public FlexBoxLayout(FlexLayout.FlexDirection direction, Component ... components) {
        super(components);
        this.setFlexDirection(direction);
        this.spacings = new ArrayList();
    }

    public FlexBoxLayout setPaddingS() {
        this.setPadding(new Size[]{Bottom.S, Top.S, Left.S, Right.S});
        return this;
    }

    public FlexBoxLayout setPaddingXS() {
        this.setPadding(new Size[]{Bottom.XS, Top.XS, Left.XS, Right.XS});
        return this;
    }

    public FlexBoxLayout setPaddingM() {
        this.setPadding(new Size[]{Bottom.M, Top.M, Left.M, Right.M});
        return this;
    }

    public FlexBoxLayout setSpacingS() {
        this.setSpacing(new Size[]{Bottom.S, Top.S, Left.S, Right.S});
        return this;
    }

    public FlexBoxLayout setSpacingXS() {
        this.setSpacing(new Size[]{Bottom.XS, Top.XS, Left.XS, Right.XS});
        return this;
    }

    public FlexBoxLayout setSpacingM() {
        this.setSpacing(new Size[]{Bottom.M, Top.M, Left.M, Right.M});
        return this;
    }

    public FlexBoxLayout setBorder(Border.Style style, String width, Color color) {
        this.getStyle().set("border-style", style.getValue());
        this.getStyle().set("border-width", width);
        this.getStyle().set("border-color", color.getValue());
        return this;
    }

    public FlexBoxLayout identify(Color color) {
        this.setBorder(Border.Style.SOLID, "2px", color);
        this.setMargin(new Size[]{Bottom.M, Top.M, Left.M, Right.M});
        return this;
    }

    public FlexBoxLayout setBackgroundColor(Color color) {
        return this.setBackgroundColor(color.getValue());
    }

    public FlexBoxLayout setBackgroundColor(String value) {
        this.getStyle().set(BACKGROUND_COLOR, value);
        return this;
    }

    public FlexBoxLayout setBackgroundColor(String value, String theme) {
        this.getStyle().set(BACKGROUND_COLOR, value);
        this.setTheme(theme);
        return this;
    }

    public FlexBoxLayout removeBackgroundColor() {
        if (this.getStyle().has(BACKGROUND_COLOR)) {
            this.getStyle().remove(BACKGROUND_COLOR);
        }
        return this;
    }

    public FlexBoxLayout setBorderRadius(BorderRadius radius) {
        this.getStyle().set(BORDER_RADIUS, radius.getValue());
        return this;
    }

    public FlexBoxLayout removeBorderRadius() {
        this.getStyle().remove(BORDER_RADIUS);
        return this;
    }

    public FlexBoxLayout setBoxSizing(BoxSizing sizing) {
        this.getStyle().set(BOX_SIZING, sizing.getValue());
        return this;
    }

    public FlexBoxLayout removeBoxSizing() {
        this.getStyle().remove(BOX_SIZING);
        return this;
    }

    public FlexBoxLayout setDisplay(Display display) {
        this.getStyle().set(DISPLAY, display.getValue());
        return this;
    }

    public FlexBoxLayout removeDisplay() {
        this.getStyle().remove(DISPLAY);
        return this;
    }

    public void setFlex(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("flex", value);
        }
    }

    public void setFlexBasis(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("flex-basis", value);
        }
    }

    public FlexBoxLayout removeFlexDirection() {
        this.getStyle().remove(FLEX_DIRECTION);
        return this;
    }

    public void setFlexShrink(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("flex-shrink", value);
        }
    }

    public FlexBoxLayout removeFlexWrap() {
        this.getStyle().remove(FLEX_WRAP);
        return this;
    }

    public FlexBoxLayout setMargin(Size ... sizes) {
        for (Size size : sizes) {
            for (String attribute : size.getMarginAttributes()) {
                this.getStyle().set(attribute, size.getVariable());
            }
        }
        return this;
    }

    public FlexBoxLayout removeMargin() {
        this.getStyle().remove("margin");
        this.getStyle().remove("margin-bottom");
        this.getStyle().remove("margin-left");
        this.getStyle().remove("margin-right");
        this.getStyle().remove("margin-top");
        return this;
    }

    public void setMaxWidth(String value) {
        this.getStyle().set(MAX_WIDTH, value);
    }

    public FlexBoxLayout removeMaxWidth() {
        this.getStyle().remove(MAX_WIDTH);
        return this;
    }

    public FlexBoxLayout setOverflow(Overflow overflow) {
        this.getStyle().set(OVERFLOW, overflow.getValue());
        return this;
    }

    public FlexBoxLayout removeOverflow() {
        this.getStyle().remove(OVERFLOW);
        return this;
    }

    public FlexBoxLayout setPadding(Size ... sizes) {
        this.removePadding();
        for (Size size : sizes) {
            for (String attribute : size.getPaddingAttributes()) {
                this.getStyle().set(attribute, size.getVariable());
            }
        }
        return this;
    }

    public FlexBoxLayout removePadding() {
        this.getStyle().remove("padding");
        this.getStyle().remove("padding-bottom");
        this.getStyle().remove("padding-left");
        this.getStyle().remove("padding-right");
        this.getStyle().remove("padding-top");
        return this;
    }

    public FlexBoxLayout setPosition(Position position) {
        this.getStyle().set(POSITION, position.getValue());
        return this;
    }

    public FlexBoxLayout removePosition() {
        this.getStyle().remove(POSITION);
        return this;
    }

    public FlexBoxLayout setShadow(Shadow shadow) {
        this.getStyle().set(BOX_SHADOW, shadow.getValue());
        return this;
    }

    public FlexBoxLayout removeShadow() {
        this.getStyle().remove(BOX_SHADOW);
        return this;
    }

    public FlexBoxLayout setSpacing(Size ... sizes) {
        this.removeSpacing();
        for (Size size : sizes) {
            this.addClassName(size.getSpacingClassName());
            this.spacings.add(size);
        }
        return this;
    }

    public void removeSpacing() {
        for (Size spacing : this.spacings) {
            this.removeClassName(spacing.getSpacingClassName());
        }
        this.spacings.clear();
    }

    public FlexBoxLayout setTheme(String theme) {
        if ("dark".equals(theme)) {
            this.getElement().setAttribute("theme", "dark");
        } else {
            this.getElement().removeAttribute("theme");
        }
        return this;
    }
}

