/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.login;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.login.model.DoisFatoresDesativacao;
import br.com.system.app.features.login.service.DoisFatoresService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="desbloquear-2fa", layout=MainLayout.class)
@PageTitle(value="Desbloquear 2FA")
@RolesAllowed(value={"MASTER"})
public class DesbloquearDoisFatoresView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final DoisFatoresService dfs;
    private GridCrud<DoisFatoresDesativacao> crud;

    @Autowired
    public DesbloquearDoisFatoresView(DoisFatoresService dfs) {
        this.dfs = dfs;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        VerticalContainer v = new VerticalContainer(new Component[0]);
        this.crud = new GridCrud(DoisFatoresDesativacao.class);
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getUsuario().getNome()))).setHeader("Nome").setFlexGrow(0).setWidth("300px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getUsuario().getLogin()))).setHeader("Login").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getObservacao()))).setHeader("Desativacoes").setFlexGrow(0).setWidth("350px");
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        Button btnDesbloquear = UIUtils.createSmallButton((String)"Desbloquear");
        btnDesbloquear.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione um usu\u00e1rio para desbloquear");
                return;
            }
            DoisFatoresDesativacao selecionado = (DoisFatoresDesativacao)this.crud.getGrid().getSelectedItems().iterator().next();
            if (selecionado == null) {
                this.showNotification("Selecione um usu\u00e1rio para desbloquear");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Desbloquear 2FA", "Confirma desbloqueio deste usu\u00e1rio?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                cd.close();
                this.dfs.desbloquear(selecionado);
                this.crud.refreshGrid();
            });
        });
        v.add(new Component[]{btnDesbloquear, this.crud});
        return v;
    }
}

