/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.modeloproposta;

import br.com.system.app.MainLayout;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.modeloproposta.ModeloPropostaForm;
import br.com.system.app.features.modeloproposta.model.ModeloProposta;
import br.com.system.app.features.modeloproposta.repository.ModeloPropostaRepository;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.CrudOperation;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="modelo-proposta", layout=MainLayout.class)
@PageTitle(value="Modelo Proposta")
@RolesAllowed(value={"MODELO_PROPOSTA_VIEW"})
public class ModeloPropostaView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ModeloPropostaRepository repository;
    private final EquipeService equipeService;
    private GridCrud<ModeloProposta> crud;

    @Autowired
    public ModeloPropostaView(ModeloPropostaRepository repository, EquipeService equipeService) {
        this.repository = repository;
        this.equipeService = equipeService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        Button btnAdd = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar modelo");
        btnAdd.addClickListener((ComponentEventListener & Serializable)e -> this.openForm(new ModeloProposta()));
        this.crud = new GridCrud(ModeloProposta.class);
        this.crud.getCrudLayout().addToolbarComponent((Component)btnAdd);
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
            Button edit = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Editar modelo");
            edit.addClickListener((ComponentEventListener & Serializable)ex -> this.openForm(p));
            return edit;
        })).setFlexGrow(0).setWidth("50px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNome()))).setHeader("Nome").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getAtivo() != false ? "Ativo" : "Inativo")).setHeader("Ativo").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().setColumnReorderingAllowed(true);
        this.crud.getCrudFormFactory().setVisibleProperties(CrudOperation.DELETE, new String[]{"nome"});
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.hasPermission("MODELO_PROPOSTA_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }

    private void openForm(ModeloProposta modeloProposta) {
        ModeloPropostaForm form = new ModeloPropostaForm(this.getEu(), this.repository, modeloProposta, this.equipeService);
        form.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened()) {
                this.crud.refreshGrid();
            }
        });
    }
}

