/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.repository;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.repository.PedidoRepositoryQuery;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface PedidoRepository
extends JpaRepository<Pedido, Long>,
PedidoRepositoryQuery,
Serializable {
    @Query(nativeQuery=true, value="select p.id from pedido p,estrutura_usuario eu WHERE p.estrutura_usuario_id=eu.id and eu.estrutura_id=:estruturaId AND p.data_hora_atualizacao>=:dtIni and p.data_hora_atualizacao <=:dtFim")
    public Set<Long> findByEstruturaUsuarioEstruturaAndDataHoraAtualizacaoBetween(@Param(value="estruturaId") Long var1, @Param(value="dtIni") LocalDateTime var2, @Param(value="dtFim") LocalDateTime var3);

    public Pedido findFirstByEstruturaUsuarioEstruturaAndClienteIdOrderByIdDesc(Estrutura var1, Long var2);

    public List<Pedido> findByNumeroAndEstruturaUsuarioEstrutura(String var1, Estrutura var2);

    public Pedido findFirstByNumeroSimulacaoAndEstruturaUsuarioEstrutura(@Param(value="numeroSimulacao") String var1, @Param(value="estrutura") Estrutura var2);

    public Pedido findFirstByCotacaoAndEstruturaUsuarioEstrutura(String var1, Estrutura var2);

    public List<Pedido> findByNumeroAndEstruturaUsuarioEstruturaOrderByDataHoraAtualizacaoAscEstruturaUsuarioIdAsc(String var1, Estrutura var2);

    public Integer countByEstruturaUsuarioEstruturaAndDataCadastroAndTagsContains(Estrutura var1, LocalDate var2, String var3);

    public Pedido findByHashProposta(String var1);

    public List<Pedido> findByCliente(Cliente var1);

    @Query(value="select p.id from Pedido p where tags is not null and tags !=''")
    public List<Long> findAllComTags();

    @Modifying
    @Query(value="update Pedido p set p.dataHoraAtualizacao=current_timestamp(),p.dataHoraUltimaMov=current_timestamp(),p.pedidoEtapa=:pedidoEtapa where p=:pedido and p.pedidoEtapa!=:pedidoEtapa")
    public void updatePedidoEtapa(@Param(value="pedidoEtapa") PedidoEtapa var1, @Param(value="pedido") Pedido var2);

    @Modifying
    @Transactional
    @Query(nativeQuery=true, value="update pedido p,pedido_etapa pe,estrutura_usuario eu set p.data_hora_ultima_mov=current_timestamp(),p.data_hora_atualizacao=current_timestamp(),p.pedido_etapa_id=:pedidoEtapaId  where p.estrutura_usuario_id=eu.id and p.pedido_etapa_id=pe.id and pe.estrutura_id=eu.estrutura_id and  pe.editavel=1 AND p.id in :ids and p.pedido_etapa_id!=:pedidoEtapaId")
    public void updateListaPedidoEtapa(@Param(value="pedidoEtapaId") Long var1, @Param(value="ids") Set<Long> var2);

    @Modifying
    @Transactional
    @Query(nativeQuery=true, value="update pedido p,pedido_etapa pe,estrutura_usuario eu set p.data_hora_ultima_mov=current_timestamp(), p.data_hora_atualizacao=current_timestamp(),p.pedido_etapa_id=:pedidoEtapaId  where p.estrutura_usuario_id=eu.id and p.pedido_etapa_id=pe.id and pe.estrutura_id=eu.estrutura_id AND p.id in :ids and p.pedido_etapa_id!=:pedidoEtapaId")
    public void updateListaPedidoEtapaForcar(@Param(value="pedidoEtapaId") Long var1, @Param(value="ids") Set<Long> var2);

    @Modifying
    @Transactional
    @Query(nativeQuery=true, value="update pedido p,pedido_etapa pe,estrutura_usuario eu set p.data_hora_ultima_mov=current_timestamp(), p.data_hora_atualizacao=current_timestamp(),p.pedido_etapa_id=:pedidoEtapaId  where p.estrutura_usuario_id=eu.id and p.pedido_etapa_id=pe.id and pe.estrutura_id=eu.estrutura_id and pe.editavel=1  and p.numero in :numeros and p.pedido_etapa_id!=:pedidoEtapaId")
    public void updateListaPedidoEtapaByNumero(@Param(value="pedidoEtapaId") Long var1, @Param(value="numeros") List<String> var2);

    @Modifying
    @Transactional
    @Query(nativeQuery=true, value="update pedido p,pedido_etapa pe,estrutura_usuario eu set p.data_hora_ultima_mov=current_timestamp(), p.data_hora_atualizacao=current_timestamp(),p.pedido_etapa_id=:pedidoEtapaId  where p.estrutura_usuario_id=eu.id and p.pedido_etapa_id=pe.id and pe.estrutura_id=eu.estrutura_id and p.numero in :numeros and p.pedido_etapa_id!=:pedidoEtapaId")
    public void updateListaPedidoEtapaByNumeroForcar(@Param(value="pedidoEtapaId") Long var1, @Param(value="numeros") List<String> var2);

    @Modifying
    @Query(nativeQuery=true, value="update pedido p,pedido_etapa pe,estrutura_usuario eu set p.data_hora_atualizacao=current_timestamp(), p.estrutura_usuario_id=:euId  where p.estrutura_usuario_id=eu.id and p.pedido_etapa_id=pe.id and pe.estrutura_id=eu.estrutura_id and pe.editavel=1 and p.id in :ids")
    public void updateListaPedidoUsuario(@Param(value="euId") Long var1, @Param(value="ids") Set<Long> var2);

    @Modifying
    @Query(nativeQuery=true, value="update pedido p,pedido_etapa pe,estrutura_usuario eu  set p.data_hora_atualizacao=current_timestamp(), p.estrutura_usuario_id=:euId  where p.estrutura_usuario_id=eu.id and p.pedido_etapa_id=pe.id and  pe.estrutura_id=eu.estrutura_id and p.id in :ids")
    public void updateListaPedidoUsuarioForcar(@Param(value="euId") Long var1, @Param(value="ids") Set<Long> var2);

    @Modifying
    @Query(nativeQuery=true, value="update pedido p,pedido_etapa pe set p.data_hora_atualizacao=current_timestamp(), p.estrutura_usuario_adm_id=:euId  where p.pedido_etapa_id=pe.id and p.id in :ids")
    public void updateListaPedidoUsuarioAdm(@Param(value="euId") Long var1, @Param(value="ids") Set<Long> var2);

    @Query(value="SELECT p FROM Pedido p WHERE p.estruturaUsuario.id in :listaEuId AND p.dataHoraAtualizacao >=:dateStart AND p.dataHoraAtualizacao <=:dateEnd ORDER BY p.estruturaUsuario.usuario.nome")
    public List<Pedido> findByListaEuAndDateBetween(@Param(value="listaEuId") Set<Long> var1, @Param(value="dateStart") LocalDateTime var2, @Param(value="dateEnd") LocalDateTime var3);

    public List<Pedido> findByPedidoEtapa(PedidoEtapa var1);

    @Modifying
    @Query(nativeQuery=true, value="update pedido set numero=:numero where id=:pedidoId")
    public void updateNumero(@Param(value="pedidoId") Long var1, @Param(value="numero") String var2);

    public List<Pedido> findByDataRetornoFuturoBefore(LocalDate var1);

    public List<Pedido> findByEstruturaUsuarioEstruturaAndNumeroPedidoVinculado(Estrutura var1, String var2);

    public Set<Pedido> findByEstruturaUsuarioEstruturaId(Long var1);
}

