/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.repository;

import br.com.system.app.features.pedido.dto.PedidoStatusDTO;
import br.com.system.app.features.pedido.repository.PedidoStatusRepositoryQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public class PedidoStatusRepositoryImpl
implements PedidoStatusRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public List<PedidoStatusDTO> findByListPedido(Long eId, @Param(value="lista") Set<Long> lista, LocalDateTime dataUltimaCarga) {
        Object sql = "select (select uuid_short()) as id,p.id pedido_id,p.numero  numero_atividade,pe.nome nome_etapa,u_entrou.nome usuario_entrou,u_saiu.nome usuario_saiu,ps.data_hora_entrou,ps.data_hora_saiu, NEO_TIMEDIFF(ps.data_hora_entrou,ps.data_hora_saiu) tempo,pe.sla_horas,eu_entrou.id eu_entrou_id,eu_saiu.id eu_saiu_id,pe.id etapa_id,\n p.total,p.compromisso_mensal,u.nome nome_consultor, p.tags tags_atividade,ps.movimentacao from pedido_status ps\n join pedido p on (p.id=ps.pedido_id) \n join pedido_etapa pe on (ps.pedido_etapa_id=pe.id) \n join estrutura_usuario eu on (p.estrutura_usuario_id=eu.id) join usuario u on (eu.usuario_id=u.id) left join estrutura_usuario eu_entrou on (ps.estrutura_usuario_entrou_id=eu_entrou.id) \n left join usuario u_entrou on (eu_entrou.usuario_id=u_entrou.id)\n left join estrutura_usuario eu_saiu on (ps.estrutura_usuario_saiu_id=eu_saiu.id)\n left join usuario u_saiu on (eu_saiu.usuario_id=u_saiu.id) WHERE eu.estrutura_id=:estruturaId";
        if (lista != null && !lista.isEmpty()) {
            sql = (String)sql + " AND ps.pedido_id in :lista";
        }
        if (dataUltimaCarga != null) {
            sql = (String)sql + " AND p.data_hora_atualizacao >=:dataUltimaCarga";
        }
        Query query = this.manager.createNativeQuery((String)sql, PedidoStatusDTO.class);
        query.setParameter("estruturaId", (Object)eId);
        if (lista != null && !lista.isEmpty()) {
            query.setParameter("lista", lista);
        }
        if (dataUltimaCarga != null) {
            query.setParameter("dataUltimaCarga", (Object)dataUltimaCarga);
        }
        return query.getResultList();
    }
}

