/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.repository.PedidoEmailRepository;
import br.com.system.app.features.pedido.repository.PedidoNotificacaoRepository;
import br.com.system.app.features.pedido.repository.PedidoRepository;
import br.com.system.app.features.pedido.service.PedidoAnexoService;
import br.com.system.app.features.pedido.service.PedidoAudioService;
import br.com.system.app.features.pedido.service.PedidoItemDadosService;
import br.com.system.app.features.pedido.service.PedidoItemService;
import br.com.system.app.features.pedido.service.PedidoLogService;
import br.com.system.app.features.pedido.service.PedidoStatusService;
import br.com.system.app.features.producaopainel.repository.ProducaoPainelResumoRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.repository.WhatsAppAtendimentoRepository;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PedidoDeleteService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoLogService pedidoLogService;
    @Autowired
    private PedidoStatusService pedidoStatusService;
    @Autowired
    private PedidoAnexoService pedidoAnexoService;
    @Autowired
    private PedidoEmailRepository pedidoEmailRepository;
    @Autowired
    private PedidoItemService pedidoItemService;
    @Autowired
    private PedidoNotificacaoRepository pedidoNotificacaoRepository;
    @Autowired
    private WhatsAppAtendimentoRepository whatsAppAtendimentoRepository;
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private PedidoAudioService pedidoAudioService;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private ProducaoPainelResumoRepository producaoPainelResumoRepository;
    @Autowired
    private PedidoItemDadosService pedidoItemDadosService;

    @Async(value="asyncDefault")
    public void deletarByLista(Set<String> lista, EstruturaUsuario eu) {
        StringBuilder mensagem = new StringBuilder();
        for (String numero : lista) {
            try {
                this.deletarByNumero(numero, eu.getEstrutura());
                mensagem.append(numero).append(" excluido com sucesso\n");
            }
            catch (Exception e) {
                mensagem.append(numero).append(" erro ao excluir: ").append(e.getMessage());
            }
        }
        this.notificacoesService.notify(eu, "Exclus\u00e3o de pedidos", mensagem.toString());
    }

    public void deletarByNumero(String numero, Estrutura estrutura) throws Exception {
        List pedidos = this.pedidoRepository.findByNumeroAndEstruturaUsuarioEstrutura(numero, estrutura);
        if (pedidos == null) {
            throw new BusinessException("Pedido nao encontrado.");
        }
        for (Pedido pedido : pedidos) {
            this.delete(pedido);
        }
    }

    @Transactional
    public void delete(Pedido pedido) throws Exception {
        this.delete(pedido, Boolean.valueOf(true));
    }

    @Transactional
    public void delete(Pedido pedido, Boolean excluirAnexoBucket) throws Exception {
        this.pedidoStatusService.deleteByPedido(pedido);
        this.pedidoAnexoService.deleteByPedido(pedido, excluirAnexoBucket);
        this.pedidoLogService.deleteByPedido(pedido);
        this.pedidoEmailRepository.deleteByPedido(pedido);
        this.pedidoItemDadosService.deleteByPedido(pedido);
        this.pedidoItemService.deleteByPedido(pedido);
        this.pedidoNotificacaoRepository.deleteByPedido(pedido);
        this.pedidoAudioService.deleteByPedido(pedido);
        this.producaoPainelResumoRepository.deleteByPedidoId(pedido.getId());
        WhatsAppAtendimento a = this.whatsAppAtendimentoRepository.findFirstByPedidoId(pedido.getId());
        if (a != null) {
            this.whatsAppAtendimentoRepository.delete((Object)a);
        }
        this.pedidoRepository.delete((Object)pedido);
    }

    @Transactional
    public void deleteItens(Pedido pedido) {
        this.pedidoItemService.deleteByPedido(pedido);
    }
}

