/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.components.Card;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.features.estrutura.model.EstruturaSenhas;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaSenhasService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoTipoNegociacaoEnum;
import br.com.system.app.features.pedido.service.PedidoVinculoService;
import br.com.system.commons.StringUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.util.Collection;

public class DialogVincularProvedor
extends Dialog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Pedido pedido;
    private final EstruturaUsuario euContext;
    private final PedidoVinculoService pedidoVinculoService;
    private final EstruturaSenhasService estruturaSenhasService;

    public DialogVincularProvedor(Pedido pedido, EstruturaUsuario euContext, PedidoVinculoService pedidoVinculoService, EstruturaSenhasService estruturaSenhasService) {
        this.pedido = pedido;
        this.estruturaSenhasService = estruturaSenhasService;
        this.euContext = euContext;
        this.pedidoVinculoService = pedidoVinculoService;
    }

    public Pedido getPedido() {
        return this.pedido;
    }

    public void create() {
        Card card = new Card();
        card.setHeader("Vincular");
        ComboBox cbSenhas = new ComboBox("Login", (Collection)this.estruturaSenhasService.getAtivosByEstrutura(this.euContext.getEstrutura()));
        cbSenhas.setItemLabelGenerator(EstruturaSenhas::getNomeAndSistema);
        cbSenhas.setValue((Object)this.pedido.getEstruturaSenhas());
        this.setWidth("400px");
        cbSenhas.setWidth("300px");
        TextField numeroPedido = new TextField("Pedido Operadora");
        numeroPedido.setWidth("200px");
        numeroPedido.setValue(this.pedido.getNumeroPedidoVinculado() == null ? "" : this.pedido.getNumeroPedidoVinculado());
        RadioButtonGroup rbNegociacao = new RadioButtonGroup();
        rbNegociacao.setItems((Object[])PedidoTipoNegociacaoEnum.values());
        rbNegociacao.setLabel("Cliente base ou Novo");
        rbNegociacao.setValue((Object)(this.pedido.getTipoNegociacao() == null ? PedidoTipoNegociacaoEnum.NOVO : this.pedido.getTipoNegociacao()));
        Button btnDesvincular = UIUtils.createSmallButton((String)"Desvincular", (VaadinIcon)VaadinIcon.UNLINK, (String)"Desvincular pedido");
        btnDesvincular.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Desvincular", "Confirma desvincular Pedido?");
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                this.pedidoVinculoService.desvincularSingle(this.pedido, this.euContext);
                this.close();
                cd.close();
                UIUtils.showNotification((String)"Desvinculado com sucesso.");
            });
        });
        Button btn = UIUtils.createSmallButton((String)"Vincular", (VaadinIcon)VaadinIcon.CHECK, (String)"Vincular pedido");
        btn.addClickListener((ComponentEventListener & Serializable)e -> {
            if (numeroPedido.isEmpty() || cbSenhas.getValue() == null) {
                UIUtils.showNotification((String)"Informe o n\u00famero e selecione um login");
                return;
            }
            if (numeroPedido.getValue().equals(this.pedido.getNumero())) {
                UIUtils.showNotification((String)"Voc\u00ea n\u00e3o pode vincular o pedido com ele mesmo.");
                return;
            }
            if (rbNegociacao.getValue() == null) {
                UIUtils.showNotification((String)"Selecione se \u00e9 cliente novo ou base");
                return;
            }
            try {
                String numero = StringUtil.removeLineBreaks((String)numeroPedido.getValue().trim());
                this.pedido = this.pedidoVinculoService.vincularSingle(this.pedido, (EstruturaSenhas)cbSenhas.getValue(), this.euContext, numero, null, (PedidoTipoNegociacaoEnum)rbNegociacao.getValue(), null, null, null, null, null);
                if (this.pedido != null) {
                    UIUtils.showNotification((String)"Vinculado com sucesso");
                } else {
                    UIUtils.showNotification((String)"Esta cota\u00e7\u00e3o ainda n\u00e3o baixou, por favor aguarde alguns minutos e tente novamente.");
                }
                this.close();
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)("Erro: " + ex.getMessage()));
            }
        });
        Button btnClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"");
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        card.setContent(new Component[]{UIUtils.createSpan((FontSize)FontSize.S, (String)("Pedido: " + this.pedido.getNumero())), UIUtils.createSpan((FontSize)FontSize.S, (String)("Cliente: " + this.pedido.getCliente().getNome())), cbSenhas, numeroPedido, rbNegociacao});
        card.setFooter(new Component[]{btnClose, btnDesvincular, btn});
        card.getFooterBox().setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        this.add(new Component[]{card});
        this.open();
    }
}

