/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoAnexo;
import br.com.system.app.features.pedido.service.PedidoAnexoService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class PedidoAnexoView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PedidoAnexoService pedidoAnexoService;
    private final Pedido pedido;
    private Grid<PedidoAnexo> grid;
    private final EstruturaUsuario eu;
    private DownloadDialog dd;
    private List<PedidoAnexo> lista;

    public PedidoAnexoView(Pedido pedido, EstruturaUsuario eu, PedidoAnexoService pedidoAnexoService) {
        this.pedidoAnexoService = pedidoAnexoService;
        this.pedido = pedido;
        this.eu = eu;
        if (this.hasPermission("PEDIDO_ANEXOS_VIEW")) {
            this.init();
        } else {
            UIUtils.showNotification((String)"Voc\u00ea n\u00e3o tem Permiss\u00e3o para visualisar anexos");
        }
    }

    private String getZip() {
        try {
            File zipFile = new File("/tmp/" + HashUtil.getUUI() + ".zip");
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            int ind = 0;
            for (PedidoAnexo pa : this.lista) {
                InputStream is = StorageUtil.getObject((String)this.getArquivo(pa));
                ZipEntry ze = new ZipEntry(++ind + "-" + StringUtil.normalize((String)pa.getNomeArquivo()));
                zos.putNextEntry(ze);
                byte[] bytes = new byte[1024];
                int count = is.read(bytes);
                while (count > -1) {
                    zos.write(bytes, 0, count);
                    count = is.read(bytes);
                }
                is.close();
                zos.closeEntry();
            }
            zos.close();
            byte[] fileContent = Files.readAllBytes(zipFile.toPath());
            zipFile.delete();
            return StorageUtil.uploadObjectByteArray((String)(HashUtil.getUUI() + ".zip"), (byte[])fileContent);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    private void init() {
        this.dd = new DownloadDialog();
        this.setWidth("910px");
        TempFileMultiBuffer buffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)buffer);
        upload.setMaxFiles(30);
        Button btnDown = UIUtils.createButton((String)"Baixar Todos", (String)"Baixar todos os arquivos em ZIP", (ButtonVariant[])new ButtonVariant[0]);
        btnDown.addClickListener((ComponentEventListener & Serializable)e -> this.dd.open(this.getZip(), "Atividade-anexo.zip", true));
        Button btnGravar = UIUtils.createSmallButton((String)"Gravar", (VaadinIcon)VaadinIcon.INBOX, (String)"Salvar registro");
        btnGravar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (!this.hasPermission("PEDIDO_ANEXOS_SAVE")) {
                UIUtils.showNotification((String)"Sem permiss\u00e3o para incluir novos arquivos.");
                return;
            }
            if (buffer.getFiles().size() <= 0) {
                UIUtils.showNotification((String)"N\u00e3o h\u00e1 arquivos para gravar.");
                return;
            }
            this.pedidoAnexoService.save(this.pedido, this.eu, buffer);
            upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
            buffer.clear();
            this.povoa();
        });
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"");
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.add(new Component[]{new VerticalContainer(new Component[]{upload, this.createGrid(), new FooterContainer(new Component[]{btnFechar, btnDown, btnGravar})})});
        this.open();
    }

    private void povoa() {
        this.lista = this.pedidoAnexoService.getAnexo(this.pedido);
        this.grid.setItems((Collection)this.lista);
    }

    private HorizontalContainer createGrid() {
        this.grid = new Grid(PedidoAnexo.class);
        this.grid.setColumns(new String[0]);
        this.grid.setWidth("860px");
        if (this.hasPermission("PEDIDO_ANEXOS_DELETE")) {
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
                Button btn = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir anexo");
                btn.addClickListener((ComponentEventListener & Serializable)del -> {
                    ConfirmationDialog cd = new ConfirmationDialog("Exclus\u00e3o", "Confirma exclus\u00e3o do anexo?");
                    cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                    cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                        try {
                            this.pedidoAnexoService.delete(eg, this.getEu(), Boolean.valueOf(true));
                        }
                        catch (Exception e) {
                            UIUtils.showError((String)("Erro ao excluir anexo " + e.getMessage()));
                        }
                        cd.close();
                        this.povoa();
                    });
                });
                return btn;
            })).setFlexGrow(0).setWidth("50px");
        }
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPedido().getNumero())).setFlexGrow(0).setWidth("120px").setHeader("Numero");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoAnexo pa = e;
            return UIUtils.createBreakWrapSpan((String)pa.getNomeArquivo());
        })).setHeader("Nome Arquivo").setFlexGrow(0).setWidth("200px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHora().format(FormatDate.DATETIME_BR.toDTF()))).setFlexGrow(0).setWidth("180px").setHeader("Data/Hora");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoAnexo pa = e;
            return UIUtils.createBreakWrapSpan((String)pa.getEstruturaUsuario().getUsuario().getNome());
        })).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("160px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Button b = UIUtils.createSmallButton((String)"Download");
            b.setVisible(eg.getHashArquivo() != null && !eg.getHashArquivo().isEmpty());
            b.addClickListener((ComponentEventListener & Serializable)e -> {
                PedidoAnexo pa = eg;
                this.dd.open(this.getArquivo(pa), pa.getNomeArquivo());
            });
            return b;
        })).setFlexGrow(0).setWidth("120px").setHeader("Baixar");
        this.povoa();
        return new HorizontalContainer(new Component[]{this.grid});
    }

    private String getArquivo(PedidoAnexo pa) {
        String extensao = FileUtil.getExtension((String)pa.getNomeArquivo());
        Object arquivo = pa.getHashArquivo() == null ? "" : (pa.getHashArquivo().contains(extensao) ? pa.getHashArquivo() : pa.getHashArquivo() + extensao);
        if (!StorageUtil.haveObject((String)arquivo).booleanValue()) {
            if (StorageUtil.haveObject((String)(pa.getHashArquivo() + extensao.toUpperCase())).booleanValue()) {
                arquivo = pa.getHashArquivo() + extensao.toUpperCase();
            } else if (StorageUtil.haveObject((String)(pa.getHashArquivo() + extensao.toLowerCase())).booleanValue()) {
                arquivo = pa.getHashArquivo() + extensao.toLowerCase();
            }
        }
        return arquivo;
    }
}

