/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.components.InformationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoLog;
import br.com.system.app.features.pedido.model.PedidoMovimentacao;
import br.com.system.app.features.pedido.service.PedidoLogService;
import br.com.system.app.features.pedido.service.PedidoMovimentacaoService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PedidoMovimentacaoView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final Pedido pedido;
    private final PedidoLogService pls;
    private final PedidoMovimentacaoService pms;
    private final PedidoService pedidoService;
    private Grid<PedidoMovimentacao> grid;

    public PedidoMovimentacaoView(Pedido pedido, PedidoMovimentacaoService pms, PedidoLogService pls, PedidoService pedidoService) {
        this.pms = pms;
        this.pedidoService = pedidoService;
        this.pedido = pedido;
        this.pls = pls;
        this.create();
    }

    private void create() {
        this.setWidth("990px");
        this.add(new Component[]{this.getMov()});
        Button btnClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.add(new Component[]{new FooterContainer(new Component[]{btnClose, this.getBtnMov()})});
        this.add(new Component[]{this.getLog()});
        this.open();
    }

    private Button getBtnMov() {
        Button btnMov = UIUtils.createSmallButton((String)"Movimentar Pedido");
        btnMov.setEnabled(this.pedido.getPedidoEtapa().isEditavel() || this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
        btnMov.addClickListener((ComponentEventListener & Serializable)e -> {
            Dialog d = new Dialog();
            TextArea ta = new TextArea("Texto Movimenta\u00e7\u00e3o");
            ta.setWidth("230px");
            ta.setHeight("300px");
            Button b = UIUtils.createSmallButton((String)"Movimentar");
            b.setDisableOnClick(true);
            b.addClickListener((ComponentEventListener & Serializable)be -> {
                b.setEnabled(true);
                if (ta.getValue() == null || ta.getValue().isEmpty()) {
                    UIUtils.showNotification((String)"Informe um texto para movimentar");
                    return;
                }
                this.pms.insertMovimentacao(this.pedido.getId(), this.getEu(), ta.getValue());
                this.pedidoService.salvar(this.pedido);
                d.close();
                this.povoa();
            });
            Button f = UIUtils.createSmallButton((String)"Fechar");
            f.addClickListener((ComponentEventListener & Serializable)fe -> d.close());
            d.add(new Component[]{UIUtils.createHeader((String)"Movimenta\u00e7\u00e3o")});
            d.add(new Component[]{ta, new FooterContainer(new Component[]{f, b})});
            d.open();
        });
        return btnMov;
    }

    private VerticalContainer getMov() {
        VerticalContainer v = new VerticalContainer(new Component[0]);
        this.grid = new Grid(PedidoMovimentacao.class);
        this.grid.setColumns(new String[0]);
        this.grid.setWidth("98%");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPedido().getNumero())).setFlexGrow(0).setWidth("120px").setHeader("Numero");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHora().format(FormatDate.DATETIME_BR.toDTF()))).setFlexGrow(0).setWidth("180px").setHeader("Data/Hora");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoMovimentacao pm = e;
            return UIUtils.createBreakWrapSpan((String)pm.getEstruturaUsuario().getUsuario().getNome());
        })).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("200px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoMovimentacao pm = e;
            Span div = UIUtils.createBreakWrapSpan((String)"");
            Object text = pm.getDescricao().replace("\n", "<BR>");
            if (((String)text).length() > 500) {
                text = ((String)text).substring(0, 500) + "...";
            }
            div.getElement().setProperty("innerHTML", (String)text);
            return div;
        })).setHeader("Movimenta\u00e7\u00e3o").setFlexGrow(0).setWidth("400px");
        this.grid.addItemClickListener((ComponentEventListener & Serializable)e -> InformationDialog.show((String)"Movimenta\u00e7\u00e3o", (String)((PedidoMovimentacao)e.getItem()).getDescricao()));
        v.add(new Component[]{UIUtils.createHeader((String)("Movimenta\u00e7\u00f5es atividade " + this.pedido.getNumero()))});
        v.add(new Component[]{this.grid});
        this.povoa();
        return v;
    }

    private void povoa() {
        if (this.pedido.getNumeroPedidoOrigem() != null && !this.pedido.getNumeroPedidoOrigem().isBlank()) {
            List lista = this.pms.getByPedido(this.pedido);
            lista.addAll(this.pms.getByPedidoOrigem(this.pedido.getNumeroPedidoOrigem()));
            this.grid.setItems((Collection)lista);
        } else {
            this.grid.setItems((Collection)this.pms.getByPedido(this.pedido));
        }
    }

    private VerticalContainer getLog() {
        VerticalContainer v = new VerticalContainer(new Component[0]);
        Grid gridLog = new Grid(PedidoLog.class);
        gridLog.setColumns(new String[0]);
        gridLog.setWidth("98%");
        gridLog.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPedido().getNumero())).setFlexGrow(0).setWidth("120px").setHeader("Numero");
        gridLog.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHora().format(FormatDate.DATETIME_BR.toDTF()))).setFlexGrow(0).setWidth("180px").setHeader("Data/Hora");
        gridLog.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoLog pm = e;
            return UIUtils.createBreakWrapSpan((String)pm.getEstruturaUsuario().getUsuario().getNome());
        })).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("200px");
        gridLog.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoLog pm = e;
            return UIUtils.createBreakWrapSpan((String)pm.getAlteracoes());
        })).setHeader("Altera\u00e7\u00f5es").setFlexGrow(0).setWidth("300px");
        gridLog.setItems((Collection)this.pls.getByPedido(this.pedido));
        gridLog.addItemDoubleClickListener((ComponentEventListener & Serializable)e -> InformationDialog.show((String)"Log itens", (String)((PedidoLog)e.getItem()).getAlteracoes()));
        v.add(new Component[]{UIUtils.createHeader((String)("Log itens atividade " + this.pedido.getNumero() + " * (a partir de 28/01/2022)"))});
        v.add(new Component[]{gridLog});
        return v;
    }
}

